/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class TraceDebugFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private final Logger log;
    private boolean logHttp;

    TraceDebugFilter(boolean logHttp, Logger log) {
        this.logHttp = logHttp;
        this.log = log;
    }

    public TraceDebugFilter(boolean logHttp) {
        this(logHttp, LoggerFactory.getLogger(TraceDebugFilter.class));
    }

    private InputStream copyStream(InputStream entityStream, StringBuilder sb) throws IOException {
        if (entityStream != null) {
            try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
                IOUtils.copy((InputStream)entityStream, (OutputStream)bytes);
                sb.append(bytes.toString(StandardCharsets.UTF_8));
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes.toByteArray());
                return byteArrayInputStream;
            }
        }
        sb.append("<null stream>");
        return null;
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"})
    void log(String formattedMessage) {
        if (this.logHttp) {
            this.log.info(formattedMessage);
        } else {
            this.log.trace(formattedMessage);
        }
    }

    private String maskHeaderValues(List<Object> headerValues) {
        ArrayList<String> maskedList = new ArrayList<String>(headerValues.size());
        for (Object actualValue : headerValues) {
            maskedList.add(actualValue.toString().replaceAll(".", "*"));
        }
        return ((Object)maskedList).toString();
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (!this.logHttp && !this.log.isTraceEnabled()) {
            return;
        }
        this.log(">> REST Request: " + requestContext.getMethod() + " => " + requestContext.getUri());
        for (String key : requestContext.getHeaders().keySet()) {
            String headerVal = ((List)requestContext.getHeaders().get((Object)key)).toString();
            if (key.equals("X-Auth-Token")) {
                headerVal = this.maskHeaderValues((List)requestContext.getHeaders().get((Object)key));
            }
            this.log(">> Header: " + key + " = " + headerVal);
        }
        this.log(">> body: " + requestContext.getEntity());
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (!this.logHttp && !this.log.isTraceEnabled()) {
            return;
        }
        this.log("<< REST Response: " + responseContext.getStatus() + ":" + responseContext.getStatusInfo());
        for (String key : responseContext.getHeaders().keySet()) {
            this.log("<< Header: " + key + " = " + responseContext.getHeaders().get((Object)key));
        }
        this.log(">> Media Type: " + responseContext.getMediaType());
        if (responseContext.hasEntity()) {
            StringBuilder sb = new StringBuilder();
            responseContext.setEntityStream(this.copyStream(responseContext.getEntityStream(), sb));
            this.log(">> Entity:\n" + sb);
        }
    }
}

