/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.adapter.glossary;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.StringUtils;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.catalog.parse.MessageStreamParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.zanata.adapter.glossary.AbstractGlossaryPushReader;
import org.zanata.common.LocaleId;
import org.zanata.rest.dto.GlossaryEntry;
import org.zanata.rest.dto.GlossaryTerm;
import org.zanata.rest.dto.QualifiedName;

public class GlossaryPoReader
extends AbstractGlossaryPushReader {
    private static final Logger log = LoggerFactory.getLogger(GlossaryPoReader.class);
    private final LocaleId srcLang;
    private final LocaleId transLang;

    public GlossaryPoReader(LocaleId srcLang, LocaleId transLang) {
        this.srcLang = srcLang;
        this.transLang = transLang;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<LocaleId, List<GlossaryEntry>> extractGlossary(Reader reader, String qualifiedName) throws IOException {
        try (ReaderInputStream ris = new ReaderInputStream(reader);){
            InputSource potInputSource = new InputSource((InputStream)ris);
            potInputSource.setEncoding("utf8");
            Map<LocaleId, List<GlossaryEntry>> map = this.extractTemplate(potInputSource, qualifiedName);
            return map;
        }
    }

    private Map<LocaleId, List<GlossaryEntry>> extractTemplate(InputSource potInputSource, String qualifiedName) {
        MessageStreamParser messageParser = GlossaryPoReader.createParser(potInputSource);
        ArrayList<GlossaryEntry> entries = new ArrayList<GlossaryEntry>();
        while (messageParser.hasNext()) {
            Message message = messageParser.next();
            if (message.isHeader() || message.isObsolete() || message.isPlural()) continue;
            if (message.isFuzzy()) {
                log.warn("term: [{}] is ignored - state fuzzy", (Object)message.getMsgid());
                continue;
            }
            GlossaryEntry entry = new GlossaryEntry();
            entry.setQualifiedName(new QualifiedName(qualifiedName));
            entry.setSrcLang(this.srcLang);
            GlossaryTerm srcTerm = new GlossaryTerm();
            srcTerm.setLocale(this.srcLang);
            srcTerm.setContent(message.getMsgid());
            GlossaryTerm targetTerm = new GlossaryTerm();
            targetTerm.setLocale(this.transLang);
            targetTerm.setContent(message.getMsgstr());
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)entry.getSourceReference())) {
                sb.append(entry.getSourceReference());
            }
            if (StringUtils.isNotBlank((CharSequence)StringUtils.join((Iterable)message.getSourceReferences(), (String)"\n"))) {
                sb.append(StringUtils.join((Iterable)message.getSourceReferences(), (String)"\n"));
            }
            entry.setSourceReference(sb.toString());
            String description = Joiner.on((String)"\n").skipNulls().join((Iterable)message.getExtractedComments());
            entry.setDescription(description);
            String targetComment = Joiner.on((String)"\n").skipNulls().join((Iterable)message.getComments());
            targetTerm.setComment(targetComment);
            entry.getGlossaryTerms().add(srcTerm);
            entry.getGlossaryTerms().add(targetTerm);
            entries.add(entry);
        }
        HashMap results = Maps.newHashMap();
        results.put(this.transLang, entries);
        return results;
    }

    static MessageStreamParser createParser(InputSource inputSource) {
        MessageStreamParser messageParser;
        if (inputSource.getCharacterStream() != null) {
            messageParser = new MessageStreamParser(inputSource.getCharacterStream());
        } else if (inputSource.getByteStream() != null) {
            messageParser = inputSource.getEncoding() != null ? new MessageStreamParser(inputSource.getByteStream(), Charset.forName(inputSource.getEncoding())) : new MessageStreamParser(inputSource.getByteStream(), Charset.forName("UTF-8"));
        } else if (inputSource.getSystemId() != null) {
            try {
                URL url = new URL(inputSource.getSystemId());
                if (inputSource.getEncoding() != null) {
                    messageParser = new MessageStreamParser(url.openStream(), Charset.forName(inputSource.getEncoding()));
                }
                messageParser = new MessageStreamParser(url.openStream(), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                throw new RuntimeException("failed to get input from url in inputSource", e);
            }
        } else {
            throw new RuntimeException("not a valid inputSource");
        }
        return messageParser;
    }
}

