/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolver;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolver;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverModel;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolutionUtil;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolver;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.AutoAdjustingSplitPane;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.StreamUtils;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.Utils;

public class CombinePrimitiveResolverDialog
extends JDialog {
    private AutoAdjustingSplitPane spTagConflictTypes;
    private final TagConflictResolverModel modelTagConflictResolver;
    protected TagConflictResolver pnlTagConflictResolver;
    private final RelationMemberConflictResolverModel modelRelConflictResolver;
    protected RelationMemberConflictResolver pnlRelationMemberConflictResolver;
    private final CombinePrimitiveResolver primitiveResolver;
    private boolean applied;
    private JPanel pnlButtons;
    protected transient OsmPrimitive targetPrimitive;
    private ContextSensitiveHelpAction helpAction;
    private JButton btnApply;

    public CombinePrimitiveResolverDialog(Component parent) {
        this(parent, new TagConflictResolverModel(), new RelationMemberConflictResolverModel());
    }

    public CombinePrimitiveResolverDialog(Component parent, TagConflictResolverModel tagModel, RelationMemberConflictResolverModel relModel) {
        super((Window)GuiHelper.getFrameForComponent(parent), Dialog.ModalityType.DOCUMENT_MODAL);
        this.modelTagConflictResolver = tagModel;
        this.modelRelConflictResolver = relModel;
        this.primitiveResolver = new CombinePrimitiveResolver(tagModel, relModel);
        this.build();
    }

    public OsmPrimitive getTargetPrimitive() {
        return this.targetPrimitive;
    }

    public void setTargetPrimitive(OsmPrimitive primitive) {
        this.setTargetPrimitive(primitive, true);
    }

    private void setTargetPrimitive(OsmPrimitive primitive, boolean updateTitle) {
        this.targetPrimitive = primitive;
        if (updateTitle) {
            GuiHelper.runInEDTAndWait(this::updateTitle);
        }
    }

    protected void updateTitle() {
        if (this.targetPrimitive == null) {
            this.setTitle(I18n.tr("Conflicts when combining primitives", new Object[0]));
            return;
        }
        if (this.targetPrimitive instanceof Way) {
            this.setTitle(I18n.tr("Conflicts when combining ways - combined way is ''{0}''", this.targetPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
            this.helpAction.setHelpTopic(HelpUtil.ht("/Action/CombineWay#ResolvingConflicts"));
            this.getRootPane().putClientProperty("help", HelpUtil.ht("/Action/CombineWay#ResolvingConflicts"));
            this.pnlRelationMemberConflictResolver.initForWayCombining();
        } else if (this.targetPrimitive instanceof Node) {
            this.setTitle(I18n.tr("Conflicts when merging nodes - target node is ''{0}''", this.targetPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
            this.helpAction.setHelpTopic(HelpUtil.ht("/Action/MergeNodes#ResolvingConflicts"));
            this.getRootPane().putClientProperty("help", HelpUtil.ht("/Action/MergeNodes#ResolvingConflicts"));
            this.pnlRelationMemberConflictResolver.initForNodeMerging();
        }
    }

    protected final void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.updateTitle();
        this.spTagConflictTypes = new AutoAdjustingSplitPane(0);
        this.spTagConflictTypes.setTopComponent(this.buildTagConflictResolverPanel());
        this.spTagConflictTypes.setBottomComponent(this.buildRelationMemberConflictResolverPanel());
        this.pnlButtons = this.buildButtonPanel();
        this.getContentPane().add((Component)this.pnlButtons, "South");
        this.addWindowListener(new AdjustDividerLocationAction());
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/"));
        InputMapUtils.addEscapeAction(this.getRootPane(), new CancelAction());
    }

    protected JPanel buildTagConflictResolverPanel() {
        this.pnlTagConflictResolver = new TagConflictResolver(this.modelTagConflictResolver);
        return this.pnlTagConflictResolver;
    }

    protected JPanel buildRelationMemberConflictResolverPanel() {
        this.pnlRelationMemberConflictResolver = new RelationMemberConflictResolver(this.modelRelConflictResolver);
        return this.pnlRelationMemberConflictResolver;
    }

    protected ApplyAction buildApplyAction() {
        return new ApplyAction();
    }

    protected JPanel buildButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        ApplyAction applyAction = this.buildApplyAction();
        this.modelTagConflictResolver.addPropertyChangeListener(applyAction);
        this.modelRelConflictResolver.addPropertyChangeListener(applyAction);
        this.btnApply = new JButton(applyAction);
        this.btnApply.setFocusable(true);
        pnl.add(this.btnApply);
        CancelAction cancelAction = new CancelAction();
        pnl.add(new JButton(cancelAction));
        this.helpAction = new ContextSensitiveHelpAction();
        pnl.add(new JButton(this.helpAction));
        return pnl;
    }

    public TagConflictResolverModel getTagConflictResolverModel() {
        return this.modelTagConflictResolver;
    }

    public RelationMemberConflictResolverModel getRelationMemberConflictResolverModel() {
        return this.modelRelConflictResolver;
    }

    public boolean isResolvedCompletely() {
        return this.modelTagConflictResolver.isResolvedCompletely() && this.modelRelConflictResolver.isResolvedCompletely();
    }

    protected List<Command> buildTagChangeCommand(OsmPrimitive primitive, TagCollection tc) {
        return this.primitiveResolver.buildTagChangeCommand(primitive, tc);
    }

    public List<Command> buildResolutionCommands() {
        List<Command> cmds = this.primitiveResolver.buildResolutionCommands(this.targetPrimitive);
        Command cmd = this.pnlRelationMemberConflictResolver.buildTagApplyCommands(this.modelRelConflictResolver.getModifiedRelations(this.targetPrimitive));
        if (cmd != null) {
            cmds.add(cmd);
        }
        return cmds;
    }

    public void prepareDefaultDecisions() {
        this.prepareDefaultDecisions(true);
    }

    private void prepareDefaultDecisions(boolean fireEvent) {
        this.modelTagConflictResolver.prepareDefaultTagDecisions(fireEvent);
        this.modelRelConflictResolver.prepareDefaultRelationDecisions(fireEvent);
    }

    protected JPanel buildEmptyConflictsPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add(new JLabel(I18n.tr("No conflicts to resolve", new Object[0])));
        return pnl;
    }

    protected void prepareGUIBeforeConflictResolutionStarts() {
        this.getContentPane().removeAll();
        if (this.modelRelConflictResolver.getNumDecisions() > 0 && this.modelTagConflictResolver.getNumDecisions() > 0) {
            this.spTagConflictTypes.setTopComponent(this.pnlTagConflictResolver);
            this.spTagConflictTypes.setBottomComponent(this.pnlRelationMemberConflictResolver);
            this.getContentPane().add((Component)this.spTagConflictTypes, "Center");
        } else if (this.modelRelConflictResolver.getNumDecisions() > 0) {
            this.getContentPane().add((Component)this.pnlRelationMemberConflictResolver, "Center");
        } else if (this.modelTagConflictResolver.getNumDecisions() > 0) {
            this.getContentPane().add((Component)this.pnlTagConflictResolver, "Center");
        } else {
            this.getContentPane().add((Component)this.buildEmptyConflictsPanel(), "Center");
        }
        this.getContentPane().add((Component)this.pnlButtons, "South");
        this.getContentPane().validate();
        this.adjustDividerLocation();
        this.pnlRelationMemberConflictResolver.prepareForEditing();
    }

    protected void setApplied(boolean applied) {
        this.applied = applied;
    }

    public boolean isApplied() {
        return this.applied;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.prepareGUIBeforeConflictResolutionStarts();
            this.setMinimumSize(new Dimension(400, 400));
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(MainApplication.getMainFrame(), new Dimension(800, 600))).applySafe(this);
            this.setApplied(false);
            this.btnApply.requestFocusInWindow();
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    private void adjustDividerLocation() {
        int numTagDecisions = this.modelTagConflictResolver.getNumDecisions();
        int numRelationDecisions = this.modelRelConflictResolver.getNumDecisions();
        if (numTagDecisions > 0 && numRelationDecisions > 0 && this.getHeight() > 0) {
            double hPopup = this.getHeight();
            double h1 = this.pnlRelationMemberConflictResolver.getHeight() + this.pnlTagConflictResolver.getHeight();
            double correction = h1 > 0.0 && hPopup > h1 ? (hPopup - h1) / hPopup : 0.0;
            double nTop = 3.5 + (double)numTagDecisions;
            double nBottom = 5.5 + (double)numRelationDecisions;
            double ratio = nTop / (nTop + nBottom);
            this.spTagConflictTypes.setDividerLocation(ratio > correction ? ratio - correction : ratio);
        }
    }

    public static List<Command> launchIfNecessary(TagCollection tagsOfPrimitives, Collection<? extends OsmPrimitive> primitives, Collection<? extends OsmPrimitive> targetPrimitives) throws UserCancelException {
        UserCancelException canceled;
        CheckParameterUtil.ensureParameterNotNull(tagsOfPrimitives, "tagsOfPrimitives");
        CheckParameterUtil.ensureParameterNotNull(primitives, "primitives");
        CheckParameterUtil.ensureParameterNotNull(targetPrimitives, "targetPrimitives");
        TagCollection completeWayTags = new TagCollection(tagsOfPrimitives);
        TagConflictResolutionUtil.applyAutomaticTagConflictResolution(completeWayTags);
        TagConflictResolutionUtil.normalizeTagCollectionBeforeEditing(completeWayTags, primitives);
        TagCollection tagsToEdit = new TagCollection(completeWayTags);
        TagConflictResolutionUtil.completeTagCollectionForEditing(tagsToEdit);
        Set<Relation> parentRelations = OsmPrimitive.getParentRelations(primitives);
        if (!ExpertToggleAction.isExpert()) {
            if (!completeWayTags.isApplicableToPrimitive()) {
                CombinePrimitiveResolverDialog.informAboutTagConflicts(primitives, completeWayTags);
            }
            if (!parentRelations.isEmpty()) {
                CombinePrimitiveResolverDialog.informAboutRelationMembershipConflicts(primitives, parentRelations);
            }
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        TagConflictResolverModel tagModel = new TagConflictResolverModel();
        RelationMemberConflictResolverModel relModel = new RelationMemberConflictResolverModel();
        tagModel.populate(tagsToEdit, completeWayTags.getKeysWithMultipleValues(), false);
        relModel.populate(parentRelations, primitives, false);
        tagModel.prepareDefaultTagDecisions(false);
        relModel.prepareDefaultRelationDecisions(false);
        if (tagModel.isResolvedCompletely() && relModel.isResolvedCompletely()) {
            CombinePrimitiveResolver resolver = new CombinePrimitiveResolver(tagModel, relModel);
            for (OsmPrimitive osmPrimitive : targetPrimitives) {
                cmds.addAll(resolver.buildResolutionCommands(osmPrimitive));
            }
        } else if (!GraphicsEnvironment.isHeadless() && (canceled = GuiHelper.runInEDTAndWaitAndReturn(() -> {
            CombinePrimitiveResolverDialog dialog = new CombinePrimitiveResolverDialog((Component)MainApplication.getMainFrame(), tagModel, relModel);
            if (targetPrimitives.size() == 1) {
                dialog.setTargetPrimitive((OsmPrimitive)targetPrimitives.iterator().next(), false);
            } else {
                dialog.setTargetPrimitive(null, false);
            }
            GuiHelper.runInEDTAndWait(() -> {
                tagModel.fireTableDataChanged();
                relModel.fireTableDataChanged();
                dialog.updateTitle();
            });
            dialog.setVisible(true);
            if (!dialog.isApplied()) {
                dialog.dispose();
                return new UserCancelException();
            }
            for (OsmPrimitive i : targetPrimitives) {
                dialog.setTargetPrimitive(i, false);
                cmds.addAll(dialog.buildResolutionCommands());
            }
            dialog.dispose();
            return null;
        })) != null) {
            throw canceled;
        }
        return cmds;
    }

    protected static void informAboutRelationMembershipConflicts(Collection<? extends OsmPrimitive> primitives, Set<Relation> parentRelations) throws UserCancelException {
        String msg = I18n.trn("You are about to combine {1} object, which is part of {0} relation:<br/>{2}Combining these objects may break this relation. If you are unsure, please cancel this operation.<br/>If you want to continue, you are shown a dialog to decide how to adapt the relation.<br/><br/>Do you want to continue?", "You are about to combine {1} objects, which are part of {0} relations:<br/>{2}Combining these objects may break these relations. If you are unsure, please cancel this operation.<br/>If you want to continue, you are shown a dialog to decide how to adapt the relations.<br/><br/>Do you want to continue?", parentRelations.size(), parentRelations.size(), primitives.size(), DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(parentRelations, 20));
        if (!ConditionalOptionPaneUtil.showConfirmationDialog("combine_relation_member", MainApplication.getMainFrame(), "<html>" + msg + "</html>", I18n.tr("Combine confirmation", new Object[0]), 0, 3, 0)) {
            throw new UserCancelException();
        }
    }

    protected static void informAboutTagConflicts(Collection<? extends OsmPrimitive> primitives, TagCollection normalizedTags) throws UserCancelException {
        String conflicts = normalizedTags.getKeysWithMultipleValues().stream().map(key -> CombinePrimitiveResolverDialog.getKeyDescription(key, normalizedTags)).collect(StreamUtils.toHtmlList());
        String msg = I18n.trn("You are about to combine {0} objects, but the following tags are used conflictingly:<br/>{1}If these objects are combined, the resulting object may have unwanted tags.<br/>If you want to continue, you are shown a dialog to fix the conflicting tags.<br/><br/>Do you want to continue?", "You are about to combine {0} objects, but the following tags are used conflictingly:<br/>{1}If these objects are combined, the resulting object may have unwanted tags.<br/>If you want to continue, you are shown a dialog to fix the conflicting tags.<br/><br/>Do you want to continue?", primitives.size(), primitives.size(), conflicts);
        if (!ConditionalOptionPaneUtil.showConfirmationDialog("combine_tags", MainApplication.getMainFrame(), "<html>" + msg + "</html>", I18n.tr("Combine confirmation", new Object[0]), 0, 3, 0)) {
            throw new UserCancelException();
        }
    }

    private static String getKeyDescription(String key, TagCollection normalizedTags) {
        String values = normalizedTags.getValues(key).stream().map(x -> Utils.isEmpty(x) ? I18n.tr("<i>missing</i>", new Object[0]) : x).collect(Collectors.joining(I18n.tr(", ", new Object[0])));
        return I18n.tr("{0} ({1})", key, values);
    }

    @Override
    public void dispose() {
        this.setTargetPrimitive(null, false);
        super.dispose();
    }

    class AdjustDividerLocationAction
    extends WindowAdapter {
        AdjustDividerLocationAction() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            CombinePrimitiveResolverDialog.this.adjustDividerLocation();
        }
    }

    protected class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel conflict resolution", new Object[0]));
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            CombinePrimitiveResolverDialog.this.setVisible(false);
        }
    }

    protected class ApplyAction
    extends AbstractAction
    implements PropertyChangeListener {
        public ApplyAction() {
            this.putValue("ShortDescription", I18n.tr("Apply resolved conflicts", new Object[0]));
            this.putValue("Name", I18n.tr("Apply", new Object[0]));
            new ImageProvider("ok").getResource().attachImageIcon(this);
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            CombinePrimitiveResolverDialog.this.setApplied(true);
            CombinePrimitiveResolverDialog.this.setVisible(false);
            CombinePrimitiveResolverDialog.this.pnlTagConflictResolver.rememberPreferences();
        }

        protected final void updateEnabledState() {
            this.setEnabled(CombinePrimitiveResolverDialog.this.modelTagConflictResolver.isResolvedCompletely() && CombinePrimitiveResolverDialog.this.modelRelConflictResolver.isResolvedCompletely());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(TagConflictResolverModel.NUM_CONFLICTS_PROP)) {
                this.updateEnabledState();
            }
            if (evt.getPropertyName().equals(RelationMemberConflictResolverModel.NUM_CONFLICTS_PROP)) {
                this.updateEnabledState();
            }
        }
    }
}

