/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openstreetmap.josm.command.ChangeMembersCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.CrossingWays;
import org.openstreetmap.josm.data.validation.tests.RelationChecker;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.styleelement.AreaElement;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class MultipolygonTest
extends Test {
    private static final String OUTER = "outer";
    private static final String INNER = "inner";
    public static final int WRONG_MEMBER_TYPE = 1601;
    public static final int WRONG_MEMBER_ROLE = 1602;
    public static final int NON_CLOSED_WAY = 1603;
    public static final int INNER_WAY_OUTSIDE = 1605;
    public static final int CROSSING_WAYS = 1606;
    public static final int OUTER_STYLE_MISMATCH = 1607;
    public static final int INNER_STYLE_MISMATCH = 1608;
    public static final int NO_STYLE = 1610;
    public static final int OUTER_STYLE = 1613;
    public static final int REPEATED_MEMBER_SAME_ROLE = 1614;
    public static final int REPEATED_MEMBER_DIFF_ROLE = 1615;
    public static final int EQUAL_RINGS = 1616;
    public static final int RINGS_SHARE_NODES = 1617;
    public static final int MODIFIED_INCOMPLETE = 1618;
    private static final int FOUND_INSIDE = 1;
    private static final int FOUND_OUTSIDE = 2;
    private Relation createdRelation;
    private boolean repeatCheck;

    public MultipolygonTest() {
        super(I18n.tr("Multipolygon", new Object[0]), I18n.tr("This test checks if multipolygons are valid.", new Object[0]));
    }

    @Override
    public void visit(Relation r) {
        if (r.isMultipolygon() && !r.isEmpty()) {
            ArrayList<TestError> tmpErrors = new ArrayList<TestError>(30);
            boolean hasUnexpectedWayRoles = this.checkMembersAndRoles(r, tmpErrors);
            boolean hasRepeatedMembers = this.checkRepeatedWayMembers(r);
            if (r.isModified() && r.hasIncompleteMembers()) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1618).message(I18n.tr("Incomplete multipolygon relation was modified", new Object[0])).primitives(r).build());
            }
            if (!hasUnexpectedWayRoles && !hasRepeatedMembers) {
                if (r.hasIncompleteMembers()) {
                    this.findIntersectingWaysIncomplete(r);
                } else {
                    Multipolygon polygon = new Multipolygon(r);
                    this.checkStyleConsistency(r, polygon);
                    this.checkGeometryAndRoles(r, polygon);
                    tmpErrors.removeIf(e -> e.getCode() == 1602);
                }
            }
            this.errors.addAll(tmpErrors);
        }
    }

    private void checkStyleConsistency(Relation r, Multipolygon polygon) {
        if (MapPaintStyles.getStyles() != null && !r.isBoundary()) {
            AreaElement area = ElemStyles.getAreaElemStyle(r, false);
            if (area == null) {
                this.errors.add(TestError.builder(this, Severity.OTHER, 1610).message(I18n.tr("No area style for multipolygon", new Object[0])).primitives(r).build());
            } else {
                for (Way wInner : polygon.getInnerWays()) {
                    if (!wInner.isClosed() || !area.equals(ElemStyles.getAreaElemStyle(wInner, false))) continue;
                    this.errors.add(TestError.builder(this, Severity.OTHER, 1608).message(I18n.tr("With the currently used mappaint style the style for inner way equals the multipolygon style", new Object[0])).primitives(Arrays.asList(r, wInner)).highlight(wInner).build());
                }
                for (Way wOuter : polygon.getOuterWays()) {
                    AreaElement areaOuter;
                    if (!wOuter.isArea() || (areaOuter = ElemStyles.getAreaElemStyle(wOuter, false)) == null) continue;
                    if (!area.equals(areaOuter)) {
                        this.errors.add(TestError.builder(this, Severity.OTHER, 1607).message(I18n.tr("With the currently used mappaint style the style for outer way mismatches the area style", new Object[0])).primitives(Arrays.asList(r, wOuter)).highlight(wOuter).build());
                        continue;
                    }
                    this.errors.add(TestError.builder(this, Severity.WARNING, 1613).message(I18n.tr("Area style on outer way", new Object[0])).primitives(Arrays.asList(r, wOuter)).highlight(wOuter).build());
                }
            }
        }
    }

    private void checkGeometryAndRoles(Relation r, Multipolygon polygon) {
        boolean checkRoles;
        int oldErrorsSize = this.errors.size();
        Map<Long, RelationMember> wayMap = r.getMembers().stream().filter(RelationMember::isWay).collect(Collectors.toMap(mem -> mem.getWay().getUniqueId(), mem -> mem, (a, b) -> b));
        List<Node> openNodes = polygon.getOpenEnds();
        if (!openNodes.isEmpty() || wayMap.isEmpty()) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1603).message(I18n.tr("Multipolygon is not closed", new Object[0])).primitives(MultipolygonTest.combineRelAndPrimitives(r, openNodes)).highlight(openNodes).build());
        }
        if (wayMap.isEmpty()) {
            return;
        }
        HashSet<Node> sharedNodes = new HashSet<Node>();
        HashSet<Way> intersectionWays = new HashSet<Way>();
        MultipolygonTest.findIntersectionNodes(r, sharedNodes, intersectionWays);
        List<Multipolygon.PolyData> innerPolygons = polygon.getInnerPolygons();
        List<Multipolygon.PolyData> outerPolygons = polygon.getOuterPolygons();
        ArrayList<Multipolygon.PolyData> allPolygons = new ArrayList<Multipolygon.PolyData>();
        allPolygons.addAll(outerPolygons);
        allPolygons.addAll(innerPolygons);
        Map<Multipolygon.PolyData, List<Multipolygon.PolyData>> crossingPolyMap = this.findIntersectingWays(r, innerPolygons, outerPolygons);
        if (!sharedNodes.isEmpty()) {
            for (int i2 = 0; i2 < allPolygons.size(); ++i2) {
                Multipolygon.PolyData pd1 = (Multipolygon.PolyData)allPolygons.get(i2);
                this.checkPolygonForSelfIntersection(r, pd1);
                if (!MultipolygonTest.hasIntersectionWay(pd1, intersectionWays)) continue;
                for (int j = i2 + 1; j < allPolygons.size(); ++j) {
                    Multipolygon.PolyData pd2 = (Multipolygon.PolyData)allPolygons.get(j);
                    if (MultipolygonTest.checkProblemMap(crossingPolyMap, pd1, pd2) || !MultipolygonTest.hasIntersectionWay(pd2, intersectionWays)) continue;
                    this.checkPolygonsForSharedNodes(r, pd1, pd2, sharedNodes);
                }
            }
        }
        if (checkRoles = IntStream.range(oldErrorsSize, this.errors.size()).noneMatch(i -> ((TestError)this.errors.get(i)).getSeverity() != Severity.OTHER)) {
            this.checkOrSetRoles(r, allPolygons, wayMap, sharedNodes);
        }
    }

    private static boolean hasIntersectionWay(Multipolygon.PolyData pd, Set<Way> intersectionWays) {
        return intersectionWays.stream().anyMatch(w -> pd.getWayIds().contains(w.getUniqueId()));
    }

    private void checkPolygonForSelfIntersection(Relation r, Multipolygon.PolyData pd) {
        if (pd.getWayIds().size() == 1) {
            return;
        }
        List<Node> wayNodes = pd.getNodes();
        int num = wayNodes.size();
        HashSet<Node> nodes = new HashSet<Node>();
        Node firstNode = wayNodes.get(0);
        nodes.add(firstNode);
        ArrayList<Node> isNodes = new ArrayList<Node>();
        for (int i = 1; i < num - 1; ++i) {
            Node n = wayNodes.get(i);
            if (nodes.contains(n)) {
                isNodes.add(n);
                continue;
            }
            nodes.add(n);
        }
        if (!isNodes.isEmpty()) {
            ArrayList<OsmPrimitive> prims = new ArrayList<OsmPrimitive>();
            prims.add(r);
            prims.addAll(isNodes);
            this.errors.add(TestError.builder(this, Severity.WARNING, 1606).message(I18n.tr("Self-intersecting polygon ring", new Object[0])).primitives(prims).highlight(isNodes).build());
        }
    }

    private static void findIntersectionNodes(Relation r, Set<Node> sharedNodes, Set<Way> intersectionWays) {
        HashMap<Node, List> nodeMap = new HashMap<Node, List>();
        for (RelationMember rm : r.getMembers()) {
            if (!rm.isWay()) continue;
            int numNodes = rm.getWay().getNodesCount();
            for (int i = 0; i < numNodes; ++i) {
                Node n = rm.getWay().getNode(i);
                if (n.getReferrers().size() <= 1) continue;
                List ways = nodeMap.computeIfAbsent(n, k -> new ArrayList());
                ways.add(rm.getWay());
                if (ways.size() <= 2 && (ways.size() != 2 || i == 0 || i + 1 == numNodes)) continue;
                sharedNodes.add(n);
                intersectionWays.addAll(ways);
            }
        }
    }

    private void checkPolygonsForSharedNodes(Relation r, Multipolygon.PolyData pd1, Multipolygon.PolyData pd2, Set<Node> allSharedNodes) {
        HashSet<Node> sharedByPolygons = new HashSet<Node>(allSharedNodes);
        sharedByPolygons.retainAll(pd1.getNodes());
        sharedByPolygons.retainAll(pd2.getNodes());
        if (sharedByPolygons.isEmpty()) {
            return;
        }
        int errorCode = 1617;
        ExtPolygonIntersection res = MultipolygonTest.checkOverlapAtSharedNodes(sharedByPolygons, pd1, pd2);
        if (res == ExtPolygonIntersection.CROSSING) {
            errorCode = 1606;
        } else if (res == ExtPolygonIntersection.EQUAL) {
            errorCode = 1616;
        }
        if (errorCode != 0) {
            HashSet<OsmPrimitive> prims = new HashSet<OsmPrimitive>();
            prims.add(r);
            for (Node n : sharedByPolygons) {
                for (OsmPrimitive p : n.getReferrers()) {
                    if (!(p instanceof Way) || !pd1.getWayIds().contains(p.getUniqueId()) && !pd2.getWayIds().contains(p.getUniqueId())) continue;
                    prims.add(p);
                }
            }
            if (errorCode == 1617) {
                this.errors.add(TestError.builder(this, Severity.OTHER, errorCode).message(I18n.tr("Multipolygon rings share node", new Object[0])).primitives(prims).highlight(sharedByPolygons).build());
            } else {
                this.errors.add(TestError.builder(this, Severity.WARNING, errorCode).message(errorCode == 1606 ? I18n.tr("Intersection between multipolygon ways", new Object[0]) : I18n.tr("Multipolygon rings are equal", new Object[0])).primitives(prims).highlight(sharedByPolygons).build());
            }
        }
    }

    private static ExtPolygonIntersection checkOverlapAtSharedNodes(Set<Node> shared, Multipolygon.PolyData pd1, Multipolygon.PolyData pd2) {
        int[] flags = new int[2];
        for (int loop = 0; loop < flags.length; ++loop) {
            List<Node> nodes2Test = loop == 0 ? pd1.getNodes() : pd2.getNodes();
            int num = nodes2Test.size() - 1;
            int lenShared = 0;
            for (int i = 0; i < num; ++i) {
                Node n = nodes2Test.get(i);
                if (shared.contains(n)) {
                    ++lenShared;
                    continue;
                }
                if (i != 0 && lenShared <= 0) continue;
                lenShared = 0;
                boolean inside = MultipolygonTest.checkIfNodeIsInsidePolygon(n, loop == 0 ? pd2 : pd1);
                int n2 = loop;
                flags[n2] = flags[n2] | (inside ? 1 : 2);
                if (flags[loop] != 3) continue;
                return ExtPolygonIntersection.CROSSING;
            }
        }
        if ((flags[0] & 1) != 0) {
            return ExtPolygonIntersection.FIRST_INSIDE_SECOND;
        }
        if ((flags[1] & 1) != 0) {
            return ExtPolygonIntersection.SECOND_INSIDE_FIRST;
        }
        if ((flags[0] & 2) != (flags[1] & 2)) {
            return (flags[0] & 2) != 0 ? ExtPolygonIntersection.SECOND_INSIDE_FIRST : ExtPolygonIntersection.FIRST_INSIDE_SECOND;
        }
        if ((flags[0] & 2) != 0 && (flags[1] & 2) != 0) {
            Area a2;
            Area a1 = new Area(pd1.get());
            Geometry.PolygonIntersection areaRes = Geometry.polygonIntersection(a1, a2 = new Area(pd2.get()));
            if (areaRes == Geometry.PolygonIntersection.OUTSIDE) {
                return ExtPolygonIntersection.OUTSIDE;
            }
            return ExtPolygonIntersection.CROSSING;
        }
        return ExtPolygonIntersection.EQUAL;
    }

    private void checkOrSetRoles(Relation r, List<Multipolygon.PolyData> allPolygons, Map<Long, RelationMember> wayMap, Set<Node> sharedNodes) {
        PolygonLevelFinder levelFinder = new PolygonLevelFinder(sharedNodes);
        List<PolygonLevel> list = levelFinder.findOuterWays(allPolygons);
        if (Utils.isEmpty(list)) {
            return;
        }
        if (r == this.createdRelation) {
            list.sort((r1, r2) -> {
                int d = Integer.compare(r1.level % 2, r2.level % 2);
                if (d != 0) {
                    return d;
                }
                return Integer.compare(r2.outerWay.getWayIds().size(), r1.outerWay.getWayIds().size());
            });
            ArrayList<RelationMember> modMembers = new ArrayList<RelationMember>();
            for (PolygonLevel pol : list) {
                String calculatedRole = pol.level % 2 == 0 ? OUTER : INNER;
                for (long wayId : pol.outerWay.getWayIds()) {
                    RelationMember member = wayMap.get(wayId);
                    modMembers.add(new RelationMember(calculatedRole, member.getMember()));
                }
            }
            r.setMembers((List<RelationMember>)modMembers);
            return;
        }
        for (PolygonLevel pol : list) {
            String calculatedRole = pol.level % 2 == 0 ? OUTER : INNER;
            for (long wayId : pol.outerWay.getWayIds()) {
                RelationMember member = wayMap.get(wayId);
                if (calculatedRole.equals(member.getRole())) continue;
                this.errors.add(TestError.builder(this, Severity.ERROR, 1602).message(RelationChecker.ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Role for ''{0}'' should be ''{1}''"), member.getMember().getDisplayName(DefaultNameFormatter.getInstance()), calculatedRole).primitives(Arrays.asList(r, member.getMember())).highlight(member.getMember()).build());
                if (pol.level != 0 || !INNER.equals(member.getRole())) continue;
                this.errors.add(TestError.builder(this, Severity.ERROR, 1605).message(I18n.tr("Multipolygon inner way is outside", new Object[0])).primitives(Arrays.asList(r, member.getMember())).highlight(member.getMember()).build());
            }
        }
    }

    private static boolean checkIfNodeIsInsidePolygon(Node n, Multipolygon.PolyData p) {
        EastNorth en = n.getEastNorth();
        return en != null && p.get().contains(en.getX(), en.getY());
    }

    private Map<Multipolygon.PolyData, List<Multipolygon.PolyData>> findIntersectingWays(Relation r, List<Multipolygon.PolyData> innerPolygons, List<Multipolygon.PolyData> outerPolygons) {
        HashMap<Multipolygon.PolyData, List<Multipolygon.PolyData>> crossingPolygonsMap = new HashMap<Multipolygon.PolyData, List<Multipolygon.PolyData>>();
        HashMap sharedWaySegmentsPolygonsMap = new HashMap();
        for (int loop = 0; loop < 2; ++loop) {
            Map<List<Way>, List<WaySegment>> crossingWays = MultipolygonTest.findIntersectingWays(r, loop == 1);
            if (crossingWays.isEmpty()) continue;
            HashMap<Multipolygon.PolyData, List<Multipolygon.PolyData>> problemPolygonMap = loop == 0 ? crossingPolygonsMap : sharedWaySegmentsPolygonsMap;
            ArrayList<Multipolygon.PolyData> allPolygons = new ArrayList<Multipolygon.PolyData>(innerPolygons.size() + outerPolygons.size());
            allPolygons.addAll(innerPolygons);
            allPolygons.addAll(outerPolygons);
            for (Map.Entry<List<Way>, List<WaySegment>> entry : crossingWays.entrySet()) {
                List<Way> ways = entry.getKey();
                if (ways.size() != 2) continue;
                Multipolygon.PolyData[] crossingPolys = new Multipolygon.PolyData[2];
                boolean allInner = true;
                block2: for (int i = 0; i < 2; ++i) {
                    Way w = ways.get(i);
                    for (int j = 0; j < allPolygons.size(); ++j) {
                        Multipolygon.PolyData pd = (Multipolygon.PolyData)allPolygons.get(j);
                        if (!pd.getWayIds().contains(w.getUniqueId())) continue;
                        crossingPolys[i] = pd;
                        if (j < innerPolygons.size()) continue block2;
                        allInner = false;
                        continue block2;
                    }
                }
                boolean samePoly = false;
                if (crossingPolys[0] != null && crossingPolys[1] != null) {
                    List crossingPolygons = problemPolygonMap.computeIfAbsent(crossingPolys[0], k -> new ArrayList());
                    crossingPolygons.add(crossingPolys[1]);
                    if (crossingPolys[0] == crossingPolys[1]) {
                        samePoly = true;
                    }
                }
                if (r == this.createdRelation && loop == 1 && !allInner) {
                    this.repeatCheck = true;
                    continue;
                }
                if (loop != 0 && !samePoly && (loop != 1 || allInner)) continue;
                String msg = loop == 0 ? I18n.tr("Intersection between multipolygon ways", new Object[0]) : (samePoly ? I18n.tr("Multipolygon ring contains segment twice", new Object[0]) : I18n.tr("Multipolygon outer way shares segment with other ring", new Object[0]));
                this.errors.add(TestError.builder(this, Severity.ERROR, 1606).message(msg).primitives(Arrays.asList(r, ways.get(0), ways.get(1))).highlightWaySegments((Collection<WaySegment>)entry.getValue()).build());
            }
        }
        return crossingPolygonsMap;
    }

    private void findIntersectingWaysIncomplete(Relation r) {
        Set outerWays = r.getMembers().stream().filter(m -> m.getRole().isEmpty() || OUTER.equals(m.getRole())).map(RelationMember::getMember).collect(Collectors.toSet());
        for (int loop = 0; loop < 2; ++loop) {
            for (Map.Entry<List<Way>, List<WaySegment>> entry : MultipolygonTest.findIntersectingWays(r, loop == 1).entrySet()) {
                List<Way> ways = entry.getKey();
                if (ways.size() != 2) continue;
                if (loop == 0) {
                    this.errors.add(TestError.builder(this, Severity.ERROR, 1606).message(I18n.tr("Intersection between multipolygon ways", new Object[0])).primitives(Arrays.asList(r, ways.get(0), ways.get(1))).highlightWaySegments((Collection<WaySegment>)entry.getValue()).build());
                    continue;
                }
                if (!outerWays.contains(ways.get(0)) && !outerWays.contains(ways.get(1))) continue;
                this.errors.add(TestError.builder(this, Severity.ERROR, 1606).message(I18n.tr("Multipolygon outer way shares segment with other ring", new Object[0])).primitives(Arrays.asList(r, ways.get(0), ways.get(1))).highlightWaySegments((Collection<WaySegment>)entry.getValue()).build());
            }
        }
    }

    private static Map<List<Way>, List<WaySegment>> findIntersectingWays(Relation r, boolean findSharedWaySegments) {
        HashMap<Point2D, List<WaySegment>> cellSegments = new HashMap<Point2D, List<WaySegment>>(1000);
        HashMap<List<Way>, List<WaySegment>> crossingWays = new HashMap<List<Way>, List<WaySegment>>(50);
        for (Way w : r.getMemberPrimitives(Way.class)) {
            if (w.hasIncompleteNodes()) continue;
            CrossingWays.findIntersectingWay(w, cellSegments, crossingWays, findSharedWaySegments);
        }
        return crossingWays;
    }

    private static boolean checkProblemMap(Map<Multipolygon.PolyData, List<Multipolygon.PolyData>> problemPolyMap, Multipolygon.PolyData pd1, Multipolygon.PolyData pd2) {
        List<Multipolygon.PolyData> crossingWithFirst = problemPolyMap.get(pd1);
        if (crossingWithFirst != null && crossingWithFirst.contains(pd2)) {
            return true;
        }
        List<Multipolygon.PolyData> crossingWith2nd = problemPolyMap.get(pd2);
        return crossingWith2nd != null && crossingWith2nd.contains(pd1);
    }

    private boolean checkMembersAndRoles(Relation r, List<TestError> tmpErrors) {
        boolean hasUnexpectedWayRole = false;
        for (RelationMember rm : r.getMembers()) {
            if (rm.isWay()) {
                if (rm.hasRole() && !rm.hasRole(INNER, OUTER)) {
                    hasUnexpectedWayRole = true;
                }
                if (rm.hasRole(INNER, OUTER) && rm.hasRole()) continue;
                tmpErrors.add(TestError.builder(this, Severity.ERROR, 1602).message(I18n.tr("Role for multipolygon way member should be inner or outer", new Object[0])).primitives(Arrays.asList(r, rm.getMember())).build());
                continue;
            }
            if (r.isBoundary() && rm.hasRole("admin_centre", "label", "subarea", "land_area")) continue;
            tmpErrors.add(TestError.builder(this, Severity.WARNING, 1601).message(r.isBoundary() ? I18n.tr("Non-Way in boundary", new Object[0]) : I18n.tr("Non-Way in multipolygon", new Object[0])).primitives(Arrays.asList(r, rm.getMember())).build());
        }
        return hasUnexpectedWayRole;
    }

    private static Collection<? extends OsmPrimitive> combineRelAndPrimitives(Relation r, Collection<? extends OsmPrimitive> primitives) {
        if (!primitives.contains(r)) {
            ArrayList<? extends OsmPrimitive> newPrimitives = new ArrayList<OsmPrimitive>(primitives);
            newPrimitives.add(0, r);
            return newPrimitives;
        }
        return primitives;
    }

    private boolean checkRepeatedWayMembers(Relation r) {
        boolean hasDups = false;
        HashMap<OsmPrimitive, ArrayList<RelationMember>> seenMemberPrimitives = new HashMap<OsmPrimitive, ArrayList<RelationMember>>();
        for (RelationMember rm : r.getMembers()) {
            if (!rm.isWay()) continue;
            ArrayList<RelationMember> list = (ArrayList<RelationMember>)seenMemberPrimitives.get(rm.getMember());
            if (list == null) {
                list = new ArrayList<RelationMember>(2);
                seenMemberPrimitives.put(rm.getMember(), list);
            } else {
                hasDups = true;
            }
            list.add(rm);
        }
        if (hasDups) {
            ArrayList<OsmPrimitive> repeatedSameRole = new ArrayList<OsmPrimitive>();
            ArrayList<OsmPrimitive> repeatedDiffRole = new ArrayList<OsmPrimitive>();
            for (Map.Entry e : seenMemberPrimitives.entrySet()) {
                List visited = (List)e.getValue();
                if (((List)e.getValue()).size() == 1) continue;
                boolean rolesDiffer = false;
                RelationMember rm = (RelationMember)visited.get(0);
                ArrayList<OsmPrimitive> primitives = new ArrayList<OsmPrimitive>();
                for (int i = 1; i < visited.size(); ++i) {
                    RelationMember v = (RelationMember)visited.get(i);
                    primitives.add(rm.getMember());
                    if (v.getRole().equals(rm.getRole())) continue;
                    rolesDiffer = true;
                }
                if (rolesDiffer) {
                    repeatedDiffRole.addAll(primitives);
                    continue;
                }
                repeatedSameRole.addAll(primitives);
            }
            this.addRepeatedMemberError(r, repeatedDiffRole, 1615, I18n.tr("Multipolygon member repeated with different role", new Object[0]));
            this.addRepeatedMemberError(r, repeatedSameRole, 1614, I18n.tr("Multipolygon member repeated with same role", new Object[0]));
        }
        return hasDups;
    }

    private void addRepeatedMemberError(Relation r, List<OsmPrimitive> repeatedMembers, int errorCode, String msg) {
        if (!repeatedMembers.isEmpty()) {
            this.errors.add(TestError.builder(this, Severity.ERROR, errorCode).message(msg).primitives(MultipolygonTest.combineRelAndPrimitives(r, repeatedMembers)).highlight(repeatedMembers).build());
        }
    }

    @Override
    public Command fixError(TestError testError) {
        ArrayList<? extends OsmPrimitive> primitives;
        if (testError.getCode() == 1614 && (primitives = new ArrayList<OsmPrimitive>(testError.getPrimitives())).size() >= 2 && primitives.get(0) instanceof Relation) {
            Relation oldRel = (Relation)primitives.get(0);
            List<? extends OsmPrimitive> repeatedPrims = primitives.subList(1, primitives.size());
            List<RelationMember> oldMembers = oldRel.getMembers();
            ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>();
            HashSet<? extends OsmPrimitive> toRemove = new HashSet<OsmPrimitive>(repeatedPrims);
            HashSet<OsmPrimitive> found = new HashSet<OsmPrimitive>(repeatedPrims.size());
            for (RelationMember rm : oldMembers) {
                if (toRemove.contains(rm.getMember())) {
                    if (!found.add(rm.getMember())) continue;
                    newMembers.add(rm);
                    continue;
                }
                newMembers.add(rm);
            }
            return new ChangeMembersCommand(oldRel, newMembers);
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        return testError.getCode() == 1614;
    }

    public Relation makeFromWays(Collection<Way> ways) {
        Relation r;
        this.createdRelation = r = new Relation();
        r.put("type", "multipolygon");
        for (Way w : ways) {
            r.addMember(new RelationMember("", w));
        }
        do {
            this.repeatCheck = false;
            this.errors.clear();
            Multipolygon polygon = null;
            boolean hasRepeatedMembers = this.checkRepeatedWayMembers(r);
            if (!hasRepeatedMembers) {
                polygon = new Multipolygon(r);
                this.checkGeometryAndRoles(r, polygon);
            }
            this.createdRelation = null;
        } while (this.repeatCheck);
        this.errors.removeIf(e -> e.getSeverity() == Severity.OTHER);
        return r;
    }

    private static enum ExtPolygonIntersection {
        EQUAL,
        FIRST_INSIDE_SECOND,
        SECOND_INSIDE_FIRST,
        OUTSIDE,
        CROSSING;

    }

    private static class PolygonLevelFinder {
        private final Set<Node> sharedNodes;

        PolygonLevelFinder(Set<Node> sharedNodes) {
            this.sharedNodes = sharedNodes;
        }

        List<PolygonLevel> findOuterWays(List<Multipolygon.PolyData> allPolygons) {
            return this.findOuterWaysRecursive(0, allPolygons);
        }

        private List<PolygonLevel> findOuterWaysRecursive(int level, List<Multipolygon.PolyData> polygons) {
            ArrayList<PolygonLevel> result = new ArrayList<PolygonLevel>();
            for (Multipolygon.PolyData pd : polygons) {
                this.processOuterWay(level, polygons, result, pd);
            }
            return result;
        }

        private void processOuterWay(int level, List<Multipolygon.PolyData> polygons, List<PolygonLevel> result, Multipolygon.PolyData pd) {
            List<Multipolygon.PolyData> inners = this.findInnerWaysCandidates(pd, polygons);
            if (inners != null) {
                PolygonLevel pol = new PolygonLevel(pd, level);
                if (!inners.isEmpty()) {
                    List<PolygonLevel> innerList = this.findOuterWaysRecursive(level + 1, inners);
                    result.addAll(innerList);
                }
                result.add(pol);
            }
        }

        private List<Multipolygon.PolyData> findInnerWaysCandidates(Multipolygon.PolyData outerCandidate, List<Multipolygon.PolyData> polygons) {
            ArrayList<Multipolygon.PolyData> innerCandidates = new ArrayList<Multipolygon.PolyData>();
            for (Multipolygon.PolyData inner : polygons) {
                if (inner == outerCandidate || !outerCandidate.getBounds().intersects(inner.getBounds())) continue;
                boolean useIntersectionTest = false;
                Node unsharedOuterNode = null;
                Node unsharedInnerNode = this.getNonIntersectingNode(outerCandidate, inner);
                if (unsharedInnerNode != null) {
                    if (MultipolygonTest.checkIfNodeIsInsidePolygon(unsharedInnerNode, outerCandidate)) {
                        innerCandidates.add(inner);
                    } else {
                        unsharedOuterNode = this.getNonIntersectingNode(inner, outerCandidate);
                        if (unsharedOuterNode != null) {
                            if (MultipolygonTest.checkIfNodeIsInsidePolygon(unsharedOuterNode, inner)) {
                                return null;
                            }
                        } else {
                            useIntersectionTest = true;
                        }
                    }
                } else {
                    unsharedOuterNode = this.getNonIntersectingNode(inner, outerCandidate);
                    if (unsharedOuterNode == null) {
                        return null;
                    }
                    if (MultipolygonTest.checkIfNodeIsInsidePolygon(unsharedOuterNode, inner)) {
                        return null;
                    }
                    useIntersectionTest = true;
                }
                if (!useIntersectionTest) continue;
                Geometry.PolygonIntersection res = Geometry.polygonIntersection(inner.getNodes(), outerCandidate.getNodes());
                if (res == Geometry.PolygonIntersection.FIRST_INSIDE_SECOND) {
                    innerCandidates.add(inner);
                    continue;
                }
                if (res != Geometry.PolygonIntersection.SECOND_INSIDE_FIRST) continue;
                return null;
            }
            return innerCandidates;
        }

        private Node getNonIntersectingNode(Multipolygon.PolyData pd1, Multipolygon.PolyData pd2) {
            return pd2.getNodes().stream().filter(n -> !this.sharedNodes.contains(n) || !pd1.getNodes().contains(n)).findFirst().orElse(null);
        }
    }

    private static class PolygonLevel {
        final int level;
        final Multipolygon.PolyData outerWay;

        PolygonLevel(Multipolygon.PolyData pd, int level) {
            this.outerWay = pd;
            this.level = level;
        }
    }
}

