# Rgb2Hires

Rgb2Hires is a set of tools to help convert a modern RGB image (JPEG, PNG) to the HIRES format for Apple II computers, either as a binary export or an assembly listing.

The colors of the RGB image can be approximate: Rgb2Hires will match them with the nearest HIRES color.

## Apple II colors

RGB values of the targeted colors:

* **BLACK**:  00 00 00
* **WHITE**:  FF FF FF
* **BLUE**:   07 A8 E0
* **ORANGE**: F9 56 1D
* **GREEN**:  43 C8 00
* **VIOLET**: BB 36 FF

## Projects

This repository contains three "PC" projects:
* **libRgb2Hires**: a library to convert an RGB image to the Apple II's HIRES format
* **Picture**: a program to convert an RGB png to a binary or an ASM excerpt that can be loaded into the HIRES memory pages of an Apple II. An optional **live preview** can be displayed: its window will simulate an RGB monitor and will show the result, including color clashing and artifacts.
  * Source image must be 140x192. Pixels are anamorphic: they will be displayed twice as wide as they are tall.
  * Source image must contains six colors: BLACK, WHITE, ORANGE, GREEN, BLUE and PURPLE. The colors may be an approximation of the six Apple II colors. Please refer to the provided pic.
* **Tile**: given an RGB png tile sheet that satisfies the same requirements as above, it extracts a 14x16 tile and converts it to ASM data. The lines forming the tile data **are not interleaved** as in a HIRES framebuffer.

And one Apple II project:
* **Loader**: a program that will load and display a picture generated by the *Picture* program. A bash script is provided as an example to load the picture and the loader onto an image disk. [AppleCommander](https://applecommander.github.io/) is required to do so. Once in ProDOS, just type *-DISPLAY*.

__Note:__ For more information about the "Hires" format and its limitations, you can refer to my [website](https://www.xtof.info/hires-graphics-apple-ii.html).

## Build from sources

### Dependencies

The dependencies are managed by [conan.io](https://conan.io/). Please refer to (their documentation)[https://docs.conan.io/en/latest/installation.html] for installation instructions.

The build system is managed by CMake.

### How to build

```bash
mkdir build && cd build
conan install ..
cmake .. -DCMAKE_BUILD_TYPE=RELEASE
cmake --build . --config release -j
```

## Apple II project (Loader)

### Dependencies
* [CC65](https://cc65.github.io/cc65/)
    * The crosscompiler suite. Please provide an environment variable *CC65_HOME* pointing to your CC65 folder.
	
### How to build

A makefile is provided. Just run

```bash
make
```
## Test

* A correct source image, *testPicture.png*, is provided as an example. Convert it using the application *Picture*, then copy it onto a disk image along with the Apple II loader. You can use or refer to the provided script in the *Loader_Apple2* folder.
* Another source image, *testTile.png*, is provided to test that the correct tile is converted and extracted using the application *Tile*.

### Demo

The live preview can help to visualise color clashing and artifacts. You can edit your file using *Photoshop* or any other application. The *Preview* window will be updated each time the file is saved.

<a href="https://pub.xtof.info/github/demo-rgb2hires.mp4">
<img src="https://pub.xtof.info/github/demo-rgb2hires.png"/>
</a>
