# ===========================================================================
# File: default.tcl
# Target: man
#                        Created: 2010-08-29 09:51:41
#              Last modification: 2012-04-11 19:54:57
# Author: Bernard Desgraupes
# e-mail: <bdesgraupes@users.sourceforge.net>
# (c) Copyright: Bernard Desgraupes 2010-2011, 2012
# All rights reserved.
# Description: default settings for target man
# ===========================================================================

namespace eval man {
	variable aida_head
	
	# The name of the subject of the man page
	set aida_head(Title)		""
	
	# The number of the man section where this man page will be kept
	set aida_head(ManSection)	1
	
	# The middle part of the manual page header (like "BSD General Commands
	# Manual")
	set aida_head(ManVolume)	""

	# The name of the operating system the man page or subject source is
	# developed or modified for (it is printed in the bottom left and right
	# corners of the footer of the manual page)
	set aida_head(ManSystem)	""

	set aida_head(NumberSections)	1
	set aida_head(SectionDepth)		4

	set aida_head(NumberRefs)		1

	# Mark the indexed words with a unique number
	set aida_head(NumberIndices)	0

	# By default, disable the navigation bar in split files
	set aida_head(NavBar)			0

	# Implement the style tags by font styles, otherwise use quotes. Font
	# styles don't give good results in tables. This option is off by
	# default.
	set aida_head(FontStyle)		0

	# Symbol used to enclose strings in italic
	set aida_head(ItalMark)			"'"

	# Symbol used to enclose strings in bold face
	set aida_head(BoldMark)			"''"

	# Symbol used to enclose strings in typewriter type
	set aida_head(TTMark)			"`"

}
