/*   $Source: bitbucket.org:berkeleylab/upc-runtime.git/upcr_geninclude/upcr_atomic_defs.h.in $
 * Description:
 *  Berkeley UPC atomic extensions - external interface defines
 *
 * Copyright 2010,  E. O. Lawrence Berekely National Laboratory
 */

#ifndef UPCR_ATOMIC_DEFS_H
#define UPCR_ATOMIC_DEFS_H

/*---------------------------------------------------------------------------------*/
/* External interface: */

#if UPCRI_LIBWRAP
  #define _bupc_atomicU64_set_strict(_dst,_val) \
	_bupc_atomic64_set(_dst,(uint64_t)(_val),1)
  #define _bupc_atomicI64_set_strict(_dst,_val) \
	_bupc_atomic64_set(_dst,(int64_t)(_val),1)
  #define _bupc_atomicU32_set_strict(_dst,_val) \
	_bupc_atomic32_set(_dst,(uint32_t)(_val),1)
  #define _bupc_atomicI32_set_strict(_dst,_val) \
	_bupc_atomic32_set(_dst,(int32_t)(_val),1)
  #define _bupc_atomicU64_set_relaxed(_dst,_val) \
	_bupc_atomic64_set(_dst,(uint64_t)(_val),0)
  #define _bupc_atomicI64_set_relaxed(_dst,_val) \
	_bupc_atomic64_set(_dst,(int64_t)(_val),0)
  #define _bupc_atomicU32_set_relaxed(_dst,_val) \
	_bupc_atomic32_set(_dst,(uint32_t)(_val),0)
  #define _bupc_atomicI32_set_relaxed(_dst,_val) \
	_bupc_atomic32_set(_dst,(int32_t)(_val),0)
  #define _bupc_atomicU64_read_strict(_src) \
	((uint64_t)_bupc_atomic64_read(_src,1))
  #define _bupc_atomicI64_read_strict(_src) \
	((int64_t)_bupc_atomic64_read(_src,1))
  #define _bupc_atomicU32_read_strict(_src) \
	((uint32_t)_bupc_atomic32_read(_src,1))
  #define _bupc_atomicI32_read_strict(_src) \
	((int32_t)_bupc_atomic32_read(_src,1))
  #define _bupc_atomicU64_read_relaxed(_src) \
	((uint64_t)_bupc_atomic64_read(_src,0))
  #define _bupc_atomicI64_read_relaxed(_src) \
	((int64_t)_bupc_atomic64_read(_src,0))
  #define _bupc_atomicU32_read_relaxed(_src) \
	((uint32_t)_bupc_atomic32_read(_src,0))
  #define _bupc_atomicI32_read_relaxed(_src) \
	((int32_t)_bupc_atomic32_read(_src,0))
  #define _bupc_atomicU64_fetchadd_strict(_dst,_op) \
	_bupc_atomicU64_fetchadd(_dst,_op,1)
  #define _bupc_atomicI64_fetchadd_strict(_dst,_op) \
	_bupc_atomicI64_fetchadd(_dst,_op,1)
  #define _bupc_atomicU32_fetchadd_strict(_dst,_op) \
	_bupc_atomicU32_fetchadd(_dst,_op,1)
  #define _bupc_atomicI32_fetchadd_strict(_dst,_op) \
	_bupc_atomicI32_fetchadd(_dst,_op,1)
  #define _bupc_atomicU64_fetchadd_relaxed(_dst,_op) \
	_bupc_atomicU64_fetchadd(_dst,_op,0)
  #define _bupc_atomicI64_fetchadd_relaxed(_dst,_op) \
	_bupc_atomicI64_fetchadd(_dst,_op,0)
  #define _bupc_atomicU32_fetchadd_relaxed(_dst,_op) \
	_bupc_atomicU32_fetchadd(_dst,_op,0)
  #define _bupc_atomicI32_fetchadd_relaxed(_dst,_op) \
	_bupc_atomicI32_fetchadd(_dst,_op,0)
  #define _bupc_atomicU64_fetchand_strict(_dst,_op) \
	_bupc_atomicU64_fetchand(_dst,_op,1)
  #define _bupc_atomicI64_fetchand_strict(_dst,_op) \
	_bupc_atomicI64_fetchand(_dst,_op,1)
  #define _bupc_atomicU32_fetchand_strict(_dst,_op) \
	_bupc_atomicU32_fetchand(_dst,_op,1)
  #define _bupc_atomicI32_fetchand_strict(_dst,_op) \
	_bupc_atomicI32_fetchand(_dst,_op,1)
  #define _bupc_atomicU64_fetchand_relaxed(_dst,_op) \
	_bupc_atomicU64_fetchand(_dst,_op,0)
  #define _bupc_atomicI64_fetchand_relaxed(_dst,_op) \
	_bupc_atomicI64_fetchand(_dst,_op,0)
  #define _bupc_atomicU32_fetchand_relaxed(_dst,_op) \
	_bupc_atomicU32_fetchand(_dst,_op,0)
  #define _bupc_atomicI32_fetchand_relaxed(_dst,_op) \
	_bupc_atomicI32_fetchand(_dst,_op,0)
  #define _bupc_atomicU64_fetchor_strict(_dst,_op) \
	_bupc_atomicU64_fetchor(_dst,_op,1)
  #define _bupc_atomicI64_fetchor_strict(_dst,_op) \
	_bupc_atomicI64_fetchor(_dst,_op,1)
  #define _bupc_atomicU32_fetchor_strict(_dst,_op) \
	_bupc_atomicU32_fetchor(_dst,_op,1)
  #define _bupc_atomicI32_fetchor_strict(_dst,_op) \
	_bupc_atomicI32_fetchor(_dst,_op,1)
  #define _bupc_atomicU64_fetchor_relaxed(_dst,_op) \
	_bupc_atomicU64_fetchor(_dst,_op,0)
  #define _bupc_atomicI64_fetchor_relaxed(_dst,_op) \
	_bupc_atomicI64_fetchor(_dst,_op,0)
  #define _bupc_atomicU32_fetchor_relaxed(_dst,_op) \
	_bupc_atomicU32_fetchor(_dst,_op,0)
  #define _bupc_atomicI32_fetchor_relaxed(_dst,_op) \
	_bupc_atomicI32_fetchor(_dst,_op,0)
  #define _bupc_atomicU64_fetchxor_strict(_dst,_op) \
	_bupc_atomicU64_fetchxor(_dst,_op,1)
  #define _bupc_atomicI64_fetchxor_strict(_dst,_op) \
	_bupc_atomicI64_fetchxor(_dst,_op,1)
  #define _bupc_atomicU32_fetchxor_strict(_dst,_op) \
	_bupc_atomicU32_fetchxor(_dst,_op,1)
  #define _bupc_atomicI32_fetchxor_strict(_dst,_op) \
	_bupc_atomicI32_fetchxor(_dst,_op,1)
  #define _bupc_atomicU64_fetchxor_relaxed(_dst,_op) \
	_bupc_atomicU64_fetchxor(_dst,_op,0)
  #define _bupc_atomicI64_fetchxor_relaxed(_dst,_op) \
	_bupc_atomicI64_fetchxor(_dst,_op,0)
  #define _bupc_atomicU32_fetchxor_relaxed(_dst,_op) \
	_bupc_atomicU32_fetchxor(_dst,_op,0)
  #define _bupc_atomicI32_fetchxor_relaxed(_dst,_op) \
	_bupc_atomicI32_fetchxor(_dst,_op,0)
  #define _bupc_atomicU64_swap_strict(_dst,_op) \
	_bupc_atomicU64_swap(_dst,_op,1)
  #define _bupc_atomicI64_swap_strict(_dst,_op) \
	_bupc_atomicI64_swap(_dst,_op,1)
  #define _bupc_atomicU32_swap_strict(_dst,_op) \
	_bupc_atomicU32_swap(_dst,_op,1)
  #define _bupc_atomicI32_swap_strict(_dst,_op) \
	_bupc_atomicI32_swap(_dst,_op,1)
  #define _bupc_atomicU64_swap_relaxed(_dst,_op) \
	_bupc_atomicU64_swap(_dst,_op,0)
  #define _bupc_atomicI64_swap_relaxed(_dst,_op) \
	_bupc_atomicI64_swap(_dst,_op,0)
  #define _bupc_atomicU32_swap_relaxed(_dst,_op) \
	_bupc_atomicU32_swap(_dst,_op,0)
  #define _bupc_atomicI32_swap_relaxed(_dst,_op) \
	_bupc_atomicI32_swap(_dst,_op,0)
  #define _bupc_atomicU64_fetchnot_strict(_dst) \
	_bupc_atomicU64_fetchnot(_dst,1)
  #define _bupc_atomicI64_fetchnot_strict(_dst) \
	_bupc_atomicI64_fetchnot(_dst,1)
  #define _bupc_atomicU32_fetchnot_strict(_dst) \
	_bupc_atomicU32_fetchnot(_dst,1)
  #define _bupc_atomicI32_fetchnot_strict(_dst) \
	_bupc_atomicI32_fetchnot(_dst,1)
  #define _bupc_atomicU64_fetchnot_relaxed(_dst) \
	_bupc_atomicU64_fetchnot(_dst,0)
  #define _bupc_atomicI64_fetchnot_relaxed(_dst) \
	_bupc_atomicI64_fetchnot(_dst,0)
  #define _bupc_atomicU32_fetchnot_relaxed(_dst) \
	_bupc_atomicU32_fetchnot(_dst,0)
  #define _bupc_atomicI32_fetchnot_relaxed(_dst) \
	_bupc_atomicI32_fetchnot(_dst,0)
  #define _bupc_atomicU64_cswap_strict(_dst,_op0,_op1) \
	_bupc_atomicU64_cswap(_dst,_op0,_op1,1)
  #define _bupc_atomicI64_cswap_strict(_dst,_op0,_op1) \
	_bupc_atomicI64_cswap(_dst,_op0,_op1,1)
  #define _bupc_atomicU32_cswap_strict(_dst,_op0,_op1) \
	_bupc_atomicU32_cswap(_dst,_op0,_op1,1)
  #define _bupc_atomicI32_cswap_strict(_dst,_op0,_op1) \
	_bupc_atomicI32_cswap(_dst,_op0,_op1,1)
  #define _bupc_atomicU64_cswap_relaxed(_dst,_op0,_op1) \
	_bupc_atomicU64_cswap(_dst,_op0,_op1,0)
  #define _bupc_atomicI64_cswap_relaxed(_dst,_op0,_op1) \
	_bupc_atomicI64_cswap(_dst,_op0,_op1,0)
  #define _bupc_atomicU32_cswap_relaxed(_dst,_op0,_op1) \
	_bupc_atomicU32_cswap(_dst,_op0,_op1,0)
  #define _bupc_atomicI32_cswap_relaxed(_dst,_op0,_op1) \
	_bupc_atomicI32_cswap(_dst,_op0,_op1,0)
  #define _bupc_atomicU64_mswap_strict(_dst,_op0,_op1) \
	_bupc_atomicU64_mswap(_dst,_op0,_op1,1)
  #define _bupc_atomicI64_mswap_strict(_dst,_op0,_op1) \
	_bupc_atomicI64_mswap(_dst,_op0,_op1,1)
  #define _bupc_atomicU32_mswap_strict(_dst,_op0,_op1) \
	_bupc_atomicU32_mswap(_dst,_op0,_op1,1)
  #define _bupc_atomicI32_mswap_strict(_dst,_op0,_op1) \
	_bupc_atomicI32_mswap(_dst,_op0,_op1,1)
  #define _bupc_atomicU64_mswap_relaxed(_dst,_op0,_op1) \
	_bupc_atomicU64_mswap(_dst,_op0,_op1,0)
  #define _bupc_atomicI64_mswap_relaxed(_dst,_op0,_op1) \
	_bupc_atomicI64_mswap(_dst,_op0,_op1,0)
  #define _bupc_atomicU32_mswap_relaxed(_dst,_op0,_op1) \
	_bupc_atomicU32_mswap(_dst,_op0,_op1,0)
  #define _bupc_atomicI32_mswap_relaxed(_dst,_op0,_op1) \
	_bupc_atomicI32_mswap(_dst,_op0,_op1,0)
  #define _bupc_atomicU64_set_private(_dst,_val) \
	_bupc_atomic64_set_priv(_dst,(uint64_t)(_val))
  #define _bupc_atomicI64_set_private(_dst,_val) \
	_bupc_atomic64_set_priv(_dst,(int64_t)(_val))
  #define _bupc_atomicU32_set_private(_dst,_val) \
	_bupc_atomic32_set_priv(_dst,(uint32_t)(_val))
  #define _bupc_atomicI32_set_private(_dst,_val) \
	_bupc_atomic32_set_priv(_dst,(int32_t)(_val))
  #define _bupc_atomicU64_read_private(_src) \
	((uint64_t)_bupc_atomic64_read_priv(_src))
  #define _bupc_atomicI64_read_private(_src) \
	((int64_t)_bupc_atomic64_read_priv(_src))
  #define _bupc_atomicU32_read_private(_src) \
	((uint32_t)_bupc_atomic32_read_priv(_src))
  #define _bupc_atomicI32_read_private(_src) \
	((int32_t)_bupc_atomic32_read_priv(_src))
  #define _bupc_atomicU64_fetchadd_private(_dst,_op) \
	_bupc_atomicU64_fetchadd_priv(_dst,_op)
  #define _bupc_atomicI64_fetchadd_private(_dst,_op) \
	_bupc_atomicI64_fetchadd_priv(_dst,_op)
  #define _bupc_atomicU32_fetchadd_private(_dst,_op) \
	_bupc_atomicU32_fetchadd_priv(_dst,_op)
  #define _bupc_atomicI32_fetchadd_private(_dst,_op) \
	_bupc_atomicI32_fetchadd_priv(_dst,_op)
  #define _bupc_atomicU64_fetchand_private(_dst,_op) \
	_bupc_atomicU64_fetchand_priv(_dst,_op)
  #define _bupc_atomicI64_fetchand_private(_dst,_op) \
	_bupc_atomicI64_fetchand_priv(_dst,_op)
  #define _bupc_atomicU32_fetchand_private(_dst,_op) \
	_bupc_atomicU32_fetchand_priv(_dst,_op)
  #define _bupc_atomicI32_fetchand_private(_dst,_op) \
	_bupc_atomicI32_fetchand_priv(_dst,_op)
  #define _bupc_atomicU64_fetchor_private(_dst,_op) \
	_bupc_atomicU64_fetchor_priv(_dst,_op)
  #define _bupc_atomicI64_fetchor_private(_dst,_op) \
	_bupc_atomicI64_fetchor_priv(_dst,_op)
  #define _bupc_atomicU32_fetchor_private(_dst,_op) \
	_bupc_atomicU32_fetchor_priv(_dst,_op)
  #define _bupc_atomicI32_fetchor_private(_dst,_op) \
	_bupc_atomicI32_fetchor_priv(_dst,_op)
  #define _bupc_atomicU64_fetchxor_private(_dst,_op) \
	_bupc_atomicU64_fetchxor_priv(_dst,_op)
  #define _bupc_atomicI64_fetchxor_private(_dst,_op) \
	_bupc_atomicI64_fetchxor_priv(_dst,_op)
  #define _bupc_atomicU32_fetchxor_private(_dst,_op) \
	_bupc_atomicU32_fetchxor_priv(_dst,_op)
  #define _bupc_atomicI32_fetchxor_private(_dst,_op) \
	_bupc_atomicI32_fetchxor_priv(_dst,_op)
  #define _bupc_atomicU64_swap_private(_dst,_op) \
	_bupc_atomicU64_swap_priv(_dst,_op)
  #define _bupc_atomicI64_swap_private(_dst,_op) \
	_bupc_atomicI64_swap_priv(_dst,_op)
  #define _bupc_atomicU32_swap_private(_dst,_op) \
	_bupc_atomicU32_swap_priv(_dst,_op)
  #define _bupc_atomicI32_swap_private(_dst,_op) \
	_bupc_atomicI32_swap_priv(_dst,_op)
  #define _bupc_atomicU64_fetchnot_private(_dst) \
	_bupc_atomicU64_fetchnot_priv(_dst)
  #define _bupc_atomicI64_fetchnot_private(_dst) \
	_bupc_atomicI64_fetchnot_priv(_dst)
  #define _bupc_atomicU32_fetchnot_private(_dst) \
	_bupc_atomicU32_fetchnot_priv(_dst)
  #define _bupc_atomicI32_fetchnot_private(_dst) \
	_bupc_atomicI32_fetchnot_priv(_dst)
  #define _bupc_atomicU64_cswap_private(_dst,_op0,_op1) \
	_bupc_atomicU64_cswap_priv(_dst,_op0,_op1)
  #define _bupc_atomicI64_cswap_private(_dst,_op0,_op1) \
	_bupc_atomicI64_cswap_priv(_dst,_op0,_op1)
  #define _bupc_atomicU32_cswap_private(_dst,_op0,_op1) \
	_bupc_atomicU32_cswap_priv(_dst,_op0,_op1)
  #define _bupc_atomicI32_cswap_private(_dst,_op0,_op1) \
	_bupc_atomicI32_cswap_priv(_dst,_op0,_op1)
  #define _bupc_atomicU64_mswap_private(_dst,_op0,_op1) \
	_bupc_atomicU64_mswap_priv(_dst,_op0,_op1)
  #define _bupc_atomicI64_mswap_private(_dst,_op0,_op1) \
	_bupc_atomicI64_mswap_priv(_dst,_op0,_op1)
  #define _bupc_atomicU32_mswap_private(_dst,_op0,_op1) \
	_bupc_atomicU32_mswap_priv(_dst,_op0,_op1)
  #define _bupc_atomicI32_mswap_private(_dst,_op0,_op1) \
	_bupc_atomicI32_mswap_priv(_dst,_op0,_op1)
#else
  #define bupc_atomicU64_set_strict(_dst,_val) \
	(upcri_srcpos(),_bupc_atomic64_set(_dst,(uint64_t)(_val),1 UPCRI_PT_PASS))
  #define bupc_atomicI64_set_strict(_dst,_val) \
	(upcri_srcpos(),_bupc_atomic64_set(_dst,(int64_t)(_val),1 UPCRI_PT_PASS))
  #define bupc_atomicU32_set_strict(_dst,_val) \
	(upcri_srcpos(),_bupc_atomic32_set(_dst,(uint32_t)(_val),1 UPCRI_PT_PASS))
  #define bupc_atomicI32_set_strict(_dst,_val) \
	(upcri_srcpos(),_bupc_atomic32_set(_dst,(int32_t)(_val),1 UPCRI_PT_PASS))
  #define bupc_atomicU64_set_relaxed(_dst,_val) \
	(upcri_srcpos(),_bupc_atomic64_set(_dst,(uint64_t)(_val),0 UPCRI_PT_PASS))
  #define bupc_atomicI64_set_relaxed(_dst,_val) \
	(upcri_srcpos(),_bupc_atomic64_set(_dst,(int64_t)(_val),0 UPCRI_PT_PASS))
  #define bupc_atomicU32_set_relaxed(_dst,_val) \
	(upcri_srcpos(),_bupc_atomic32_set(_dst,(uint32_t)(_val),0 UPCRI_PT_PASS))
  #define bupc_atomicI32_set_relaxed(_dst,_val) \
	(upcri_srcpos(),_bupc_atomic32_set(_dst,(int32_t)(_val),0 UPCRI_PT_PASS))
  #define bupc_atomicU64_read_strict(_src) \
	(upcri_srcpos(),(uint64_t)_bupc_atomic64_read(_src,1 UPCRI_PT_PASS))
  #define bupc_atomicI64_read_strict(_src) \
	(upcri_srcpos(),(int64_t)_bupc_atomic64_read(_src,1 UPCRI_PT_PASS))
  #define bupc_atomicU32_read_strict(_src) \
	(upcri_srcpos(),(uint32_t)_bupc_atomic32_read(_src,1 UPCRI_PT_PASS))
  #define bupc_atomicI32_read_strict(_src) \
	(upcri_srcpos(),(int32_t)_bupc_atomic32_read(_src,1 UPCRI_PT_PASS))
  #define bupc_atomicU64_read_relaxed(_src) \
	(upcri_srcpos(),(uint64_t)_bupc_atomic64_read(_src,0 UPCRI_PT_PASS))
  #define bupc_atomicI64_read_relaxed(_src) \
	(upcri_srcpos(),(int64_t)_bupc_atomic64_read(_src,0 UPCRI_PT_PASS))
  #define bupc_atomicU32_read_relaxed(_src) \
	(upcri_srcpos(),(uint32_t)_bupc_atomic32_read(_src,0 UPCRI_PT_PASS))
  #define bupc_atomicI32_read_relaxed(_src) \
	(upcri_srcpos(),(int32_t)_bupc_atomic32_read(_src,0 UPCRI_PT_PASS))
  #define bupc_atomicU64_fetchadd_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU64_fetchadd(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicI64_fetchadd_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI64_fetchadd(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicU32_fetchadd_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU32_fetchadd(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicI32_fetchadd_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI32_fetchadd(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicU64_fetchadd_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU64_fetchadd(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicI64_fetchadd_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI64_fetchadd(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicU32_fetchadd_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU32_fetchadd(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicI32_fetchadd_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI32_fetchadd(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicU64_fetchand_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU64_fetchand(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicI64_fetchand_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI64_fetchand(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicU32_fetchand_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU32_fetchand(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicI32_fetchand_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI32_fetchand(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicU64_fetchand_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU64_fetchand(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicI64_fetchand_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI64_fetchand(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicU32_fetchand_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU32_fetchand(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicI32_fetchand_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI32_fetchand(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicU64_fetchor_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU64_fetchor(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicI64_fetchor_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI64_fetchor(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicU32_fetchor_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU32_fetchor(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicI32_fetchor_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI32_fetchor(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicU64_fetchor_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU64_fetchor(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicI64_fetchor_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI64_fetchor(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicU32_fetchor_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU32_fetchor(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicI32_fetchor_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI32_fetchor(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicU64_fetchxor_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU64_fetchxor(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicI64_fetchxor_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI64_fetchxor(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicU32_fetchxor_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU32_fetchxor(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicI32_fetchxor_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI32_fetchxor(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicU64_fetchxor_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU64_fetchxor(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicI64_fetchxor_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI64_fetchxor(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicU32_fetchxor_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU32_fetchxor(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicI32_fetchxor_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI32_fetchxor(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicU64_swap_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU64_swap(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicI64_swap_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI64_swap(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicU32_swap_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU32_swap(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicI32_swap_strict(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI32_swap(_dst,_op,1 UPCRI_PT_PASS))
  #define bupc_atomicU64_swap_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU64_swap(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicI64_swap_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI64_swap(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicU32_swap_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicU32_swap(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicI32_swap_relaxed(_dst,_op) \
	(upcri_srcpos(),_bupc_atomicI32_swap(_dst,_op,0 UPCRI_PT_PASS))
  #define bupc_atomicU64_fetchnot_strict(_dst) \
	(upcri_srcpos(),_bupc_atomicU64_fetchnot(_dst,1 UPCRI_PT_PASS))
  #define bupc_atomicI64_fetchnot_strict(_dst) \
	(upcri_srcpos(),_bupc_atomicI64_fetchnot(_dst,1 UPCRI_PT_PASS))
  #define bupc_atomicU32_fetchnot_strict(_dst) \
	(upcri_srcpos(),_bupc_atomicU32_fetchnot(_dst,1 UPCRI_PT_PASS))
  #define bupc_atomicI32_fetchnot_strict(_dst) \
	(upcri_srcpos(),_bupc_atomicI32_fetchnot(_dst,1 UPCRI_PT_PASS))
  #define bupc_atomicU64_fetchnot_relaxed(_dst) \
	(upcri_srcpos(),_bupc_atomicU64_fetchnot(_dst,0 UPCRI_PT_PASS))
  #define bupc_atomicI64_fetchnot_relaxed(_dst) \
	(upcri_srcpos(),_bupc_atomicI64_fetchnot(_dst,0 UPCRI_PT_PASS))
  #define bupc_atomicU32_fetchnot_relaxed(_dst) \
	(upcri_srcpos(),_bupc_atomicU32_fetchnot(_dst,0 UPCRI_PT_PASS))
  #define bupc_atomicI32_fetchnot_relaxed(_dst) \
	(upcri_srcpos(),_bupc_atomicI32_fetchnot(_dst,0 UPCRI_PT_PASS))
  #define bupc_atomicU64_cswap_strict(_dst,_op0,_op1) \
	(upcri_srcpos(),_bupc_atomicU64_cswap(_dst,_op0,_op1,1 UPCRI_PT_PASS))
  #define bupc_atomicI64_cswap_strict(_dst,_op0,_op1) \
	(upcri_srcpos(),_bupc_atomicI64_cswap(_dst,_op0,_op1,1 UPCRI_PT_PASS))
  #define bupc_atomicU32_cswap_strict(_dst,_op0,_op1) \
	(upcri_srcpos(),_bupc_atomicU32_cswap(_dst,_op0,_op1,1 UPCRI_PT_PASS))
  #define bupc_atomicI32_cswap_strict(_dst,_op0,_op1) \
	(upcri_srcpos(),_bupc_atomicI32_cswap(_dst,_op0,_op1,1 UPCRI_PT_PASS))
  #define bupc_atomicU64_cswap_relaxed(_dst,_op0,_op1) \
	(upcri_srcpos(),_bupc_atomicU64_cswap(_dst,_op0,_op1,0 UPCRI_PT_PASS))
  #define bupc_atomicI64_cswap_relaxed(_dst,_op0,_op1) \
	(upcri_srcpos(),_bupc_atomicI64_cswap(_dst,_op0,_op1,0 UPCRI_PT_PASS))
  #define bupc_atomicU32_cswap_relaxed(_dst,_op0,_op1) \
	(upcri_srcpos(),_bupc_atomicU32_cswap(_dst,_op0,_op1,0 UPCRI_PT_PASS))
  #define bupc_atomicI32_cswap_relaxed(_dst,_op0,_op1) \
	(upcri_srcpos(),_bupc_atomicI32_cswap(_dst,_op0,_op1,0 UPCRI_PT_PASS))
  #define bupc_atomicU64_mswap_strict(_dst,_op0,_op1) \
	(upcri_srcpos(),_bupc_atomicU64_mswap(_dst,_op0,_op1,1 UPCRI_PT_PASS))
  #define bupc_atomicI64_mswap_strict(_dst,_op0,_op1) \
	(upcri_srcpos(),_bupc_atomicI64_mswap(_dst,_op0,_op1,1 UPCRI_PT_PASS))
  #define bupc_atomicU32_mswap_strict(_dst,_op0,_op1) \
	(upcri_srcpos(),_bupc_atomicU32_mswap(_dst,_op0,_op1,1 UPCRI_PT_PASS))
  #define bupc_atomicI32_mswap_strict(_dst,_op0,_op1) \
	(upcri_srcpos(),_bupc_atomicI32_mswap(_dst,_op0,_op1,1 UPCRI_PT_PASS))
  #define bupc_atomicU64_mswap_relaxed(_dst,_op0,_op1) \
	(upcri_srcpos(),_bupc_atomicU64_mswap(_dst,_op0,_op1,0 UPCRI_PT_PASS))
  #define bupc_atomicI64_mswap_relaxed(_dst,_op0,_op1) \
	(upcri_srcpos(),_bupc_atomicI64_mswap(_dst,_op0,_op1,0 UPCRI_PT_PASS))
  #define bupc_atomicU32_mswap_relaxed(_dst,_op0,_op1) \
	(upcri_srcpos(),_bupc_atomicU32_mswap(_dst,_op0,_op1,0 UPCRI_PT_PASS))
  #define bupc_atomicI32_mswap_relaxed(_dst,_op0,_op1) \
	(upcri_srcpos(),_bupc_atomicI32_mswap(_dst,_op0,_op1,0 UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU64_set_private) GASNETT_DEPRECATED 
  void bupc_atomicU64_set_private(void) {/*empty*/} 
  #define bupc_atomicU64_set_private(_dst,_val) \
	(upcri_srcpos(),bupc_atomicU64_set_private (),\
         _bupc_atomic64_set_priv(_dst,(uint64_t)(_val) UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI64_set_private) GASNETT_DEPRECATED 
  void bupc_atomicI64_set_private(void) {/*empty*/} 
  #define bupc_atomicI64_set_private(_dst,_val) \
	(upcri_srcpos(),bupc_atomicI64_set_private (),\
         _bupc_atomic64_set_priv(_dst,(int64_t)(_val) UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU32_set_private) GASNETT_DEPRECATED 
  void bupc_atomicU32_set_private(void) {/*empty*/} 
  #define bupc_atomicU32_set_private(_dst,_val) \
	(upcri_srcpos(),bupc_atomicU32_set_private (),\
         _bupc_atomic32_set_priv(_dst,(uint32_t)(_val) UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI32_set_private) GASNETT_DEPRECATED 
  void bupc_atomicI32_set_private(void) {/*empty*/} 
  #define bupc_atomicI32_set_private(_dst,_val) \
	(upcri_srcpos(),bupc_atomicI32_set_private (),\
         _bupc_atomic32_set_priv(_dst,(int32_t)(_val) UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU64_read_private) GASNETT_DEPRECATED 
  void bupc_atomicU64_read_private(void) {/*empty*/} 
  #define bupc_atomicU64_read_private(_src) \
	(upcri_srcpos(),bupc_atomicU64_read_private (),\
         (uint64_t)_bupc_atomic64_read_priv(_src UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI64_read_private) GASNETT_DEPRECATED 
  void bupc_atomicI64_read_private(void) {/*empty*/} 
  #define bupc_atomicI64_read_private(_src) \
	(upcri_srcpos(),bupc_atomicI64_read_private (),\
         (int64_t)_bupc_atomic64_read_priv(_src UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU32_read_private) GASNETT_DEPRECATED 
  void bupc_atomicU32_read_private(void) {/*empty*/} 
  #define bupc_atomicU32_read_private(_src) \
	(upcri_srcpos(),bupc_atomicU32_read_private (),\
         (uint32_t)_bupc_atomic32_read_priv(_src UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI32_read_private) GASNETT_DEPRECATED 
  void bupc_atomicI32_read_private(void) {/*empty*/} 
  #define bupc_atomicI32_read_private(_src) \
	(upcri_srcpos(),bupc_atomicI32_read_private (),\
         (int32_t)_bupc_atomic32_read_priv(_src UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU64_fetchadd_private) GASNETT_DEPRECATED 
  void bupc_atomicU64_fetchadd_private(void) {/*empty*/} 
  #define bupc_atomicU64_fetchadd_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicU64_fetchadd_private (),\
         _bupc_atomicU64_fetchadd_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI64_fetchadd_private) GASNETT_DEPRECATED 
  void bupc_atomicI64_fetchadd_private(void) {/*empty*/} 
  #define bupc_atomicI64_fetchadd_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicI64_fetchadd_private (),\
         _bupc_atomicI64_fetchadd_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU32_fetchadd_private) GASNETT_DEPRECATED 
  void bupc_atomicU32_fetchadd_private(void) {/*empty*/} 
  #define bupc_atomicU32_fetchadd_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicU32_fetchadd_private (),\
         _bupc_atomicU32_fetchadd_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI32_fetchadd_private) GASNETT_DEPRECATED 
  void bupc_atomicI32_fetchadd_private(void) {/*empty*/} 
  #define bupc_atomicI32_fetchadd_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicI32_fetchadd_private (),\
         _bupc_atomicI32_fetchadd_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU64_fetchand_private) GASNETT_DEPRECATED 
  void bupc_atomicU64_fetchand_private(void) {/*empty*/} 
  #define bupc_atomicU64_fetchand_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicU64_fetchand_private (),\
         _bupc_atomicU64_fetchand_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI64_fetchand_private) GASNETT_DEPRECATED 
  void bupc_atomicI64_fetchand_private(void) {/*empty*/} 
  #define bupc_atomicI64_fetchand_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicI64_fetchand_private (),\
         _bupc_atomicI64_fetchand_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU32_fetchand_private) GASNETT_DEPRECATED 
  void bupc_atomicU32_fetchand_private(void) {/*empty*/} 
  #define bupc_atomicU32_fetchand_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicU32_fetchand_private (),\
         _bupc_atomicU32_fetchand_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI32_fetchand_private) GASNETT_DEPRECATED 
  void bupc_atomicI32_fetchand_private(void) {/*empty*/} 
  #define bupc_atomicI32_fetchand_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicI32_fetchand_private (),\
         _bupc_atomicI32_fetchand_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU64_fetchor_private) GASNETT_DEPRECATED 
  void bupc_atomicU64_fetchor_private(void) {/*empty*/} 
  #define bupc_atomicU64_fetchor_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicU64_fetchor_private (),\
         _bupc_atomicU64_fetchor_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI64_fetchor_private) GASNETT_DEPRECATED 
  void bupc_atomicI64_fetchor_private(void) {/*empty*/} 
  #define bupc_atomicI64_fetchor_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicI64_fetchor_private (),\
         _bupc_atomicI64_fetchor_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU32_fetchor_private) GASNETT_DEPRECATED 
  void bupc_atomicU32_fetchor_private(void) {/*empty*/} 
  #define bupc_atomicU32_fetchor_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicU32_fetchor_private (),\
         _bupc_atomicU32_fetchor_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI32_fetchor_private) GASNETT_DEPRECATED 
  void bupc_atomicI32_fetchor_private(void) {/*empty*/} 
  #define bupc_atomicI32_fetchor_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicI32_fetchor_private (),\
         _bupc_atomicI32_fetchor_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU64_fetchxor_private) GASNETT_DEPRECATED 
  void bupc_atomicU64_fetchxor_private(void) {/*empty*/} 
  #define bupc_atomicU64_fetchxor_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicU64_fetchxor_private (),\
         _bupc_atomicU64_fetchxor_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI64_fetchxor_private) GASNETT_DEPRECATED 
  void bupc_atomicI64_fetchxor_private(void) {/*empty*/} 
  #define bupc_atomicI64_fetchxor_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicI64_fetchxor_private (),\
         _bupc_atomicI64_fetchxor_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU32_fetchxor_private) GASNETT_DEPRECATED 
  void bupc_atomicU32_fetchxor_private(void) {/*empty*/} 
  #define bupc_atomicU32_fetchxor_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicU32_fetchxor_private (),\
         _bupc_atomicU32_fetchxor_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI32_fetchxor_private) GASNETT_DEPRECATED 
  void bupc_atomicI32_fetchxor_private(void) {/*empty*/} 
  #define bupc_atomicI32_fetchxor_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicI32_fetchxor_private (),\
         _bupc_atomicI32_fetchxor_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU64_swap_private) GASNETT_DEPRECATED 
  void bupc_atomicU64_swap_private(void) {/*empty*/} 
  #define bupc_atomicU64_swap_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicU64_swap_private (),\
         _bupc_atomicU64_swap_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI64_swap_private) GASNETT_DEPRECATED 
  void bupc_atomicI64_swap_private(void) {/*empty*/} 
  #define bupc_atomicI64_swap_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicI64_swap_private (),\
         _bupc_atomicI64_swap_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU32_swap_private) GASNETT_DEPRECATED 
  void bupc_atomicU32_swap_private(void) {/*empty*/} 
  #define bupc_atomicU32_swap_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicU32_swap_private (),\
         _bupc_atomicU32_swap_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI32_swap_private) GASNETT_DEPRECATED 
  void bupc_atomicI32_swap_private(void) {/*empty*/} 
  #define bupc_atomicI32_swap_private(_dst,_op) \
	(upcri_srcpos(),bupc_atomicI32_swap_private (),\
         _bupc_atomicI32_swap_priv(_dst,_op UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU64_fetchnot_private) GASNETT_DEPRECATED 
  void bupc_atomicU64_fetchnot_private(void) {/*empty*/} 
  #define bupc_atomicU64_fetchnot_private(_dst) \
	(upcri_srcpos(),bupc_atomicU64_fetchnot_private (),\
         _bupc_atomicU64_fetchnot_priv(_dst UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI64_fetchnot_private) GASNETT_DEPRECATED 
  void bupc_atomicI64_fetchnot_private(void) {/*empty*/} 
  #define bupc_atomicI64_fetchnot_private(_dst) \
	(upcri_srcpos(),bupc_atomicI64_fetchnot_private (),\
         _bupc_atomicI64_fetchnot_priv(_dst UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU32_fetchnot_private) GASNETT_DEPRECATED 
  void bupc_atomicU32_fetchnot_private(void) {/*empty*/} 
  #define bupc_atomicU32_fetchnot_private(_dst) \
	(upcri_srcpos(),bupc_atomicU32_fetchnot_private (),\
         _bupc_atomicU32_fetchnot_priv(_dst UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI32_fetchnot_private) GASNETT_DEPRECATED 
  void bupc_atomicI32_fetchnot_private(void) {/*empty*/} 
  #define bupc_atomicI32_fetchnot_private(_dst) \
	(upcri_srcpos(),bupc_atomicI32_fetchnot_private (),\
         _bupc_atomicI32_fetchnot_priv(_dst UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU64_cswap_private) GASNETT_DEPRECATED 
  void bupc_atomicU64_cswap_private(void) {/*empty*/} 
  #define bupc_atomicU64_cswap_private(_dst,_op0,_op1) \
	(upcri_srcpos(),bupc_atomicU64_cswap_private (),\
         _bupc_atomicU64_cswap_priv(_dst,_op0,_op1 UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI64_cswap_private) GASNETT_DEPRECATED 
  void bupc_atomicI64_cswap_private(void) {/*empty*/} 
  #define bupc_atomicI64_cswap_private(_dst,_op0,_op1) \
	(upcri_srcpos(),bupc_atomicI64_cswap_private (),\
         _bupc_atomicI64_cswap_priv(_dst,_op0,_op1 UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU32_cswap_private) GASNETT_DEPRECATED 
  void bupc_atomicU32_cswap_private(void) {/*empty*/} 
  #define bupc_atomicU32_cswap_private(_dst,_op0,_op1) \
	(upcri_srcpos(),bupc_atomicU32_cswap_private (),\
         _bupc_atomicU32_cswap_priv(_dst,_op0,_op1 UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI32_cswap_private) GASNETT_DEPRECATED 
  void bupc_atomicI32_cswap_private(void) {/*empty*/} 
  #define bupc_atomicI32_cswap_private(_dst,_op0,_op1) \
	(upcri_srcpos(),bupc_atomicI32_cswap_private (),\
         _bupc_atomicI32_cswap_priv(_dst,_op0,_op1 UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU64_mswap_private) GASNETT_DEPRECATED 
  void bupc_atomicU64_mswap_private(void) {/*empty*/} 
  #define bupc_atomicU64_mswap_private(_dst,_op0,_op1) \
	(upcri_srcpos(),bupc_atomicU64_mswap_private (),\
         _bupc_atomicU64_mswap_priv(_dst,_op0,_op1 UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI64_mswap_private) GASNETT_DEPRECATED 
  void bupc_atomicI64_mswap_private(void) {/*empty*/} 
  #define bupc_atomicI64_mswap_private(_dst,_op0,_op1) \
	(upcri_srcpos(),bupc_atomicI64_mswap_private (),\
         _bupc_atomicI64_mswap_priv(_dst,_op0,_op1 UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicU32_mswap_private) GASNETT_DEPRECATED 
  void bupc_atomicU32_mswap_private(void) {/*empty*/} 
  #define bupc_atomicU32_mswap_private(_dst,_op0,_op1) \
	(upcri_srcpos(),bupc_atomicU32_mswap_private (),\
         _bupc_atomicU32_mswap_priv(_dst,_op0,_op1 UPCRI_PT_PASS))
  GASNETT_INLINE(bupc_atomicI32_mswap_private) GASNETT_DEPRECATED 
  void bupc_atomicI32_mswap_private(void) {/*empty*/} 
  #define bupc_atomicI32_mswap_private(_dst,_op0,_op1) \
	(upcri_srcpos(),bupc_atomicI32_mswap_private (),\
         _bupc_atomicI32_mswap_priv(_dst,_op0,_op1 UPCRI_PT_PASS))
#endif

#endif /* UPCR_ATOMIC_DEFS_H */
