/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.db.DatabaseEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayBinding
implements EntryBinding<byte[]> {
    private static byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];

    @Override
    public byte[] entryToObject(DatabaseEntry databaseEntry) {
        int n = databaseEntry.getSize();
        if (n == 0) {
            return ZERO_LENGTH_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(databaseEntry.getData(), databaseEntry.getOffset(), byArray, 0, byArray.length);
        return byArray;
    }

    @Override
    public void objectToEntry(byte[] byArray, DatabaseEntry databaseEntry) {
        databaseEntry.setData(byArray, 0, byArray.length);
    }
}

