/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;
import java.math.BigDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalBinding
extends TupleBinding<BigDecimal> {
    @Override
    public BigDecimal entryToObject(TupleInput tupleInput) {
        return tupleInput.readBigDecimal();
    }

    @Override
    public void objectToEntry(BigDecimal bigDecimal, TupleOutput tupleOutput) {
        tupleOutput.writeBigDecimal(bigDecimal);
    }

    @Override
    protected TupleOutput getTupleOutput(BigDecimal bigDecimal) {
        return BigDecimalBinding.sizedOutput(bigDecimal);
    }

    public static BigDecimal entryToBigDecimal(DatabaseEntry databaseEntry) {
        return BigDecimalBinding.entryToInput(databaseEntry).readBigDecimal();
    }

    public static void bigDecimalToEntry(BigDecimal bigDecimal, DatabaseEntry databaseEntry) {
        BigDecimalBinding.outputToEntry(BigDecimalBinding.sizedOutput(bigDecimal).writeBigDecimal(bigDecimal), databaseEntry);
    }

    private static TupleOutput sizedOutput(BigDecimal bigDecimal) {
        int n = TupleOutput.getBigDecimalMaxByteLength(bigDecimal);
        return new TupleOutput(new byte[n]);
    }
}

