/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerBinding
extends TupleBinding<Integer> {
    private static final int INT_SIZE = 4;

    @Override
    public Integer entryToObject(TupleInput tupleInput) {
        return tupleInput.readInt();
    }

    @Override
    public void objectToEntry(Integer n, TupleOutput tupleOutput) {
        tupleOutput.writeInt(n);
    }

    @Override
    protected TupleOutput getTupleOutput(Integer n) {
        return IntegerBinding.sizedOutput();
    }

    public static int entryToInt(DatabaseEntry databaseEntry) {
        return IntegerBinding.entryToInput(databaseEntry).readInt();
    }

    public static void intToEntry(int n, DatabaseEntry databaseEntry) {
        IntegerBinding.outputToEntry(IntegerBinding.sizedOutput().writeInt(n), databaseEntry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[4]);
    }
}

