/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.DataView;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.util.keyrange.KeyRange;
import com.sleepycat.util.keyrange.RangeCursor;

class MyRangeCursor
extends RangeCursor {
    private DataView view;
    private boolean isRecnoOrQueue;
    private boolean writeCursor;

    MyRangeCursor(KeyRange keyRange, CursorConfig cursorConfig, DataView dataView, boolean bl) throws DatabaseException {
        super(keyRange, dataView.dupsRange, dataView.dupsOrdered, MyRangeCursor.openCursor(dataView, cursorConfig, bl));
        this.view = dataView;
        this.isRecnoOrQueue = dataView.recNumAllowed && !dataView.btreeRecNumDb;
        this.writeCursor = MyRangeCursor.isWriteCursor(cursorConfig, bl);
    }

    private static boolean isWriteCursor(CursorConfig cursorConfig, boolean bl) {
        return DbCompat.getWriteCursor(cursorConfig) || cursorConfig == CursorConfig.DEFAULT && bl;
    }

    private static Cursor openCursor(DataView dataView, CursorConfig cursorConfig, boolean bl) throws DatabaseException {
        return dataView.currentTxn.openCursor(dataView.db, cursorConfig, MyRangeCursor.isWriteCursor(cursorConfig, bl), dataView.useTransaction());
    }

    protected Cursor dupCursor(Cursor cursor, boolean bl) throws DatabaseException {
        return this.view.currentTxn.dupCursor(cursor, this.writeCursor, bl);
    }

    protected void closeCursor(Cursor cursor) throws DatabaseException {
        this.view.currentTxn.closeCursor(cursor);
    }

    protected boolean checkRecordNumber() {
        return this.isRecnoOrQueue;
    }
}

