/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.util.Collection;
import java.util.Iterator;

public abstract class StoredContainer
implements Cloneable {
    DataView view;

    StoredContainer(DataView dataView) {
        this.view = dataView;
    }

    public final boolean isWriteAllowed() {
        return this.view.writeAllowed;
    }

    public final CursorConfig getCursorConfig() {
        return DbCompat.cloneCursorConfig(this.view.cursorConfig);
    }

    public final boolean isTransactional() {
        return this.view.transactional;
    }

    final StoredContainer configuredClone(CursorConfig cursorConfig) {
        try {
            StoredContainer storedContainer = (StoredContainer)this.clone();
            storedContainer.view = storedContainer.view.configuredView(cursorConfig);
            storedContainer.initAfterClone();
            return storedContainer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    void initAfterClone() {
    }

    public final boolean areDuplicatesAllowed() {
        return this.view.dupsAllowed;
    }

    public final boolean areDuplicatesOrdered() {
        return this.view.dupsOrdered;
    }

    public final boolean areKeysRenumbered() {
        return this.view.keysRenumbered;
    }

    public final boolean isOrdered() {
        return this.view.ordered;
    }

    public final boolean areKeyRangesAllowed() {
        return this.view.keyRangesAllowed;
    }

    public final boolean isSecondary() {
        return this.view.isSecondary();
    }

    public abstract int size();

    public boolean isEmpty() {
        try {
            return this.view.isEmpty();
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    public void clear() {
        boolean bl = this.beginAutoCommit();
        try {
            this.view.clear();
            this.commitAutoCommit(bl);
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    Object getValue(Object object) {
        DataCursor dataCursor;
        block5: {
            dataCursor = null;
            dataCursor = new DataCursor(this.view, false);
            if (OperationStatus.SUCCESS != dataCursor.getSearchKey(object, null, false)) break block5;
            Object object2 = dataCursor.getCurrentValue();
            this.closeCursor(dataCursor);
            return object2;
        }
        try {
            Object var3_4 = null;
            this.closeCursor(dataCursor);
            return var3_4;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
    }

    Object putKeyValue(Object object, Object object2) {
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            Object[] objectArray = new Object[1];
            dataCursor.put(object, object2, objectArray, false);
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return objectArray[0];
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    final boolean removeKey(Object object, Object[] objectArray) {
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            boolean bl2 = false;
            OperationStatus operationStatus = dataCursor.getSearchKey(object, null, true);
            while (operationStatus == OperationStatus.SUCCESS) {
                dataCursor.delete();
                bl2 = true;
                if (objectArray != null && objectArray[0] == null) {
                    objectArray[0] = dataCursor.getCurrentValue();
                }
                operationStatus = this.areDuplicatesAllowed() ? dataCursor.getNextDup(true) : OperationStatus.NOTFOUND;
            }
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return bl2;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    boolean containsKey(Object object) {
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            boolean bl = OperationStatus.SUCCESS == dataCursor.getSearchKey(object, null, false);
            this.closeCursor(dataCursor);
            return bl;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
    }

    final boolean removeValue(Object object) {
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            OperationStatus operationStatus = dataCursor.findValue(object, true);
            if (operationStatus == OperationStatus.SUCCESS) {
                dataCursor.delete();
            }
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return operationStatus == OperationStatus.SUCCESS;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    boolean containsValue(Object object) {
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            OperationStatus operationStatus = dataCursor.findValue(object, true);
            boolean bl = operationStatus == OperationStatus.SUCCESS;
            this.closeCursor(dataCursor);
            return bl;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
    }

    final Iterator storedOrExternalIterator(Collection collection) {
        if (collection instanceof StoredCollection) {
            return ((StoredCollection)collection).storedIterator();
        }
        return collection.iterator();
    }

    final void closeCursor(DataCursor dataCursor) {
        if (dataCursor != null) {
            try {
                dataCursor.close();
            }
            catch (Exception exception) {
                throw StoredContainer.convertException(exception);
            }
        }
    }

    final boolean beginAutoCommit() {
        if (this.view.transactional) {
            CurrentTransaction currentTransaction = this.view.getCurrentTxn();
            try {
                if (currentTransaction.isAutoCommitAllowed()) {
                    currentTransaction.beginTransaction(null);
                    return true;
                }
            }
            catch (DatabaseException databaseException) {
                throw RuntimeExceptionWrapper.wrapIfNeeded(databaseException);
            }
        }
        return false;
    }

    final void commitAutoCommit(boolean bl) throws DatabaseException {
        if (bl) {
            this.view.getCurrentTxn().commitTransaction();
        }
    }

    final RuntimeException handleException(Exception exception, boolean bl) {
        if (bl) {
            try {
                this.view.getCurrentTxn().abortTransaction();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        return StoredContainer.convertException(exception);
    }

    static RuntimeException convertException(Exception exception) {
        return RuntimeExceptionWrapper.wrapIfNeeded(exception);
    }
}

