/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.TupleSerialMarshalledBinding;
import com.sleepycat.bind.serial.TupleSerialMarshalledKeyCreator;
import com.sleepycat.bind.tuple.MarshalledTupleKeyEntity;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleMarshalledBinding;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.db.Database;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleSerialFactory {
    private ClassCatalog catalog;

    public TupleSerialFactory(ClassCatalog classCatalog) {
        this.catalog = classCatalog;
    }

    public final ClassCatalog getCatalog() {
        return this.catalog;
    }

    public <K, V extends MarshalledTupleKeyEntity> StoredMap<K, V> newMap(Database database, Class<K> clazz, Class<V> clazz2, boolean bl) {
        return new StoredMap<K, V>(database, this.getKeyBinding(clazz), this.getEntityBinding(clazz2), bl);
    }

    public <K, V extends MarshalledTupleKeyEntity> StoredSortedMap<K, V> newSortedMap(Database database, Class<K> clazz, Class<V> clazz2, boolean bl) {
        return new StoredSortedMap<K, V>(database, this.getKeyBinding(clazz), this.getEntityBinding(clazz2), bl);
    }

    public <V extends MarshalledTupleKeyEntity> TupleSerialMarshalledKeyCreator<V> getKeyCreator(Class<V> clazz, String string) {
        return new TupleSerialMarshalledKeyCreator<V>(this.getEntityBinding(clazz), string);
    }

    public <V extends MarshalledTupleKeyEntity> TupleSerialMarshalledBinding<V> getEntityBinding(Class<V> clazz) {
        return new TupleSerialMarshalledBinding<V>(this.catalog, clazz);
    }

    private <K> EntryBinding<K> getKeyBinding(Class<K> clazz) {
        TupleBinding<K> tupleBinding = TupleBinding.getPrimitiveBinding(clazz);
        if (tupleBinding == null) {
            tupleBinding = new TupleMarshalledBinding<K>(clazz);
        }
        return tupleBinding;
    }
}

