/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.Environment;
import com.sleepycat.db.internal.DbEnv;

public class DatabaseException
extends Exception {
    private Environment dbenv;
    private int errno;

    public DatabaseException(Throwable throwable) {
        super(throwable);
        this.errno = 0;
        this.dbenv = null;
    }

    public DatabaseException(String string) {
        this(string, 0, (Environment)null);
    }

    public DatabaseException(String string, int n) {
        this(string, n, (Environment)null);
    }

    public DatabaseException(String string, int n, Environment environment) {
        super(string);
        this.errno = n;
        this.dbenv = environment;
    }

    DatabaseException(String string, int n, DbEnv dbEnv) {
        this(string, n, dbEnv == null ? null : dbEnv.wrapper);
    }

    public Environment getEnvironment() {
        return this.dbenv;
    }

    public int getErrno() {
        return this.errno;
    }

    public String toString() {
        String string = super.toString();
        if (this.errno != 0) {
            string = string + ": " + DbEnv.strerror(this.errno);
        }
        return string;
    }
}

