/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.Cursor;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.DatabaseStreamConfig;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.internal.DbStream;

public class DatabaseStream {
    DbStream dbs;
    Cursor cursor;
    DatabaseStreamConfig config;

    protected DatabaseStream(Cursor cursor, DatabaseStreamConfig databaseStreamConfig) {
        this.cursor = cursor;
        this.config = databaseStreamConfig;
    }

    DatabaseStream(Cursor cursor, DbStream dbStream, DatabaseStreamConfig databaseStreamConfig) throws DatabaseException {
        this.cursor = cursor;
        this.dbs = dbStream;
        this.config = databaseStreamConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws DatabaseException {
        if (this.dbs != null) {
            try {
                this.dbs.close(0);
            }
            finally {
                this.dbs = null;
            }
        }
    }

    public DatabaseStreamConfig getConfig() {
        return this.config;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public OperationStatus read(DatabaseEntry databaseEntry, long l, int n) throws DatabaseException, IllegalArgumentException {
        return OperationStatus.fromInt(this.dbs.read(databaseEntry, l, n, 0));
    }

    public long size() throws DatabaseException {
        return this.dbs.size(0);
    }

    public OperationStatus write(DatabaseEntry databaseEntry, long l) throws DatabaseException, IllegalArgumentException {
        return OperationStatus.fromInt(this.dbs.write(databaseEntry, l, 0));
    }
}

