/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.ReplicationHostAddress;
import com.sleepycat.db.ReplicationManagerSiteConfig;
import com.sleepycat.db.internal.DbSite;

public class ReplicationManagerSite {
    private DbSite dbsite;

    ReplicationManagerSite(DbSite dbSite) throws DatabaseException {
        this.dbsite = dbSite;
        dbSite.wrapper = this;
    }

    public void close() throws DatabaseException {
        this.dbsite.close();
    }

    public ReplicationHostAddress getAddress() throws DatabaseException {
        ReplicationHostAddress replicationHostAddress = this.dbsite.get_address();
        return replicationHostAddress;
    }

    public ReplicationManagerSiteConfig getConfig() throws DatabaseException {
        return new ReplicationManagerSiteConfig(this.dbsite);
    }

    public int getEid() throws DatabaseException {
        return this.dbsite.get_eid();
    }

    public void setBootstrapHelper(boolean bl) throws DatabaseException {
        this.dbsite.set_config(1, bl);
    }

    public boolean getBootstrapHelper() throws DatabaseException {
        return this.dbsite.get_config(1);
    }

    public void setGroupCreator(boolean bl) throws DatabaseException {
        this.dbsite.set_config(2, bl);
    }

    public boolean getGroupCreator() throws DatabaseException {
        return this.dbsite.get_config(2);
    }

    public void setLegacy(boolean bl) throws DatabaseException {
        this.dbsite.set_config(4, bl);
    }

    public boolean getLegacy() throws DatabaseException {
        return this.dbsite.get_config(4);
    }

    public void setLocalSite(boolean bl) throws DatabaseException {
        this.dbsite.set_config(8, bl);
    }

    public boolean getLocalSite() throws DatabaseException {
        return this.dbsite.get_config(8);
    }

    public void setPeer(boolean bl) throws DatabaseException {
        this.dbsite.set_config(16, bl);
    }

    public boolean getPeer() throws DatabaseException {
        return this.dbsite.get_config(16);
    }

    public void remove() throws DatabaseException {
        this.dbsite.remove();
    }
}

