/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.ForeignKeyDeleteAction;
import com.sleepycat.db.ForeignKeyNullifier;
import com.sleepycat.db.ForeignMultiKeyNullifier;
import com.sleepycat.db.SecondaryKeyCreator;
import com.sleepycat.db.SecondaryMultiKeyCreator;
import com.sleepycat.db.internal.Db;
import com.sleepycat.db.internal.DbEnv;
import com.sleepycat.db.internal.DbTxn;
import java.io.FileNotFoundException;

public class SecondaryConfig
extends DatabaseConfig
implements Cloneable {
    public static final SecondaryConfig DEFAULT = new SecondaryConfig();
    private boolean allowPopulate;
    private boolean immutableSecondaryKey;
    private Db foreign;
    private ForeignKeyDeleteAction fkDelAction;
    private ForeignKeyNullifier keyNullifier;
    private ForeignMultiKeyNullifier multiKeyNullifier;
    private SecondaryKeyCreator keyCreator;
    private SecondaryMultiKeyCreator multiKeyCreator;

    static SecondaryConfig checkNull(SecondaryConfig secondaryConfig) {
        return secondaryConfig == null ? DEFAULT : secondaryConfig;
    }

    public SecondaryConfig() {
    }

    public void setAllowPopulate(boolean bl) {
        this.allowPopulate = bl;
    }

    public boolean getAllowPopulate() {
        return this.allowPopulate;
    }

    public void setImmutableSecondaryKey(boolean bl) {
        this.immutableSecondaryKey = bl;
    }

    public boolean getImmutableSecondaryKey() {
        return this.immutableSecondaryKey;
    }

    public void setKeyCreator(SecondaryKeyCreator secondaryKeyCreator) {
        this.keyCreator = secondaryKeyCreator;
    }

    public SecondaryKeyCreator getKeyCreator() {
        return this.keyCreator;
    }

    public void setMultiKeyCreator(SecondaryMultiKeyCreator secondaryMultiKeyCreator) {
        this.multiKeyCreator = secondaryMultiKeyCreator;
    }

    public SecondaryMultiKeyCreator getMultiKeyCreator() {
        return this.multiKeyCreator;
    }

    public void setForeignKeyDatabase(Database database) {
        this.foreign = database.db;
    }

    public Db getForeignKeyDatabase() {
        return this.foreign;
    }

    public void setForeignKeyDeleteAction(ForeignKeyDeleteAction foreignKeyDeleteAction) {
        this.fkDelAction = foreignKeyDeleteAction;
    }

    public ForeignKeyDeleteAction getForeignKeyDeleteAction() {
        return this.fkDelAction;
    }

    public void setForeignKeyNullifier(ForeignKeyNullifier foreignKeyNullifier) {
        this.keyNullifier = foreignKeyNullifier;
    }

    public ForeignKeyNullifier getForeignKeyNullifier() {
        return this.keyNullifier;
    }

    public void setForeignMultiKeyNullifier(ForeignMultiKeyNullifier foreignMultiKeyNullifier) {
        this.multiKeyNullifier = foreignMultiKeyNullifier;
    }

    public ForeignMultiKeyNullifier getForeignMultiKeyNullifier() {
        return this.multiKeyNullifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Db openSecondaryDatabase(DbEnv dbEnv, DbTxn dbTxn, String string, String string2, Db db) throws DatabaseException, FileNotFoundException {
        int n = 0;
        int n2 = 0;
        n |= this.allowPopulate ? 1 : 0;
        if (this.getTransactional() && dbTxn == null) {
            n |= 0x100;
        }
        if (this.immutableSecondaryKey) {
            n |= 2;
        }
        Db db2 = super.openDatabase(dbEnv, dbTxn, string, string2);
        boolean bl = false;
        try {
            db2.set_secmultikey_create(this.multiKeyCreator);
            db.associate(dbTxn, db2, this.keyCreator, n);
            if (this.foreign != null) {
                db2.set_foreignmultikey_nullifier(this.multiKeyNullifier);
                this.foreign.associate_foreign(db2, this.keyNullifier, n2 | this.fkDelAction.getId());
            }
            bl = true;
            Db db3 = db2;
            return db3;
        }
        finally {
            if (!bl) {
                try {
                    db2.close(0);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    SecondaryConfig(Db db) throws DatabaseException {
        super(db);
        int n = db.get_assoc_flags();
        this.allowPopulate = (n & 2) != 0;
        this.immutableSecondaryKey = (n & 1) != 0;
        this.keyCreator = db.get_seckey_create();
        this.multiKeyCreator = db.get_secmultikey_create();
    }
}

