/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db.internal;

import com.sleepycat.db.BtreeCompressor;
import com.sleepycat.db.BtreePrefixCalculator;
import com.sleepycat.db.CompactStats;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.ErrorHandler;
import com.sleepycat.db.FeedbackHandler;
import com.sleepycat.db.ForeignKeyNullifier;
import com.sleepycat.db.ForeignMultiKeyNullifier;
import com.sleepycat.db.Hasher;
import com.sleepycat.db.KeyRange;
import com.sleepycat.db.MessageHandler;
import com.sleepycat.db.PanicHandler;
import com.sleepycat.db.PartitionHandler;
import com.sleepycat.db.RecordNumberAppender;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.SecondaryKeyCreator;
import com.sleepycat.db.SecondaryMultiKeyCreator;
import com.sleepycat.db.internal.DbEnv;
import com.sleepycat.db.internal.DbMpoolFile;
import com.sleepycat.db.internal.DbTxn;
import com.sleepycat.db.internal.Dbc;
import com.sleepycat.db.internal.db_java;
import com.sleepycat.db.internal.db_javaJNI;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashSet;

public class Db {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    static final int GIGABYTE = 0x40000000;
    private long db_ref;
    private DbEnv dbenv;
    private boolean private_dbenv;
    public Database wrapper;
    private RecordNumberAppender append_recno_handler;
    private Comparator bt_compare_handler;
    private BtreeCompressor bt_compress_handler;
    private BtreeCompressor bt_decompress_handler;
    private BtreePrefixCalculator bt_prefix_handler;
    private Comparator dup_compare_handler;
    private FeedbackHandler db_feedback_handler;
    private Comparator h_compare_handler;
    private Hasher h_hash_handler;
    private PartitionHandler partition_handler;
    private SecondaryKeyCreator seckey_create_handler;
    private SecondaryMultiKeyCreator secmultikey_create_handler;
    private ForeignKeyNullifier foreignkey_nullify_handler;
    private ForeignMultiKeyNullifier foreignmultikey_nullify_handler;

    protected Db(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Db db) {
        return db == null ? 0L : db.swigCPtr;
    }

    synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                throw new UnsupportedOperationException("C++ destructor does not have public access");
            }
            this.swigCPtr = 0L;
        }
    }

    private void initialize(DbEnv dbEnv) {
        if (dbEnv == null) {
            this.private_dbenv = true;
            dbEnv = db_java.getDbEnv0(this);
            dbEnv.initialize();
        }
        this.dbenv = dbEnv;
        this.db_ref = db_java.initDbRef0(this, this);
    }

    private void cleanup() {
        this.swigCPtr = 0L;
        db_java.deleteRef0(this.db_ref);
        this.db_ref = 0L;
        if (this.private_dbenv) {
            this.dbenv.cleanup();
        }
        this.dbenv = null;
    }

    public boolean getPrivateDbEnv() throws DatabaseException {
        return this.private_dbenv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(int n) throws DatabaseException {
        try {
            this.close0(n);
        }
        finally {
            this.cleanup();
        }
    }

    public DbEnv get_env() throws DatabaseException {
        return this.dbenv;
    }

    private final void handle_append_recno(DatabaseEntry databaseEntry, int n) throws DatabaseException {
        this.append_recno_handler.appendRecordNumber(this.wrapper, databaseEntry, n);
    }

    public RecordNumberAppender get_append_recno() throws DatabaseException {
        return this.append_recno_handler;
    }

    private final int handle_bt_compare(byte[] byArray, byte[] byArray2) {
        return this.bt_compare_handler.compare(byArray, byArray2);
    }

    private final int handle_bt_compress(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, DatabaseEntry databaseEntry4, DatabaseEntry databaseEntry5) {
        return this.bt_compress_handler.compress(this.wrapper, databaseEntry, databaseEntry2, databaseEntry3, databaseEntry4, databaseEntry5) ? 0 : -30999;
    }

    private final int handle_bt_decompress(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, DatabaseEntry databaseEntry4, DatabaseEntry databaseEntry5) {
        return this.bt_compress_handler.decompress(this.wrapper, databaseEntry, databaseEntry2, databaseEntry3, databaseEntry4, databaseEntry5) ? 0 : -30999;
    }

    public Comparator get_bt_compare() throws DatabaseException {
        return this.bt_compare_handler;
    }

    public BtreeCompressor get_bt_compress() throws DatabaseException {
        return this.bt_compress_handler;
    }

    public BtreeCompressor get_bt_decompress() throws DatabaseException {
        return this.bt_decompress_handler;
    }

    private final int handle_bt_prefix(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        return this.bt_prefix_handler.prefix(this.wrapper, databaseEntry, databaseEntry2);
    }

    public BtreePrefixCalculator get_bt_prefix() throws DatabaseException {
        return this.bt_prefix_handler;
    }

    private final void handle_db_feedback(int n, int n2) {
        if (n == 1) {
            this.db_feedback_handler.upgradeFeedback(this.wrapper, n2);
        } else if (n == 2) {
            this.db_feedback_handler.upgradeFeedback(this.wrapper, n2);
        }
    }

    public FeedbackHandler get_feedback() throws DatabaseException {
        return this.db_feedback_handler;
    }

    private final int handle_h_compare(byte[] byArray, byte[] byArray2) {
        return this.h_compare_handler.compare(byArray, byArray2);
    }

    public Comparator get_h_compare() throws DatabaseException {
        return this.h_compare_handler;
    }

    private final int handle_dup_compare(byte[] byArray, byte[] byArray2) {
        return this.dup_compare_handler.compare(byArray, byArray2);
    }

    public Comparator get_dup_compare() throws DatabaseException {
        return this.dup_compare_handler;
    }

    private final int handle_h_hash(byte[] byArray, int n) {
        return this.h_hash_handler.hash(this.wrapper, byArray, n);
    }

    public Hasher get_h_hash() throws DatabaseException {
        return this.h_hash_handler;
    }

    private final boolean handle_foreignkey_nullify(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3) throws DatabaseException {
        if (this.foreignmultikey_nullify_handler != null) {
            return this.foreignmultikey_nullify_handler.nullifyForeignKey((SecondaryDatabase)this.wrapper, databaseEntry, databaseEntry2, databaseEntry3);
        }
        return this.foreignkey_nullify_handler.nullifyForeignKey((SecondaryDatabase)this.wrapper, databaseEntry2);
    }

    private final DatabaseEntry[] handle_seckey_create(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        if (this.secmultikey_create_handler != null) {
            HashSet hashSet = new HashSet();
            this.secmultikey_create_handler.createSecondaryKeys((SecondaryDatabase)this.wrapper, databaseEntry, databaseEntry2, hashSet);
            if (!hashSet.isEmpty()) {
                return hashSet.toArray(new DatabaseEntry[hashSet.size()]);
            }
        } else {
            DatabaseEntry databaseEntry3 = new DatabaseEntry();
            if (this.seckey_create_handler.createSecondaryKey((SecondaryDatabase)this.wrapper, databaseEntry, databaseEntry2, databaseEntry3)) {
                DatabaseEntry[] databaseEntryArray = new DatabaseEntry[]{databaseEntry3};
                return databaseEntryArray;
            }
        }
        return null;
    }

    public SecondaryKeyCreator get_seckey_create() throws DatabaseException {
        return this.seckey_create_handler;
    }

    public SecondaryMultiKeyCreator get_secmultikey_create() throws DatabaseException {
        return this.secmultikey_create_handler;
    }

    public void set_secmultikey_create(SecondaryMultiKeyCreator secondaryMultiKeyCreator) {
        this.secmultikey_create_handler = secondaryMultiKeyCreator;
    }

    public void set_foreignmultikey_nullifier(ForeignMultiKeyNullifier foreignMultiKeyNullifier) {
        this.foreignmultikey_nullify_handler = foreignMultiKeyNullifier;
    }

    private final int handle_partition(DatabaseEntry databaseEntry) {
        return this.partition_handler.partition(this.wrapper, databaseEntry);
    }

    public PartitionHandler get_partition_callback() throws DatabaseException {
        return this.partition_handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(String string, String string2, int n) throws DatabaseException, FileNotFoundException {
        try {
            this.remove0(string, string2, n);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rename(String string, String string2, String string3, int n) throws DatabaseException, FileNotFoundException {
        try {
            this.rename0(string, string2, string3, n);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean verify(String string, String string2, OutputStream outputStream, int n) throws DatabaseException, FileNotFoundException {
        try {
            boolean bl = this.verify0(string, string2, outputStream, n);
            return bl;
        }
        finally {
            this.cleanup();
        }
    }

    public ErrorHandler get_errcall() {
        return this.dbenv.get_errcall();
    }

    public void set_errcall(ErrorHandler errorHandler) {
        this.dbenv.set_errcall(errorHandler);
    }

    public OutputStream get_error_stream() {
        return this.dbenv.get_error_stream();
    }

    public void set_error_stream(OutputStream outputStream) {
        this.dbenv.set_error_stream(outputStream);
    }

    public void set_errpfx(String string) {
        this.dbenv.set_errpfx(string);
    }

    public String get_errpfx() {
        return this.dbenv.get_errpfx();
    }

    public OutputStream get_message_stream() {
        return this.dbenv.get_message_stream();
    }

    public void set_message_stream(OutputStream outputStream) {
        this.dbenv.set_message_stream(outputStream);
    }

    public MessageHandler get_msgcall() {
        return this.dbenv.get_msgcall();
    }

    public void set_msgcall(MessageHandler messageHandler) {
        this.dbenv.set_msgcall(messageHandler);
    }

    public void set_paniccall(PanicHandler panicHandler) throws DatabaseException {
        this.dbenv.set_paniccall(panicHandler);
    }

    public PanicHandler get_paniccall() throws DatabaseException {
        return this.dbenv.get_paniccall();
    }

    public Db(DbEnv dbEnv, int n) throws DatabaseException {
        this(db_javaJNI.new_Db(DbEnv.getCPtr(dbEnv), dbEnv, n), true);
        this.initialize(dbEnv);
    }

    public void associate(DbTxn dbTxn, Db db, SecondaryKeyCreator secondaryKeyCreator, int n) throws DatabaseException {
        db_javaJNI.Db_associate(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, Db.getCPtr(db), db, (db.seckey_create_handler = secondaryKeyCreator) != null || db.secmultikey_create_handler != null, n);
    }

    public void associate_foreign(Db db, ForeignKeyNullifier foreignKeyNullifier, int n) throws DatabaseException {
        db_javaJNI.Db_associate_foreign(this.swigCPtr, this, Db.getCPtr(db), db, (db.foreignkey_nullify_handler = foreignKeyNullifier) != null || db.foreignmultikey_nullify_handler != null, n);
    }

    public void compact(DbTxn dbTxn, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, CompactStats compactStats, int n, DatabaseEntry databaseEntry3) throws DatabaseException {
        db_javaJNI.Db_compact(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, databaseEntry, databaseEntry2, compactStats, n, databaseEntry3);
    }

    int close0(int n) {
        return db_javaJNI.Db_close0(this.swigCPtr, this, n);
    }

    public Dbc cursor(DbTxn dbTxn, int n) throws DatabaseException {
        long l = db_javaJNI.Db_cursor(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, n);
        return l == 0L ? null : new Dbc(l, false);
    }

    public int del(DbTxn dbTxn, DatabaseEntry databaseEntry, int n) throws DatabaseException {
        return db_javaJNI.Db_del(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, databaseEntry, n);
    }

    public void err(int n, String string) {
        db_javaJNI.Db_err(this.swigCPtr, this, n, string);
    }

    public void errx(String string) {
        db_javaJNI.Db_errx(this.swigCPtr, this, string);
    }

    public int exists(DbTxn dbTxn, DatabaseEntry databaseEntry, int n) throws DatabaseException {
        return db_javaJNI.Db_exists(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, databaseEntry, n);
    }

    public int get(DbTxn dbTxn, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, int n) throws DatabaseException {
        return db_javaJNI.Db_get(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, databaseEntry, databaseEntry2, n);
    }

    public int get_assoc_flags() throws DatabaseException {
        return db_javaJNI.Db_get_assoc_flags(this.swigCPtr, this);
    }

    public String get_blob_dir() throws DatabaseException {
        return db_javaJNI.Db_get_blob_dir(this.swigCPtr, this);
    }

    public String get_blob_sub_dir() throws DatabaseException {
        return db_javaJNI.Db_get_blob_sub_dir(this.swigCPtr, this);
    }

    public int get_blob_threshold() throws DatabaseException {
        return db_javaJNI.Db_get_blob_threshold(this.swigCPtr, this);
    }

    public boolean get_byteswapped() throws DatabaseException {
        return db_javaJNI.Db_get_byteswapped(this.swigCPtr, this);
    }

    public long get_cachesize() throws DatabaseException {
        return db_javaJNI.Db_get_cachesize(this.swigCPtr, this);
    }

    public int get_cachesize_ncache() throws DatabaseException {
        return db_javaJNI.Db_get_cachesize_ncache(this.swigCPtr, this);
    }

    public String get_create_dir() throws DatabaseException {
        return db_javaJNI.Db_get_create_dir(this.swigCPtr, this);
    }

    public String get_filename() throws DatabaseException {
        return db_javaJNI.Db_get_filename(this.swigCPtr, this);
    }

    public String get_dbname() throws DatabaseException {
        return db_javaJNI.Db_get_dbname(this.swigCPtr, this);
    }

    public int get_encrypt_flags() throws DatabaseException {
        return db_javaJNI.Db_get_encrypt_flags(this.swigCPtr, this);
    }

    public int get_flags() throws DatabaseException {
        return db_javaJNI.Db_get_flags(this.swigCPtr, this);
    }

    public int get_lk_exclusive() throws DatabaseException {
        return db_javaJNI.Db_get_lk_exclusive(this.swigCPtr, this);
    }

    public int get_lorder() throws DatabaseException {
        return db_javaJNI.Db_get_lorder(this.swigCPtr, this);
    }

    public DbMpoolFile get_mpf() throws DatabaseException {
        long l = db_javaJNI.Db_get_mpf(this.swigCPtr, this);
        return l == 0L ? null : new DbMpoolFile(l, false);
    }

    public int get_open_flags() throws DatabaseException {
        return db_javaJNI.Db_get_open_flags(this.swigCPtr, this);
    }

    public int get_pagesize() throws DatabaseException {
        return db_javaJNI.Db_get_pagesize(this.swigCPtr, this);
    }

    public int get_bt_minkey() throws DatabaseException {
        return db_javaJNI.Db_get_bt_minkey(this.swigCPtr, this);
    }

    public long get_heapsize() throws DatabaseException {
        return db_javaJNI.Db_get_heapsize(this.swigCPtr, this);
    }

    public int get_heap_regionsize() throws DatabaseException {
        return db_javaJNI.Db_get_heap_regionsize(this.swigCPtr, this);
    }

    public int get_h_ffactor() throws DatabaseException {
        return db_javaJNI.Db_get_h_ffactor(this.swigCPtr, this);
    }

    public int get_h_nelem() throws DatabaseException {
        return db_javaJNI.Db_get_h_nelem(this.swigCPtr, this);
    }

    public int get_re_delim() throws DatabaseException {
        return db_javaJNI.Db_get_re_delim(this.swigCPtr, this);
    }

    public int get_priority() throws DatabaseException {
        return db_javaJNI.Db_get_priority(this.swigCPtr, this);
    }

    public String[] get_partition_dirs() throws DatabaseException {
        return db_javaJNI.Db_get_partition_dirs(this.swigCPtr, this);
    }

    public DatabaseEntry get_partition_keys() throws DatabaseException {
        return db_javaJNI.Db_get_partition_keys(this.swigCPtr, this);
    }

    public int get_partition_parts() throws DatabaseException {
        return db_javaJNI.Db_get_partition_parts(this.swigCPtr, this);
    }

    public int get_re_len() throws DatabaseException {
        return db_javaJNI.Db_get_re_len(this.swigCPtr, this);
    }

    public int get_re_pad() throws DatabaseException {
        return db_javaJNI.Db_get_re_pad(this.swigCPtr, this);
    }

    public String get_re_source() throws DatabaseException {
        return db_javaJNI.Db_get_re_source(this.swigCPtr, this);
    }

    public int get_q_extentsize() throws DatabaseException {
        return db_javaJNI.Db_get_q_extentsize(this.swigCPtr, this);
    }

    public boolean get_multiple() throws DatabaseException {
        return db_javaJNI.Db_get_multiple(this.swigCPtr, this);
    }

    public boolean get_transactional() throws DatabaseException {
        return db_javaJNI.Db_get_transactional(this.swigCPtr, this);
    }

    public int get_type() throws DatabaseException {
        return db_javaJNI.Db_get_type(this.swigCPtr, this);
    }

    public Dbc join(Dbc[] dbcArray, int n) throws DatabaseException {
        long l = db_javaJNI.Db_join(this.swigCPtr, this, dbcArray, n);
        return l == 0L ? null : new Dbc(l, true);
    }

    public void key_range(DbTxn dbTxn, DatabaseEntry databaseEntry, KeyRange keyRange, int n) throws DatabaseException {
        db_javaJNI.Db_key_range(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, databaseEntry, keyRange, n);
    }

    public void open(DbTxn dbTxn, String string, String string2, int n, int n2, int n3) throws DatabaseException, FileNotFoundException {
        db_javaJNI.Db_open(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, string, string2, n, n2, n3);
    }

    public int pget(DbTxn dbTxn, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, int n) throws DatabaseException {
        return db_javaJNI.Db_pget(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, databaseEntry, databaseEntry2, databaseEntry3, n);
    }

    public int put(DbTxn dbTxn, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, int n) throws DatabaseException {
        return db_javaJNI.Db_put(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, databaseEntry, databaseEntry2, n);
    }

    void remove0(String string, String string2, int n) {
        db_javaJNI.Db_remove0(this.swigCPtr, this, string, string2, n);
    }

    void rename0(String string, String string2, String string3, int n) {
        db_javaJNI.Db_rename0(this.swigCPtr, this, string, string2, string3, n);
    }

    public void set_append_recno(RecordNumberAppender recordNumberAppender) throws DatabaseException {
        this.append_recno_handler = recordNumberAppender;
        db_javaJNI.Db_set_append_recno(this.swigCPtr, this, this.append_recno_handler != null);
    }

    public void set_blob_dir(String string) throws DatabaseException {
        db_javaJNI.Db_set_blob_dir(this.swigCPtr, this, string);
    }

    public void set_blob_threshold(int n, int n2) throws DatabaseException {
        db_javaJNI.Db_set_blob_threshold(this.swigCPtr, this, n, n2);
    }

    public void set_bt_compare(Comparator comparator) throws DatabaseException {
        this.bt_compare_handler = comparator;
        db_javaJNI.Db_set_bt_compare(this.swigCPtr, this, this.bt_compare_handler != null);
    }

    public void set_bt_minkey(int n) throws DatabaseException {
        db_javaJNI.Db_set_bt_minkey(this.swigCPtr, this, n);
    }

    public void set_bt_compress(BtreeCompressor btreeCompressor, BtreeCompressor btreeCompressor2) throws DatabaseException {
        this.bt_compress_handler = btreeCompressor;
        boolean bl = this.bt_compress_handler != null;
        this.bt_decompress_handler = btreeCompressor2;
        db_javaJNI.Db_set_bt_compress(this.swigCPtr, this, bl, this.bt_decompress_handler != null);
    }

    public void set_bt_prefix(BtreePrefixCalculator btreePrefixCalculator) throws DatabaseException {
        this.bt_prefix_handler = btreePrefixCalculator;
        db_javaJNI.Db_set_bt_prefix(this.swigCPtr, this, this.bt_prefix_handler != null);
    }

    public void set_cachesize(long l, int n) throws DatabaseException {
        db_javaJNI.Db_set_cachesize(this.swigCPtr, this, l, n);
    }

    public void set_create_dir(String string) throws DatabaseException {
        db_javaJNI.Db_set_create_dir(this.swigCPtr, this, string);
    }

    public void set_dup_compare(Comparator comparator) throws DatabaseException {
        this.dup_compare_handler = comparator;
        db_javaJNI.Db_set_dup_compare(this.swigCPtr, this, this.dup_compare_handler != null);
    }

    public void set_encrypt(String string, int n) throws DatabaseException {
        db_javaJNI.Db_set_encrypt(this.swigCPtr, this, string, n);
    }

    public void set_feedback(FeedbackHandler feedbackHandler) throws DatabaseException {
        this.db_feedback_handler = feedbackHandler;
        db_javaJNI.Db_set_feedback(this.swigCPtr, this, this.db_feedback_handler != null);
    }

    public void set_flags(int n) throws DatabaseException {
        db_javaJNI.Db_set_flags(this.swigCPtr, this, n);
    }

    public void set_heapsize(long l) throws DatabaseException {
        db_javaJNI.Db_set_heapsize(this.swigCPtr, this, l);
    }

    public void set_heap_regionsize(int n) throws DatabaseException {
        db_javaJNI.Db_set_heap_regionsize(this.swigCPtr, this, n);
    }

    public void set_h_compare(Comparator comparator) throws DatabaseException {
        this.h_compare_handler = comparator;
        db_javaJNI.Db_set_h_compare(this.swigCPtr, this, this.h_compare_handler != null);
    }

    public void set_h_ffactor(int n) throws DatabaseException {
        db_javaJNI.Db_set_h_ffactor(this.swigCPtr, this, n);
    }

    public void set_h_hash(Hasher hasher) throws DatabaseException {
        this.h_hash_handler = hasher;
        db_javaJNI.Db_set_h_hash(this.swigCPtr, this, this.h_hash_handler != null);
    }

    public void set_h_nelem(int n) throws DatabaseException {
        db_javaJNI.Db_set_h_nelem(this.swigCPtr, this, n);
    }

    public void set_lk_exclusive(int n) throws DatabaseException {
        db_javaJNI.Db_set_lk_exclusive(this.swigCPtr, this, n);
    }

    public void set_lorder(int n) throws DatabaseException {
        db_javaJNI.Db_set_lorder(this.swigCPtr, this, n);
    }

    public void set_pagesize(long l) throws DatabaseException {
        db_javaJNI.Db_set_pagesize(this.swigCPtr, this, l);
    }

    public void set_partition(int n, DatabaseEntry databaseEntry, PartitionHandler partitionHandler) throws DatabaseException {
        this.partition_handler = partitionHandler;
        db_javaJNI.Db_set_partition(this.swigCPtr, this, n, databaseEntry, this.partition_handler != null);
    }

    public void set_partition_dirs(String[] stringArray) throws DatabaseException {
        db_javaJNI.Db_set_partition_dirs(this.swigCPtr, this, stringArray);
    }

    public void set_priority(int n) throws DatabaseException {
        db_javaJNI.Db_set_priority(this.swigCPtr, this, n);
    }

    public void set_re_delim(int n) throws DatabaseException {
        db_javaJNI.Db_set_re_delim(this.swigCPtr, this, n);
    }

    public void set_re_len(int n) throws DatabaseException {
        db_javaJNI.Db_set_re_len(this.swigCPtr, this, n);
    }

    public void set_re_pad(int n) throws DatabaseException {
        db_javaJNI.Db_set_re_pad(this.swigCPtr, this, n);
    }

    public void set_re_source(String string) throws DatabaseException {
        db_javaJNI.Db_set_re_source(this.swigCPtr, this, string);
    }

    public void set_q_extentsize(int n) throws DatabaseException {
        db_javaJNI.Db_set_q_extentsize(this.swigCPtr, this, n);
    }

    public void sort_multiple(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        db_javaJNI.Db_sort_multiple(this.swigCPtr, this, databaseEntry, databaseEntry2);
    }

    public Object stat(DbTxn dbTxn, int n) throws DatabaseException {
        return db_javaJNI.Db_stat(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, n);
    }

    public void sync(int n) throws DatabaseException {
        db_javaJNI.Db_sync(this.swigCPtr, this, n);
    }

    public int truncate(DbTxn dbTxn, int n) throws DatabaseException {
        return db_javaJNI.Db_truncate(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, n);
    }

    public void upgrade(String string, int n) throws DatabaseException {
        db_javaJNI.Db_upgrade(this.swigCPtr, this, string, n);
    }

    boolean verify0(String string, String string2, OutputStream outputStream, int n) {
        return db_javaJNI.Db_verify0(this.swigCPtr, this, string, string2, outputStream, n);
    }
}

