/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryCursor;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.Transaction;
import com.sleepycat.persist.BasicIndex;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityIndex;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.PrimaryKeyValueAdapter;
import com.sleepycat.persist.SecondaryIndex;
import com.sleepycat.persist.SubIndexCursor;
import com.sleepycat.persist.ValueAdapter;
import com.sleepycat.util.keyrange.KeyRange;
import com.sleepycat.util.keyrange.RangeCursor;
import java.util.Map;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SubIndex<PK, E>
implements EntityIndex<PK, E> {
    private SecondaryIndex<?, PK, E> secIndex;
    private SecondaryDatabase db;
    private boolean transactional;
    private boolean sortedDups;
    private boolean locking;
    private boolean concurrentDB;
    private DatabaseEntry keyEntry;
    private Object keyObject;
    private KeyRange singleKeyRange;
    private EntryBinding pkeyBinding;
    private KeyRange emptyPKeyRange;
    private EntityBinding entityBinding;
    private ValueAdapter<PK> keyAdapter;
    private ValueAdapter<E> entityAdapter;
    private SortedMap<PK, E> map;

    <SK> SubIndex(SecondaryIndex<SK, PK, E> secondaryIndex, EntityBinding entityBinding, SK SK) throws DatabaseException {
        this.secIndex = secondaryIndex;
        this.db = secondaryIndex.getDatabase();
        this.transactional = secondaryIndex.transactional;
        this.sortedDups = secondaryIndex.sortedDups;
        this.locking = DbCompat.getInitializeLocking(this.db.getEnvironment().getConfig());
        Environment environment = this.db.getEnvironment();
        this.concurrentDB = DbCompat.getInitializeCDB(environment.getConfig());
        this.keyObject = SK;
        this.keyEntry = new DatabaseEntry();
        secondaryIndex.keyBinding.objectToEntry(SK, this.keyEntry);
        this.singleKeyRange = secondaryIndex.emptyRange.subRange(this.keyEntry);
        PrimaryIndex<PK, E> primaryIndex = secondaryIndex.getPrimaryIndex();
        this.pkeyBinding = primaryIndex.keyBinding;
        this.emptyPKeyRange = primaryIndex.emptyRange;
        this.entityBinding = entityBinding;
        this.keyAdapter = new PrimaryKeyValueAdapter<PK>(primaryIndex.keyClass, primaryIndex.keyBinding);
        this.entityAdapter = secondaryIndex.entityAdapter;
    }

    @Override
    public boolean contains(PK PK) throws DatabaseException {
        return this.contains((Transaction)null, PK, (LockMode)null);
    }

    @Override
    public boolean contains(Transaction transaction, PK PK, LockMode lockMode) throws DatabaseException {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        DatabaseEntry databaseEntry2 = BasicIndex.NO_RETURN_ENTRY;
        this.pkeyBinding.objectToEntry(PK, databaseEntry);
        OperationStatus operationStatus = this.db.getSearchBoth(transaction, this.keyEntry, databaseEntry, databaseEntry2, lockMode);
        return operationStatus == OperationStatus.SUCCESS;
    }

    @Override
    public E get(PK PK) throws DatabaseException {
        return this.get((Transaction)null, PK, (LockMode)null);
    }

    @Override
    public E get(Transaction transaction, PK PK, LockMode lockMode) throws DatabaseException {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        this.pkeyBinding.objectToEntry(PK, databaseEntry);
        OperationStatus operationStatus = this.db.getSearchBoth(transaction, this.keyEntry, databaseEntry, databaseEntry2, lockMode);
        if (operationStatus == OperationStatus.SUCCESS) {
            return this.entityBinding.entryToObject(databaseEntry, databaseEntry2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() throws DatabaseException {
        CursorConfig cursorConfig = this.locking ? CursorConfig.READ_UNCOMMITTED : null;
        EntityCursor<PK> entityCursor = this.keys(null, cursorConfig);
        try {
            if (entityCursor.next() != null) {
                long l = entityCursor.count();
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            entityCursor.close();
        }
    }

    @Override
    public boolean delete(PK PK) throws DatabaseException {
        return this.delete((Transaction)null, PK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(Transaction transaction, PK PK) throws DatabaseException {
        OperationStatus operationStatus;
        DatabaseEntry databaseEntry = new DatabaseEntry();
        DatabaseEntry databaseEntry2 = BasicIndex.NO_RETURN_ENTRY;
        this.pkeyBinding.objectToEntry(PK, databaseEntry);
        boolean bl = false;
        Environment environment = this.db.getEnvironment();
        if (this.transactional && transaction == null && DbCompat.getThreadTransaction(environment) == null) {
            transaction = environment.beginTransaction(null, this.secIndex.getAutoCommitTransactionConfig());
            bl = true;
        }
        boolean bl2 = true;
        CursorConfig cursorConfig = null;
        if (this.concurrentDB) {
            cursorConfig = new CursorConfig();
            DbCompat.setWriteCursor(cursorConfig, true);
        }
        SecondaryCursor secondaryCursor = this.db.openSecondaryCursor(transaction, cursorConfig);
        try {
            operationStatus = secondaryCursor.getSearchBoth(this.keyEntry, databaseEntry, databaseEntry2, this.locking ? LockMode.RMW : null);
            if (operationStatus == OperationStatus.SUCCESS) {
                operationStatus = secondaryCursor.delete();
            }
            bl2 = false;
        }
        finally {
            secondaryCursor.close();
            if (bl) {
                if (bl2) {
                    transaction.abort();
                } else {
                    transaction.commit();
                }
            }
        }
        return operationStatus == OperationStatus.SUCCESS;
    }

    @Override
    public EntityCursor<PK> keys() throws DatabaseException {
        return this.keys(null, null);
    }

    @Override
    public EntityCursor<PK> keys(Transaction transaction, CursorConfig cursorConfig) throws DatabaseException {
        return this.cursor(transaction, null, this.keyAdapter, cursorConfig);
    }

    @Override
    public EntityCursor<E> entities() throws DatabaseException {
        return this.cursor(null, null, this.entityAdapter, null);
    }

    @Override
    public EntityCursor<E> entities(Transaction transaction, CursorConfig cursorConfig) throws DatabaseException {
        return this.cursor(transaction, null, this.entityAdapter, cursorConfig);
    }

    @Override
    public EntityCursor<PK> keys(PK PK, boolean bl, PK PK2, boolean bl2) throws DatabaseException {
        return this.cursor(null, PK, bl, PK2, bl2, this.keyAdapter, null);
    }

    @Override
    public EntityCursor<PK> keys(Transaction transaction, PK PK, boolean bl, PK PK2, boolean bl2, CursorConfig cursorConfig) throws DatabaseException {
        return this.cursor(transaction, PK, bl, PK2, bl2, this.keyAdapter, cursorConfig);
    }

    @Override
    public EntityCursor<E> entities(PK PK, boolean bl, PK PK2, boolean bl2) throws DatabaseException {
        return this.cursor(null, PK, bl, PK2, bl2, this.entityAdapter, null);
    }

    @Override
    public EntityCursor<E> entities(Transaction transaction, PK PK, boolean bl, PK PK2, boolean bl2, CursorConfig cursorConfig) throws DatabaseException {
        return this.cursor(transaction, PK, bl, PK2, bl2, this.entityAdapter, cursorConfig);
    }

    private <V> EntityCursor<V> cursor(Transaction transaction, PK PK, boolean bl, PK PK2, boolean bl2, ValueAdapter<V> valueAdapter, CursorConfig cursorConfig) throws DatabaseException {
        DatabaseEntry databaseEntry = null;
        if (PK != null) {
            databaseEntry = new DatabaseEntry();
            this.pkeyBinding.objectToEntry(PK, databaseEntry);
        }
        DatabaseEntry databaseEntry2 = null;
        if (PK2 != null) {
            databaseEntry2 = new DatabaseEntry();
            this.pkeyBinding.objectToEntry(PK2, databaseEntry2);
        }
        KeyRange keyRange = this.emptyPKeyRange.subRange(databaseEntry, bl, databaseEntry2, bl2);
        return this.cursor(transaction, keyRange, valueAdapter, cursorConfig);
    }

    private <V> EntityCursor<V> cursor(Transaction transaction, KeyRange keyRange, ValueAdapter<V> valueAdapter, CursorConfig cursorConfig) throws DatabaseException {
        Cursor cursor = this.db.openCursor(transaction, cursorConfig);
        RangeCursor rangeCursor = new RangeCursor(this.singleKeyRange, keyRange, this.sortedDups, cursor);
        return new SubIndexCursor<V>(rangeCursor, valueAdapter);
    }

    @Override
    public Map<PK, E> map() {
        return this.sortedMap();
    }

    @Override
    public synchronized SortedMap<PK, E> sortedMap() {
        if (this.map == null) {
            this.map = (SortedMap)((StoredSortedMap)this.secIndex.sortedMap()).duplicatesMap(this.keyObject, this.pkeyBinding);
        }
        return this.map;
    }
}

