/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.ComplexFormat;
import com.sleepycat.persist.impl.Enhanced;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.impl.Reader;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.model.FieldMetadata;
import com.sleepycat.persist.model.PrimaryKeyMetadata;
import com.sleepycat.persist.model.SecondaryKeyMetadata;
import com.sleepycat.persist.raw.RawField;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import java.io.Serializable;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Format
implements Reader,
RawType,
Serializable {
    private static final long serialVersionUID = 545633644568489850L;
    static final int ID_NULL = 0;
    static final int ID_OBJECT = 1;
    static final int ID_BOOL = 2;
    static final int ID_BOOL_W = 3;
    static final int ID_BYTE = 4;
    static final int ID_BYTE_W = 5;
    static final int ID_SHORT = 6;
    static final int ID_SHORT_W = 7;
    static final int ID_INT = 8;
    static final int ID_INT_W = 9;
    static final int ID_LONG = 10;
    static final int ID_LONG_W = 11;
    static final int ID_FLOAT = 12;
    static final int ID_FLOAT_W = 13;
    static final int ID_DOUBLE = 14;
    static final int ID_DOUBLE_W = 15;
    static final int ID_CHAR = 16;
    static final int ID_CHAR_W = 17;
    static final int ID_STRING = 18;
    static final int ID_BIGINT = 19;
    static final int ID_BIGDEC = 20;
    static final int ID_DATE = 21;
    static final int ID_NUMBER = 22;
    static final int ID_SIMPLE_MIN = 2;
    static final int ID_SIMPLE_MAX = 21;
    static final int ID_PREDEFINED = 30;
    private int id;
    private String className;
    private Reader reader;
    private Format superFormat;
    private Format latestFormat;
    private Format previousFormat;
    private Set<String> supertypes;
    private boolean deleted;
    private boolean unused;
    private transient Catalog catalog;
    private transient Class type;
    private transient Format proxiedFormat;
    private transient boolean initialized;

    static boolean isPredefined(Format format) {
        return format.getId() <= 30;
    }

    Format(Catalog catalog, Class clazz) {
        this(catalog, clazz.getName());
        this.type = clazz;
        this.addSupertypes();
    }

    Format(Catalog catalog, String string) {
        assert (catalog != null);
        assert (string != null);
        this.catalog = catalog;
        this.className = string;
        this.latestFormat = this;
        this.supertypes = new HashSet<String>();
    }

    void migrateFromBeta(Map<String, Format> map) {
        if (this.latestFormat == null) {
            this.latestFormat = this;
        }
    }

    void initCatalog(Catalog catalog) {
        assert (catalog != null);
        this.catalog = catalog;
    }

    final boolean isNew() {
        return this.id == 0;
    }

    final Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public final int getId() {
        return this.id;
    }

    final void setId(int n) {
        this.id = n;
    }

    final Class getType() {
        return this.type;
    }

    final Class getExistingType() {
        assert (this.catalog != null);
        if (this.type == null) {
            try {
                this.type = this.catalog.resolveClass(this.className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw DbCompat.unexpectedException(classNotFoundException);
            }
        }
        return this.type;
    }

    final Reader getReader() {
        if (this != this.reader) {
            PersistCatalog.unevolvedFormatsEncountered = true;
        }
        return this.reader;
    }

    final void setReader(Reader reader) {
        this.reader = reader;
    }

    final Format getSuperFormat() {
        return this.superFormat;
    }

    final void setSuperFormat(Format format) {
        this.superFormat = format;
    }

    final Format getProxiedFormat() {
        return this.proxiedFormat;
    }

    final void setProxiedFormat(Format format) {
        this.proxiedFormat = format;
    }

    final Format getLatestVersion() {
        return this.latestFormat;
    }

    public final Format getPreviousVersion() {
        return this.previousFormat;
    }

    final void setLatestVersion(Format format) {
        if (this.latestFormat == this) {
            format.previousFormat = this;
        }
        this.latestFormat = format;
    }

    @Override
    public final boolean isDeleted() {
        return this.deleted;
    }

    final void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    final void setUnused(boolean bl) {
        this.unused = bl;
    }

    void setEvolveNeeded(boolean bl) {
        throw DbCompat.unexpectedState();
    }

    boolean getEvolveNeeded() {
        throw DbCompat.unexpectedState();
    }

    boolean getNewStringFormat() {
        throw DbCompat.unexpectedState();
    }

    final boolean isInitialized() {
        return this.initialized;
    }

    final void initializeIfNeeded(Catalog catalog, EntityModel entityModel) {
        assert (catalog != null);
        if (!this.initialized) {
            this.initialized = true;
            this.catalog = catalog;
            if (this.latestFormat == null) {
                this.latestFormat = this;
            }
            if (this.reader == null) {
                this.reader = this;
            }
            if (this.type == null && this.isCurrentVersion() && (this.isSimple() || !catalog.isRawAccess())) {
                this.getExistingType();
            }
            this.initialize(catalog, entityModel, catalog.getInitVersion(this, false));
            this.reader.initializeReader(catalog, entityModel, catalog.getInitVersion(this, true), this);
        }
    }

    @Override
    public void initializeReader(Catalog catalog, EntityModel entityModel, int n, Format format) {
    }

    private void addSupertypes() {
        this.addInterfaces(this.type);
        for (Class clazz = this.type.getSuperclass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            this.supertypes.add(clazz.getName());
            this.addInterfaces(clazz);
        }
    }

    private void addInterfaces(Class clazz) {
        Class<?>[] classArray;
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            if (clazz2 == Enhanced.class) continue;
            this.supertypes.add(clazz2.getName());
            this.addInterfaces(clazz2);
        }
    }

    boolean areNestedRefsProhibited() {
        return false;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public int getVersion() {
        ClassMetadata classMetadata = this.getClassMetadata();
        if (classMetadata != null) {
            return classMetadata.getVersion();
        }
        return 0;
    }

    @Override
    public Format getSuperType() {
        return this.superFormat;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public List<String> getEnumConstants() {
        return null;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public int getDimensions() {
        return 0;
    }

    @Override
    public Format getComponentType() {
        return null;
    }

    @Override
    public Map<String, RawField> getFields() {
        return null;
    }

    @Override
    public ClassMetadata getClassMetadata() {
        return null;
    }

    @Override
    public EntityMetadata getEntityMetadata() {
        return null;
    }

    boolean isAssignableTo(Format format) {
        if (this.proxiedFormat != null) {
            return this.proxiedFormat.isAssignableTo(format);
        }
        return format == this || format.id == 1 || this.supertypes.contains(format.className);
    }

    Format getWrapperFormat() {
        return null;
    }

    boolean isEntity() {
        return false;
    }

    boolean isModelClass() {
        return false;
    }

    ComplexFormat getEntityFormat() {
        return null;
    }

    abstract boolean evolve(Format var1, Evolver var2);

    boolean evolveMetadata(Format format, Converter converter, Evolver evolver) {
        return true;
    }

    final boolean isCurrentVersion() {
        return this.latestFormat == this && !this.deleted;
    }

    final boolean isSameClass(Format format) {
        return this.latestFormat == format.latestFormat;
    }

    abstract void initialize(Catalog var1, EntityModel var2, int var3);

    abstract void collectRelatedFormats(Catalog var1, Map<String, Format> var2);

    abstract Object newArray(int var1);

    @Override
    public abstract Object newInstance(EntityInput var1, boolean var2) throws RefreshException;

    @Override
    public abstract Object readObject(Object var1, EntityInput var2, boolean var3) throws RefreshException;

    abstract void writeObject(Object var1, EntityOutput var2, boolean var3) throws RefreshException;

    abstract void skipContents(RecordInput var1) throws RefreshException;

    Format skipToSecKey(RecordInput recordInput, String string) throws RefreshException {
        throw DbCompat.unexpectedState(this.toString());
    }

    void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
        throw DbCompat.unexpectedState(this.toString());
    }

    void copySecMultiKey(RecordInput recordInput, Format format, Set set) throws RefreshException {
        throw DbCompat.unexpectedState(this.toString());
    }

    boolean nullifySecKey(Catalog catalog, Object object, String string, Object object2) {
        throw DbCompat.unexpectedState(this.toString());
    }

    boolean isPriKeyNullOrZero(Object object, boolean bl) {
        throw DbCompat.unexpectedState(this.toString());
    }

    void writePriKey(Object object, EntityOutput entityOutput, boolean bl) throws RefreshException {
        throw DbCompat.unexpectedState(this.toString());
    }

    @Override
    public void readPriKey(Object object, EntityInput entityInput, boolean bl) throws RefreshException {
        throw DbCompat.unexpectedState(this.toString());
    }

    public String getOldKeyName(String string) {
        throw DbCompat.unexpectedState(this.toString());
    }

    Format getSequenceKeyFormat() {
        throw new IllegalArgumentException("Type not allowed for sequence: " + this.getClassName());
    }

    Object convertRawObject(Catalog catalog, boolean bl, RawObject rawObject, IdentityHashMap identityHashMap) throws RefreshException {
        throw DbCompat.unexpectedState(this.toString());
    }

    public boolean allowEvolveFromProxy() {
        return false;
    }

    @Override
    public Accessor getAccessor(boolean bl) {
        return null;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(500);
        if (this.isSimple()) {
            this.addTypeHeader(stringBuilder, "SimpleType");
            stringBuilder.append(" primitive=\"");
            stringBuilder.append(this.isPrimitive());
            stringBuilder.append("\"/>\n");
        } else if (this.isEnum()) {
            this.addTypeHeader(stringBuilder, "EnumType");
            stringBuilder.append(">\n");
            for (String string : this.getEnumConstants()) {
                stringBuilder.append("  ");
                stringBuilder.append("<Constant>");
                stringBuilder.append(string);
                stringBuilder.append("</Constant>\n");
            }
            stringBuilder.append("</EnumType>\n");
        } else if (this.isArray()) {
            this.addTypeHeader(stringBuilder, "ArrayType");
            stringBuilder.append(" componentId=\"");
            stringBuilder.append(this.getComponentType().getVersion());
            stringBuilder.append("\" componentClass=\"");
            stringBuilder.append(this.getComponentType().getClassName());
            stringBuilder.append("\" dimensions=\"");
            stringBuilder.append(this.getDimensions());
            stringBuilder.append("\"/>\n");
        } else {
            Format format;
            this.addTypeHeader(stringBuilder, "ComplexType");
            Format format2 = this.getSuperType();
            if (format2 != null) {
                stringBuilder.append(" superTypeId=\"");
                stringBuilder.append(format2.getId());
                stringBuilder.append("\" superTypeClass=\"");
                stringBuilder.append(format2.getClassName());
                stringBuilder.append('\"');
            }
            if ((format = this.getProxiedFormat()) != null) {
                stringBuilder.append(" proxiedTypeId=\"");
                stringBuilder.append(format.getId());
                stringBuilder.append("\" proxiedTypeClass=\"");
                stringBuilder.append(format.getClassName());
                stringBuilder.append('\"');
            }
            PrimaryKeyMetadata primaryKeyMetadata = null;
            Map<String, SecondaryKeyMetadata> map = null;
            List<FieldMetadata> list = null;
            ClassMetadata classMetadata = this.getClassMetadata();
            if (classMetadata != null) {
                list = classMetadata.getCompositeKeyFields();
                primaryKeyMetadata = classMetadata.getPrimaryKey();
                map = classMetadata.getSecondaryKeys();
            }
            stringBuilder.append(" kind=\"");
            stringBuilder.append(this.isEntity() ? "entity" : (list != null ? "compositeKey" : "persistent"));
            stringBuilder.append("\">\n");
            Map<String, RawField> map2 = this.getFields();
            if (map2 != null) {
                for (RawField object : map2.values()) {
                    SecondaryKeyMetadata secondaryKeyMetadata;
                    String string = object.getName();
                    RawType rawType = object.getType();
                    stringBuilder.append("  ");
                    stringBuilder.append("<Field");
                    stringBuilder.append(" name=\"");
                    stringBuilder.append(string);
                    stringBuilder.append("\" typeId=\"");
                    stringBuilder.append(rawType.getId());
                    stringBuilder.append("\" typeClass=\"");
                    stringBuilder.append(rawType.getClassName());
                    stringBuilder.append('\"');
                    if (primaryKeyMetadata != null && primaryKeyMetadata.getName().equals(string)) {
                        stringBuilder.append(" primaryKey=\"true\"");
                        if (primaryKeyMetadata.getSequenceName() != null) {
                            stringBuilder.append(" sequence=\"");
                            stringBuilder.append(primaryKeyMetadata.getSequenceName());
                            stringBuilder.append('\"');
                        }
                    }
                    if (map != null && (secondaryKeyMetadata = ComplexFormat.getSecondaryKeyMetadataByFieldName(map, string)) != null) {
                        stringBuilder.append(" secondaryKey=\"true\" keyName=\"");
                        stringBuilder.append(secondaryKeyMetadata.getKeyName());
                        stringBuilder.append("\" relate=\"");
                        stringBuilder.append((Object)secondaryKeyMetadata.getRelationship());
                        stringBuilder.append('\"');
                        String string2 = secondaryKeyMetadata.getRelatedEntity();
                        if (string2 != null) {
                            stringBuilder.append("\" relatedEntity=\"");
                            stringBuilder.append(string2);
                            stringBuilder.append("\" onRelatedEntityDelete=\"");
                            stringBuilder.append((Object)secondaryKeyMetadata.getDeleteAction());
                            stringBuilder.append('\"');
                        }
                    }
                    if (list != null) {
                        int n = list.size();
                        for (int i = 0; i < n; ++i) {
                            FieldMetadata fieldMetadata = list.get(i);
                            if (!fieldMetadata.getName().equals(string)) continue;
                            stringBuilder.append(" compositeKeyField=\"");
                            stringBuilder.append(i + 1);
                            stringBuilder.append('\"');
                        }
                    }
                    stringBuilder.append("/>\n");
                }
                EntityMetadata entityMetadata = this.getEntityMetadata();
                if (entityMetadata != null) {
                    stringBuilder.append("  ");
                    stringBuilder.append("<EntityKeys>\n");
                    primaryKeyMetadata = entityMetadata.getPrimaryKey();
                    if (primaryKeyMetadata != null) {
                        stringBuilder.append("    ");
                        stringBuilder.append("<Primary class=\"");
                        stringBuilder.append(primaryKeyMetadata.getDeclaringClassName());
                        stringBuilder.append("\" field=\"");
                        stringBuilder.append(primaryKeyMetadata.getName());
                        stringBuilder.append("\"/>\n");
                    }
                    if ((map = entityMetadata.getSecondaryKeys()) != null) {
                        for (SecondaryKeyMetadata secondaryKeyMetadata : map.values()) {
                            stringBuilder.append("    ");
                            stringBuilder.append("<Secondary class=\"");
                            stringBuilder.append(secondaryKeyMetadata.getDeclaringClassName());
                            stringBuilder.append("\" field=\"");
                            stringBuilder.append(secondaryKeyMetadata.getName());
                            stringBuilder.append("\"/>\n");
                        }
                    }
                    stringBuilder.append("</EntityKeys>\n");
                }
            }
            stringBuilder.append("</ComplexType>\n");
        }
        return stringBuilder.toString();
    }

    private void addTypeHeader(StringBuilder stringBuilder, String string) {
        Format format;
        stringBuilder.append('<');
        stringBuilder.append(string);
        stringBuilder.append(" id=\"");
        stringBuilder.append(this.getId());
        stringBuilder.append("\" class=\"");
        stringBuilder.append(this.getClassName());
        stringBuilder.append("\" version=\"");
        stringBuilder.append(this.getVersion());
        stringBuilder.append('\"');
        Format format2 = this.getLatestVersion();
        if (format2 != null) {
            stringBuilder.append(" currentVersionId=\"");
            stringBuilder.append(format2.getId());
            stringBuilder.append('\"');
        }
        if ((format = this.getPreviousVersion()) != null) {
            stringBuilder.append(" previousVersionId=\"");
            stringBuilder.append(format.getId());
            stringBuilder.append('\"');
        }
    }
}

