/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.ComparatorCatalog;
import com.sleepycat.persist.impl.CompositeKeyFormat;
import com.sleepycat.persist.impl.EnumFormat;
import com.sleepycat.persist.impl.FieldInfo;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistKeyBinding;
import com.sleepycat.persist.impl.RefreshException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistComparator
implements Comparator<byte[]>,
Serializable {
    private static final long serialVersionUID = 5221576538843355317L;
    private String keyClassName;
    private String[] comositeFieldOrder;
    private Map<String, String[]> fieldFormatData;
    private transient PersistKeyBinding binding;

    public PersistComparator(PersistKeyBinding persistKeyBinding) {
        this.binding = persistKeyBinding;
        CompositeKeyFormat compositeKeyFormat = (CompositeKeyFormat)persistKeyBinding.keyFormat;
        this.keyClassName = compositeKeyFormat.getClassName();
        this.comositeFieldOrder = CompositeKeyFormat.getFieldNameArray(compositeKeyFormat.getClassMetadata().getCompositeKeyFields());
        for (FieldInfo fieldInfo : compositeKeyFormat.getFieldInfo()) {
            Format format = fieldInfo.getType();
            if (!format.isEnum()) continue;
            EnumFormat enumFormat = (EnumFormat)format;
            if (this.fieldFormatData == null) {
                this.fieldFormatData = new HashMap<String, String[]>();
            }
            this.fieldFormatData.put(enumFormat.getClassName(), enumFormat.getFormatData());
        }
    }

    public void initialize(ClassLoader classLoader) {
        Serializable serializable;
        ComparatorCatalog comparatorCatalog;
        if (this.fieldFormatData == null) {
            comparatorCatalog = new ComparatorCatalog(classLoader, null);
        } else {
            serializable = new HashMap<String, Format>();
            comparatorCatalog = new ComparatorCatalog(classLoader, (Map<String, Format>)((Object)serializable));
            for (Map.Entry<String, String[]> object : this.fieldFormatData.entrySet()) {
                Class clazz;
                String string = object.getKey();
                String[] stringArray = object.getValue();
                try {
                    clazz = comparatorCatalog.resolveClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalStateException(classNotFoundException);
                }
                serializable.put(string, new EnumFormat(comparatorCatalog, clazz, stringArray));
            }
            for (Format format : serializable.values()) {
                format.initializeIfNeeded(comparatorCatalog, null);
            }
        }
        try {
            serializable = comparatorCatalog.resolveClass(this.keyClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
        this.binding = new PersistKeyBinding((Catalog)comparatorCatalog, (Class)serializable, this.comositeFieldOrder);
    }

    @Override
    public int compare(byte[] byArray, byte[] byArray2) {
        if (this.binding == null) {
            throw DbCompat.unexpectedState("Not initialized");
        }
        try {
            Comparable comparable = (Comparable)this.binding.bytesToObject(byArray, 0, byArray.length);
            Comparable comparable2 = (Comparable)this.binding.bytesToObject(byArray2, 0, byArray2.length);
            return comparable.compareTo(comparable2);
        }
        catch (RefreshException refreshException) {
            throw DbCompat.unexpectedException(refreshException);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[DPL comparator ");
        stringBuilder.append(" keyClassName = ").append(this.keyClassName);
        stringBuilder.append(" comositeFieldOrder = [");
        for (String string : this.comositeFieldOrder) {
            stringBuilder.append(string).append(',');
        }
        stringBuilder.append(']');
        stringBuilder.append(" fieldFormatData = {");
        for (Map.Entry entry : this.fieldFormatData.entrySet()) {
            stringBuilder.append((String)entry.getKey()).append(": [");
            for (String string : (String[])entry.getValue()) {
                stringBuilder.append(string).append(',');
            }
            stringBuilder.append(']');
        }
        stringBuilder.append('}');
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

