/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.impl.PersistKeyAssigner;
import com.sleepycat.persist.impl.Reader;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.raw.RawObject;

public class PersistEntityBinding
implements EntityBinding {
    volatile PersistCatalog catalog;
    volatile Format entityFormat;
    final boolean rawAccess;
    PersistKeyAssigner keyAssigner;

    public PersistEntityBinding(PersistCatalog persistCatalog, String string, boolean bl) {
        this.catalog = persistCatalog;
        try {
            this.entityFormat = PersistEntityBinding.getOrCreateFormat(this.catalog, string, bl);
        }
        catch (RefreshException refreshException) {
            this.catalog = refreshException.refresh();
            try {
                this.entityFormat = PersistEntityBinding.getOrCreateFormat(this.catalog, string, bl);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
        if (!this.entityFormat.isEntity()) {
            throw new IllegalArgumentException("Not an entity class: " + string);
        }
        this.rawAccess = bl;
    }

    public PersistKeyAssigner getKeyAssigner() {
        return this.keyAssigner;
    }

    public Object entryToObject(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        try {
            return this.entryToObjectInternal(databaseEntry, null, databaseEntry2);
        }
        catch (RefreshException refreshException) {
            refreshException.refresh();
            try {
                return this.entryToObjectInternal(databaseEntry, null, databaseEntry2);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
    }

    public Object entryToObjectWithPriKey(Object object, DatabaseEntry databaseEntry) {
        try {
            if (object == null) {
                throw new IllegalArgumentException("Primary key cannot be null.");
            }
            return this.entryToObjectInternal(null, object, databaseEntry);
        }
        catch (RefreshException refreshException) {
            refreshException.refresh();
            try {
                return this.entryToObjectInternal(null, object, databaseEntry);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
    }

    private Object entryToObjectInternal(DatabaseEntry databaseEntry, Object object, DatabaseEntry databaseEntry2) throws RefreshException {
        return PersistEntityBinding.readEntity(this.catalog, databaseEntry, object, databaseEntry2, this.rawAccess);
    }

    static Object readEntity(Catalog catalog, DatabaseEntry databaseEntry, Object object, DatabaseEntry databaseEntry2, boolean bl) throws RefreshException {
        RecordInput recordInput = new RecordInput(catalog, bl, null, 0, databaseEntry2.getData(), databaseEntry2.getOffset(), databaseEntry2.getSize());
        int n = recordInput.getBufferOffset();
        int n2 = recordInput.readPackedInt();
        Format format = catalog.getFormat(n2, true);
        recordInput.registerEntityFormat(format);
        Reader reader = format.getReader();
        Object object2 = reader.newInstance(recordInput, bl);
        if (object == null) {
            RecordInput recordInput2 = new RecordInput(catalog, bl, null, 0, databaseEntry.getData(), databaseEntry.getOffset(), databaseEntry.getSize());
            reader.readPriKey(object2, recordInput2, bl);
        } else {
            Accessor accessor = reader.getAccessor(object2 instanceof RawObject ? true : bl);
            if (accessor == null) {
                accessor = format.getLatestVersion().getReader().getAccessor(object2 instanceof RawObject ? true : bl);
            }
            accessor.setPriField(object2, object);
        }
        recordInput.registerEntity(object2, n);
        object2 = reader.readObject(object2, recordInput, bl);
        return object2;
    }

    public void objectToData(Object object, DatabaseEntry databaseEntry) {
        try {
            this.objectToDataInternal(object, databaseEntry);
        }
        catch (RefreshException refreshException) {
            refreshException.refresh();
            try {
                this.objectToDataInternal(object, databaseEntry);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
    }

    private void objectToDataInternal(Object object, DatabaseEntry databaseEntry) throws RefreshException {
        Format format = this.getValidFormat(object);
        this.catalog.checkWriteInReplicaUpgradeMode();
        PersistEntityBinding.writeEntity(format, this.catalog, object, databaseEntry, this.rawAccess);
    }

    static void writeEntity(Format format, Catalog catalog, Object object, DatabaseEntry databaseEntry, boolean bl) throws RefreshException {
        RecordOutput recordOutput = new RecordOutput(catalog, bl);
        recordOutput.registerEntity(object);
        recordOutput.writePackedInt(format.getId());
        format.writeObject(object, recordOutput, bl);
        TupleBase.outputToEntry(recordOutput, databaseEntry);
    }

    public void objectToKey(Object object, DatabaseEntry databaseEntry) {
        try {
            this.objectToKeyInternal(object, databaseEntry);
        }
        catch (RefreshException refreshException) {
            refreshException.refresh();
            try {
                this.objectToKeyInternal(object, databaseEntry);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
    }

    private void objectToKeyInternal(Object object, DatabaseEntry databaseEntry) throws RefreshException {
        Format format = this.getValidFormat(object);
        RecordOutput recordOutput = new RecordOutput(this.catalog, this.rawAccess);
        format.writePriKey(object, recordOutput, this.rawAccess);
        TupleBase.outputToEntry(recordOutput, databaseEntry);
    }

    private Format getValidFormat(Object object) throws RefreshException {
        Format format;
        if (object == null) {
            throw new IllegalArgumentException("An entity may not be null");
        }
        if (this.rawAccess) {
            if (!(object instanceof RawObject)) {
                throw new IllegalArgumentException("Entity must be a RawObject");
            }
            format = (Format)((RawObject)object).getType();
        } else {
            format = this.catalog.getFormat(object.getClass(), true);
        }
        if (format.getEntityFormat() != this.entityFormat) {
            throw new IllegalArgumentException("The entity class (" + format.getClassName() + ") must be this entity class or a subclass of it: " + this.entityFormat.getClassName());
        }
        return format;
    }

    static Format getOrCreateFormat(Catalog catalog, String string, boolean bl) throws RefreshException {
        if (bl) {
            Format format = catalog.getFormat(string);
            if (format == null) {
                throw new IllegalArgumentException("Not a persistent class: " + string);
            }
            return format;
        }
        Class clazz = catalog.resolveKeyClass(string);
        return catalog.getFormat(clazz, true);
    }

    void refresh(PersistCatalog persistCatalog) {
        this.catalog = persistCatalog;
        this.entityFormat = persistCatalog.getFormat(this.entityFormat.getClassName());
        if (this.keyAssigner != null) {
            this.keyAssigner.refresh(persistCatalog);
        }
    }
}

