/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RawAbstractInput;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.raw.RawObject;
import java.util.IdentityHashMap;
import java.util.Map;

class RecordOutput
extends TupleOutput
implements EntityOutput {
    private Catalog catalog;
    private boolean rawAccess;
    private Map<Object, Integer> visited;

    RecordOutput(Catalog catalog, boolean bl) {
        this.catalog = catalog;
        this.rawAccess = bl;
        this.visited = new IdentityHashMap<Object, Integer>();
    }

    public void writeObject(Object object, Format format) throws RefreshException {
        if (object == null) {
            this.writePackedInt(0);
            return;
        }
        Integer n = this.visited.get(object);
        if (n != null) {
            if (n == 0x7FFFFFFD) {
                throw new IllegalArgumentException("Cannot embed a reference to a proxied object in the proxy; for example, a collection may not be an element of the collection because collections are proxied");
            }
            this.writePackedInt(-(n + 1));
            return;
        }
        Format format2 = this.rawAccess ? RawAbstractInput.checkRawType(this.catalog, object, format) : this.catalog.getFormat(object.getClass(), false);
        if (format2.getProxiedFormat() != null) {
            throw new IllegalArgumentException("May not store proxy classes directly: " + format2.getClassName());
        }
        if (format2.getEntityFormat() != null) {
            throw new IllegalArgumentException("References to entities are not allowed: " + object.getClass().getName());
        }
        boolean bl = format2.areNestedRefsProhibited();
        Integer n2 = this.size();
        this.visited.put(object, bl ? 0x7FFFFFFD : n2);
        this.writePackedInt(format2.getId());
        format2.writeObject(object, this, this.rawAccess);
        if (bl) {
            this.visited.put(object, n2);
        }
    }

    public void writeKeyObject(Object object, Format format) throws RefreshException {
        Format format2;
        if (object == null) {
            throw new IllegalArgumentException("Key field object may not be null");
        }
        if (this.rawAccess) {
            if (object instanceof RawObject) {
                format2 = (Format)((RawObject)object).getType();
            } else {
                format2 = this.catalog.getFormat(object.getClass(), false);
                if (format.isPrimitive()) {
                    format = format.getWrapperFormat();
                }
            }
        } else {
            format2 = this.catalog.getFormat(object.getClass(), false);
        }
        if (format != format2) {
            throw new IllegalArgumentException("The key field object class (" + object.getClass().getName() + ") must be the field's declared class: " + format.getClassName());
        }
        format.writeObject(object, this, this.rawAccess);
    }

    public void registerPriKeyObject(Object object) {
        this.visited.put(object, 0x7FFFFFFE);
    }

    public void registerEntity(Object object) {
        assert (this.size() == 0);
        this.visited.put(object, this.size());
    }

    public void writeArrayLength(int n) {
        this.writePackedInt(n);
    }

    public void writeEnumConstant(String[] stringArray, int n) {
        this.writePackedInt(n);
    }
}

