/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.model.data;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseTupleType;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;

public class ClickhouseTupleValue
implements DBDComposite,
DBDValueCloneable {
    private final ClickhouseTupleType type;
    private Object[] values;
    private boolean modified;

    public ClickhouseTupleValue(@NotNull DBRProgressMonitor monitor, @NotNull ClickhouseTupleType type, @Nullable Object[] values) throws DBCException {
        this.type = type;
        if (values != null) {
            this.values = new Object[values.length];
            int i = 0;
            while (i < values.length) {
                Object value = values[i];
                this.values[i] = value instanceof DBDValueCloneable ? ((DBDValueCloneable)value).cloneValue(monitor) : value;
                ++i;
            }
        }
    }

    public DBSDataType getDataType() {
        return this.type;
    }

    @NotNull
    public DBSAttributeBase[] getAttributes() {
        return (DBSAttributeBase[])this.type.getAttributes().toArray(DBSAttributeBase[]::new);
    }

    @Nullable
    public Object getAttributeValue(@NotNull DBSAttributeBase attribute) {
        if (this.values == null) {
            return null;
        }
        return this.values[attribute.getOrdinalPosition()];
    }

    public void setAttributeValue(@NotNull DBSAttributeBase attribute, @Nullable Object value) {
        if (this.values == null) {
            this.values = new Object[this.type.getAttributes().size()];
        }
        this.values[attribute.getOrdinalPosition()] = value;
        this.modified = true;
    }

    public Object getRawValue() {
        return this.values;
    }

    public boolean isNull() {
        return this.values == null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void release() {
        this.values = null;
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) throws DBCException {
        return new ClickhouseTupleValue(monitor, this.type, this.values);
    }
}

