/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.sqlite.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.generic.model.GenericTableTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.sqlite.SQLiteUtils;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteDataSource;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteDataTypeCache;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteObjectType;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteTable;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteTableColumn;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteTableForeignKey;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteView;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyDeferability;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.utils.CommonUtils;

public class SQLiteMetaModel
extends GenericMetaModel
implements DBCQueryTransformProvider {
    private static final Log log = Log.getLog(SQLiteMetaModel.class);
    private static final Pattern TYPE_WITH_LENGTH_PATTERN = Pattern.compile("(.+)\\s*\\(([0-9]+)\\)");

    public String getViewDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericView sourceObject, @NotNull Map<String, Object> options) throws DBException {
        return SQLiteUtils.readMasterDefinition(monitor, (DBSObject)sourceObject, SQLiteObjectType.view, sourceObject.getName(), (GenericTableBase)sourceObject);
    }

    public String getTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTableBase sourceObject, @NotNull Map<String, Object> options) throws DBException {
        String tableDDL = SQLiteUtils.readMasterDefinition(monitor, (DBSObject)sourceObject, SQLiteObjectType.table, sourceObject.getName(), sourceObject);
        String indexesDDL = SQLiteUtils.readMasterDefinition(monitor, (DBSObject)sourceObject, SQLiteObjectType.index, null, sourceObject);
        if (CommonUtils.isEmpty((String)indexesDDL)) {
            return tableDDL;
        }
        return tableDDL + "\n" + indexesDDL;
    }

    public boolean supportsTableDDLSplit(GenericTableBase sourceObject) {
        return false;
    }

    public JDBCStatement prepareTableLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase object, @Nullable String objectName) throws SQLException {
        SQLiteDataSource dataSource;
        JDBCDataSource jDBCDataSource = session.getDataSource();
        if (!(jDBCDataSource instanceof SQLiteDataSource) || !(dataSource = (SQLiteDataSource)jDBCDataSource).supportsStrictTyping()) {
            return super.prepareTableLoadStatement(session, owner, object, objectName);
        }
        Object sql = "SELECT\n    NULL AS TABLE_CAT,\n    NULL AS TABLE_SCHEM,\n    TABLES.NAME AS TABLE_NAME,\n    TABLES.TYPE AS TABLE_TYPE,\n    NULL AS REMARKS,\n    NULL AS TYPE_CAT,\n    NULL AS TYPE_SCHEM,\n    NULL AS TYPE_NAME,\n    NULL AS SELF_REFERENCING_COL_NAME,\n    NULL AS REF_GENERATION,\n    INFOS.STRICT AS STRICT\nFROM\n    (\n    SELECT\n        'sqlite_schema' AS NAME,\n        'SYSTEM TABLE' AS TYPE\n    UNION ALL\n    SELECT\n        NAME,\n        UPPER(TYPE) AS TYPE\n    FROM\n        sqlite_schema\n    WHERE\n        NAME NOT LIKE 'sqlite\\_%' ESCAPE '\\'\n        AND UPPER(TYPE) IN ('TABLE', 'VIEW')\n    UNION ALL\n    SELECT\n        NAME,\n        'GLOBAL TEMPORARY' AS TYPE\n    FROM\n        sqlite_temp_master\n    UNION ALL\n    SELECT\n        NAME,\n        'SYSTEM TABLE' AS TYPE\n    FROM\n        sqlite_schema\n    WHERE\n        NAME LIKE 'sqlite\\_%' ESCAPE '\\'\n    ) AS TABLES\n    LEFT OUTER JOIN pragma_table_list AS INFOS\n        ON INFOS.NAME = TABLES.NAME\n";
        sql = object == null && objectName == null ? (String)sql + "ORDER BY TABLE_TYPE, TABLE_NAME" : (String)sql + "WHERE TABLE_NAME = ?";
        JDBCPreparedStatement dbStat = session.prepareStatement((String)sql);
        if (object != null || objectName != null) {
            dbStat.setString(1, object != null ? object.getName() : objectName);
        }
        return dbStat;
    }

    public String getTriggerDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTrigger trigger) throws DBException {
        return SQLiteUtils.readMasterDefinition(monitor, (DBSObject)trigger, SQLiteObjectType.trigger, trigger.getName(), (GenericTableBase)trigger.getParentObject());
    }

    public boolean supportsTriggers(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public boolean supportsDatabaseTriggers(@NotNull GenericDataSource dataSource) {
        return false;
    }

    public JDBCStatement prepareTableTriggersLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer genericStructContainer, @Nullable GenericTableBase forParent) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT name as TRIGGER_NAME, tbl_name as OWNER FROM " + this.getFullyQualifiedName(genericStructContainer, "sqlite_master") + " WHERE type='trigger'" + (forParent != null ? " AND tbl_name=?" : ""));
        if (forParent != null) {
            dbStat.setString(1, forParent.getName());
        }
        return dbStat;
    }

    public GenericTrigger createTableTriggerImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer genericStructContainer, @NotNull GenericTableBase genericTableBase, String triggerName, @NotNull JDBCResultSet resultSet) throws DBException {
        if (CommonUtils.isEmpty((String)triggerName)) {
            triggerName = JDBCUtils.safeGetString((ResultSet)resultSet, (int)1);
        }
        return new GenericTableTrigger(genericTableBase, triggerName, null);
    }

    /*
     * Loose catch block
     */
    public List<? extends GenericTrigger> loadTriggers(DBRProgressMonitor monitor, @NotNull GenericStructContainer container, @Nullable GenericTableBase table) throws DBException {
        if (table == null) {
            return Collections.emptyList();
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read triggers");){
                ArrayList<GenericTableTrigger> arrayList;
                JDBCPreparedStatement dbStat;
                Throwable throwable2;
                block33: {
                    throwable2 = null;
                    Object var8_12 = null;
                    dbStat = session.prepareStatement("SELECT name FROM " + this.getFullyQualifiedName(container, "sqlite_master") + " WHERE type='trigger' AND tbl_name=?");
                    dbStat.setString(1, table.getName());
                    ArrayList<GenericTableTrigger> result = new ArrayList<GenericTableTrigger>();
                    Throwable throwable3 = null;
                    Object var12_18 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String name = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
                            result.add(new GenericTableTrigger(table, name, null));
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    arrayList = result;
                    if (dbStat == null) break block33;
                    dbStat.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable5) {
                        try {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, (DBPDataSource)container.getDataSource());
        }
    }

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimit(false);
        }
        return null;
    }

    public GenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new SQLiteDataSource(monitor, container, this);
    }

    public SQLiteDataTypeCache createDataTypeCache(@NotNull GenericStructContainer container) {
        return new SQLiteDataTypeCache(container);
    }

    public GenericTableBase createTableOrViewImpl(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        if (tableType != null && this.isView(tableType)) {
            return new SQLiteView(container, tableName, tableType, dbResult);
        }
        return new SQLiteTable(container, tableName, tableType, dbResult);
    }

    public boolean isSystemTable(GenericTableBase table) {
        return table.getName().startsWith("sqlite_");
    }

    public boolean isUtilityTable(@NotNull GenericTableBase table) {
        return table.getName().startsWith("sqlite_autoindex_");
    }

    public boolean supportsSequences(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public JDBCStatement prepareSequencesLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
        try {
            JDBCUtils.queryString((Connection)session, (String)("SELECT 1 FROM " + this.getFullyQualifiedName(container, "sqlite_sequence")), (Object[])new Object[0]);
        }
        catch (SQLException e) {
            throw new SQLException("Error loading SQLite sequences. Probably sqlite_sequence info table doesn't exist yet. Please create table with AUTOINCREMENT column first.", e);
        }
        return session.prepareStatement("SELECT * FROM " + this.getFullyQualifiedName(container, "sqlite_sequence"));
    }

    public GenericSequence createSequenceImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) {
        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
        if (CommonUtils.isEmpty((String)name)) {
            return null;
        }
        long value = JDBCUtils.safeGetLong((ResultSet)dbResult, (int)2);
        return new GenericSequence(container, name, null, (Number)value, (Number)0, (Number)Long.MAX_VALUE, (Number)1);
    }

    public boolean handleSequenceCacheReadingError(Exception error) {
        if (error.getCause() instanceof SQLException) {
            log.debug((Object)"Error loading SQLite sequences.", (Throwable)error);
            return true;
        }
        return false;
    }

    public GenericTableColumn createTableColumnImpl(@NotNull DBRProgressMonitor monitor, JDBCResultSet dbResult, @NotNull GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPos, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) {
        Matcher matcher = TYPE_WITH_LENGTH_PATTERN.matcher(typeName);
        if (matcher.matches()) {
            typeName = matcher.group(1);
            columnSize = charLength = (long)Integer.parseInt(matcher.group(2));
        } else {
            charLength = -1L;
            columnSize = -1L;
        }
        return new SQLiteTableColumn(table, columnName, typeName, valueType, sourceType, ordinalPos, columnSize, charLength, scale, precision, radix, notNull, remarks, defaultValue, autoIncrement, autoGenerated);
    }

    @NotNull
    protected String getFullyQualifiedName(@NotNull GenericStructContainer genericStructContainer, String value) {
        return value;
    }

    @NotNull
    public GenericTableForeignKey createTableForeignKeyImpl(GenericTableBase table, String name, @Nullable String remarks, DBSEntityReferrer referencedKey, DBSForeignKeyModifyRule deleteRule, DBSForeignKeyModifyRule updateRule, DBSForeignKeyDeferability deferability, boolean persisted) {
        return new SQLiteTableForeignKey(table, name, remarks, referencedKey, deleteRule, updateRule, deferability, persisted);
    }

    public String getAutoIncrementClause(GenericTableColumn column) {
        if (column.isAutoIncrement()) {
            return "PRIMARY KEY AUTOINCREMENT";
        }
        return null;
    }

    @NotNull
    protected String getDefaultTypeName() {
        return "ANY";
    }
}

