/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.ui.UIUtils;

public class ImageUtils {
    public static Image captureWidget(Control widget, Color borderColor, Image defaultImage) {
        Point size = widget.computeSize(-1, -1);
        Image image = new Image((Device)widget.getDisplay(), size.x, size.y);
        GC gc = new GC((Drawable)image);
        try {
            widget.print(gc);
        }
        finally {
            UIUtils.dispose((Resource)gc);
        }
        Image result = ImageUtils.removeImageBorder(image, borderColor);
        if (result == null) {
            return defaultImage;
        }
        return result;
    }

    public static Image removeImageBorder(Image srcImage, Color borderColor) {
        int col;
        boolean emptyRow;
        ImageData imageData = srcImage.getImageData();
        if (imageData.height == 0 || imageData.width == 0) {
            return srcImage;
        }
        int borderPixel = imageData.getPixel(0, 0);
        if (!imageData.palette.getRGB(borderPixel).equals((Object)borderColor.getRGB())) {
            return srcImage;
        }
        int emptyTopRows = 0;
        int emptyBottomRows = 0;
        int emptyLeftColumns = 0;
        int emptyRightColumns = 0;
        int row = 0;
        while (row < imageData.height) {
            emptyRow = true;
            col = 0;
            while (col < imageData.width) {
                if (borderPixel != imageData.getPixel(col, row)) {
                    emptyRow = false;
                    break;
                }
                ++col;
            }
            if (!emptyRow) {
                emptyTopRows = row;
                break;
            }
            ++row;
        }
        if (row == imageData.height) {
            return null;
        }
        row = imageData.height - 1;
        while (row >= 0) {
            emptyRow = true;
            col = 0;
            while (col < imageData.width) {
                if (borderPixel != imageData.getPixel(col, row)) {
                    emptyRow = false;
                    break;
                }
                ++col;
            }
            if (!emptyRow) {
                emptyBottomRows = imageData.height - row - 1;
                break;
            }
            --row;
        }
        if (emptyTopRows > 0 || emptyBottomRows > 0 || emptyLeftColumns > 0 || emptyRightColumns > 0) {
            return ImageUtils.cropImage(srcImage, emptyLeftColumns, emptyTopRows, imageData.width - emptyLeftColumns - emptyRightColumns, imageData.height - emptyTopRows - emptyBottomRows);
        }
        return srcImage;
    }

    public static Image cropImage(Image srcImage, int x, int y, int w, int h) {
        Image cropImage = new Image(srcImage.getDevice(), w, h);
        if (x + w > srcImage.getBounds().width) {
            w = srcImage.getBounds().width - x;
        }
        if (y + h > srcImage.getBounds().height) {
            h = srcImage.getBounds().height - y;
        }
        GC cropGC = new GC((Drawable)cropImage);
        cropGC.drawImage(srcImage, x, y, w, h, 0, 0, w, h);
        UIUtils.dispose((Resource)cropGC);
        UIUtils.dispose((Resource)srcImage);
        return cropImage;
    }

    public static ImageData makeWebImageData(Image image) {
        ImageData imageData = image.getImageData();
        if (imageData.depth <= 8) {
            return imageData;
        }
        ImageData newImageData = ImageUtils.get8BitPaletteImageData(imageData);
        if (newImageData == null) {
            newImageData = ImageUtils.getWebSafePaletteImageData(imageData);
        }
        return newImageData;
    }

    private static ImageData get8BitPaletteImageData(ImageData imageData) {
        PaletteData palette = imageData.palette;
        RGB[] colours = new RGB[256];
        PaletteData newPaletteData = new PaletteData(colours);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, newPaletteData);
        int lastPixel = -1;
        int newPixel = -1;
        int i = 0;
        while (i < imageData.width) {
            int j = 0;
            while (j < imageData.height) {
                int pixel = imageData.getPixel(i, j);
                if (pixel != lastPixel) {
                    lastPixel = pixel;
                    RGB colour = palette.getRGB(pixel);
                    newPixel = 0;
                    while (newPixel < 256) {
                        if (colours[newPixel] == null) {
                            colours[newPixel] = colour;
                            break;
                        }
                        if (colours[newPixel].equals((Object)colour)) break;
                        ++newPixel;
                    }
                    if (newPixel >= 256) {
                        return null;
                    }
                }
                newImageData.setPixel(i, j, newPixel);
                ++j;
            }
            ++i;
        }
        RGB colour = new RGB(0, 0, 0);
        int k = 0;
        while (k < 256) {
            if (colours[k] == null) {
                colours[k] = colour;
            }
            ++k;
        }
        return newImageData;
    }

    private static ImageData getWebSafePaletteImageData(ImageData imageData) {
        PaletteData palette = imageData.palette;
        RGB[] webSafePalette = ImageUtils.getWebSafePalette();
        PaletteData newPaletteData = new PaletteData(webSafePalette);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, newPaletteData);
        int lastPixel = -1;
        int newPixel = -1;
        int i = 0;
        while (i < imageData.width) {
            int j = 0;
            while (j < imageData.height) {
                int pixel = imageData.getPixel(i, j);
                if (pixel != lastPixel) {
                    lastPixel = pixel;
                    RGB colour = palette.getRGB(pixel);
                    RGB webSafeColour = ImageUtils.getWebSafeColour(colour);
                    newPixel = 0;
                    while (newPixel < 256) {
                        if (webSafePalette[newPixel].equals((Object)webSafeColour)) break;
                        ++newPixel;
                    }
                    Assert.isTrue((newPixel < 216 ? 1 : 0) != 0);
                }
                newImageData.setPixel(i, j, newPixel);
                ++j;
            }
            ++i;
        }
        return newImageData;
    }

    private static RGB getWebSafeColour(RGB colour) {
        int red = Math.round((colour.red + 25) / 51) * 51;
        int green = Math.round((colour.green + 25) / 51) * 51;
        int blue = Math.round((colour.blue + 25) / 51) * 51;
        return new RGB(red, green, blue);
    }

    private static RGB[] getWebSafePalette() {
        RGB[] colours = new RGB[256];
        int i = 0;
        int red = 0;
        while (red <= 255) {
            int green = 0;
            while (green <= 255) {
                int blue = 0;
                while (blue <= 255) {
                    RGB colour = new RGB(red, green, blue);
                    colours[i++] = colour;
                    blue += 51;
                }
                green += 51;
            }
            red += 51;
        }
        RGB colour = new RGB(0, 0, 0);
        int k = 0;
        while (k < 256) {
            if (colours[k] == null) {
                colours[k] = colour;
            }
            ++k;
        }
        return colours;
    }

    public static ImageData getImageDataAtCurrentZoom(Image image) {
        try {
            return image.getImageData(DPIUtil.getDeviceZoom());
        }
        catch (Exception exception) {
            return image.getImageData();
        }
    }
}

