/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.resource.undostates;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.resource.undostates.AbstractResourceUndoState;
import org.eclipse.ltk.internal.core.refactoring.resource.undostates.IFileContentDescription;

public class FileUndoState
extends AbstractResourceUndoState {
    protected String name;
    private URI location;
    private String charset;
    private IFileContentDescription fileContentDescription;

    public FileUndoState(IFile file) {
        super((IResource)file);
        this.name = file.getName();
        try {
            this.charset = file.getCharset(false);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (file.isLinked()) {
            this.location = file.getLocationURI();
        }
    }

    public FileUndoState(IFile file, URI linkLocation, IFileContentDescription fileContentDescription) {
        super((IResource)file);
        this.name = file.getName();
        this.location = linkLocation;
        this.charset = null;
        this.fileContentDescription = fileContentDescription;
    }

    @Override
    public void recordStateFromHistory(IResource resource, IProgressMonitor monitor) throws CoreException {
        Assert.isLegal((resource.getType() == 1 ? 1 : 0) != 0);
        if (this.location != null) {
            return;
        }
        IFileState[] states = ((IFile)resource).getHistory(monitor);
        if (states.length > 0) {
            final IFileState state = this.getMatchingFileState(states);
            this.fileContentDescription = new IFileContentDescription(){

                @Override
                public boolean exists() {
                    return state.exists();
                }

                @Override
                public InputStream getContents() throws CoreException {
                    return state.getContents();
                }

                @Override
                public String getCharset() throws CoreException {
                    return state.getCharset();
                }
            };
        }
    }

    @Override
    public IResource createResourceHandle() {
        IWorkspaceRoot workspaceRoot = this.parent.getWorkspace().getRoot();
        IPath fullPath = this.parent.getFullPath().append(this.name);
        return workspaceRoot.getFile(fullPath);
    }

    @Override
    public void createExistentResourceFromHandle(IResource resource, IProgressMonitor monitor) throws CoreException {
        Assert.isLegal((boolean)(resource instanceof IFile));
        if (resource.exists()) {
            return;
        }
        IFile fileHandle = (IFile)resource;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.FileDescription_NewFileProgress, (int)200);
        try {
            try {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (this.location != null) {
                    fileHandle.createLink(this.location, 16, (IProgressMonitor)subMonitor.newChild(200));
                } else {
                    InputStream contents = this.fileContentDescription != null && this.fileContentDescription.exists() ? this.fileContentDescription.getContents() : new ByteArrayInputStream(RefactoringCoreMessages.FileDescription_ContentsCouldNotBeRestored.getBytes());
                    fileHandle.create(contents, false, (IProgressMonitor)subMonitor.newChild(100));
                    fileHandle.setCharset(this.charset, (IProgressMonitor)subMonitor.newChild(100));
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() != 374) {
                    throw e;
                }
                fileHandle.refreshLocal(0, null);
                subMonitor.done();
            }
        }
        finally {
            subMonitor.done();
        }
    }

    @Override
    public boolean isValid() {
        if (this.location != null) {
            return super.isValid();
        }
        return super.isValid() && this.fileContentDescription != null && this.fileContentDescription.exists();
    }

    @Override
    public String getName() {
        return this.name;
    }

    private IFileState getMatchingFileState(IFileState[] states) {
        IFileState[] iFileStateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            IFileState state = iFileStateArray[n2];
            if (this.localTimeStamp == state.getModificationTime()) {
                return state;
            }
            ++n2;
        }
        return states[0];
    }

    @Override
    protected void restoreResourceAttributes(IResource resource) throws CoreException {
        super.restoreResourceAttributes(resource);
        Assert.isLegal((boolean)(resource instanceof IFile));
        IFile file = (IFile)resource;
        if (this.charset != null) {
            file.setCharset(this.charset, null);
        }
    }
}

