/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.registry.driver.DriverFileInfo;
import org.jkiss.dbeaver.registry.driver.DriverLoaderDescriptor;
import org.jkiss.utils.CommonUtils;

public class DriverClassLoader
extends URLClassLoader {
    private final DriverLoaderDescriptor driverLoader;

    public DriverClassLoader(DriverLoaderDescriptor driverLoader, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.driverLoader = driverLoader;
    }

    @Override
    protected String findLibrary(String libname) {
        String nativeName = System.mapLibraryName(libname);
        for (DBPDriverLibrary dBPDriverLibrary : this.driverLoader.getDriver().getDriverLibraries()) {
            List<DriverFileInfo> cachedFiles;
            if (dBPDriverLibrary.getType() != DBPDriverLibrary.FileType.lib || !dBPDriverLibrary.matchesCurrentPlatform()) continue;
            Path localFile = dBPDriverLibrary.getLocalFile();
            if (localFile == null && !CommonUtils.isEmpty(cachedFiles = this.driverLoader.getCachedFiles(dBPDriverLibrary))) {
                for (DriverFileInfo fileInfo : cachedFiles) {
                    if (fileInfo.getFile() == null || !fileInfo.getFile().getFileName().toString().equalsIgnoreCase(nativeName)) continue;
                    return fileInfo.getFile().toAbsolutePath().toString();
                }
            }
            if (localFile == null || !Files.exists(localFile, new LinkOption[0])) continue;
            if (Files.isDirectory(localFile, new LinkOption[0])) {
                localFile = localFile.resolve(nativeName);
            }
            if (!localFile.getFileName().toString().equalsIgnoreCase(nativeName)) continue;
            return localFile.toAbsolutePath().toString();
        }
        return super.findLibrary(libname);
    }
}

