/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.statement.create.table.ColDataType;

public class TranscodingFunction
extends ASTNodeAccessImpl
implements Expression {
    private boolean isTranscodeStyle = true;
    private ColDataType colDataType;
    private Expression expression;
    private String transcodingName;

    public TranscodingFunction(Expression expression, String transcodingName) {
        this.expression = expression;
        this.transcodingName = transcodingName;
    }

    public TranscodingFunction(ColDataType colDataType, Expression expression, String transcodingName) {
        this.colDataType = colDataType;
        this.expression = expression;
        this.transcodingName = transcodingName;
        this.isTranscodeStyle = false;
    }

    public TranscodingFunction() {
        this(null, null);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public TranscodingFunction withExpression(Expression expression) {
        this.setExpression(expression);
        return this;
    }

    public String getTranscodingName() {
        return this.transcodingName;
    }

    public void setTranscodingName(String transcodingName) {
        this.transcodingName = transcodingName;
    }

    public TranscodingFunction withTranscodingName(String transcodingName) {
        this.setTranscodingName(transcodingName);
        return this;
    }

    public ColDataType getColDataType() {
        return this.colDataType;
    }

    public TranscodingFunction setColDataType(ColDataType colDataType) {
        this.colDataType = colDataType;
        return this;
    }

    public boolean isTranscodeStyle() {
        return this.isTranscodeStyle;
    }

    public TranscodingFunction setTranscodeStyle(boolean transcodeStyle) {
        this.isTranscodeStyle = transcodeStyle;
        return this;
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }

    @Override
    public StringBuilder appendTo(StringBuilder builder) {
        if (this.isTranscodeStyle) {
            return builder.append("CONVERT( ").append(this.expression).append(" USING ").append(this.transcodingName).append(" )");
        }
        return builder.append("CONVERT( ").append(this.colDataType).append(", ").append(this.expression).append((String)(this.transcodingName != null && !this.transcodingName.isEmpty() ? ", " + this.transcodingName : "")).append(" )");
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }
}

