/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.statement.DeclareStatement;
import net.sf.jsqlparser.statement.DeclareType;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class DeclareStatementDeParser
extends AbstractDeParser<DeclareStatement> {
    private ExpressionVisitor<StringBuilder> expressionVisitor;

    public DeclareStatementDeParser(ExpressionVisitor<StringBuilder> expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(DeclareStatement declare) {
        this.buffer.append("DECLARE ");
        if (declare.getUserVariable() != null) {
            declare.getUserVariable().accept(this.expressionVisitor, null);
        }
        if (declare.getType() == DeclareType.AS) {
            this.buffer.append(" AS ");
            this.buffer.append(declare.getTypeName());
            return;
        }
        if (declare.getType() == DeclareType.TABLE) {
            this.buffer.append(" TABLE (");
            for (int i = 0; i < declare.getColumnDefinitions().size(); ++i) {
                if (i > 0) {
                    this.buffer.append(", ");
                }
                this.buffer.append(declare.getColumnDefinitions().get(i).toString());
            }
            this.buffer.append(")");
        } else if (declare.getTypeDefinitions() != null) {
            for (int i = 0; i < declare.getTypeDefinitions().size(); ++i) {
                if (i > 0) {
                    this.buffer.append(", ");
                }
                DeclareStatement.TypeDefExpr type = declare.getTypeDefinitions().get(i);
                if (type.userVariable != null) {
                    type.userVariable.accept(this.expressionVisitor, null);
                    this.buffer.append(" ");
                }
                this.buffer.append(type.colDataType.toString());
                if (type.defaultExpr == null) continue;
                this.buffer.append(" = ");
                type.defaultExpr.accept(this.expressionVisitor, null);
            }
        }
    }

    public ExpressionVisitor<StringBuilder> getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor<StringBuilder> visitor) {
        this.expressionVisitor = visitor;
    }
}

