/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.runtime.DBRFinder;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialectRelational;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKeyColumn;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public final class SQLUtils {
    private static final Log log = Log.getLog(SQLUtils.class);
    public static final Pattern PATTERN_OUT_PARAM = Pattern.compile("((\\?)|(:[a-z0-9]+))\\s*:=");
    public static final Pattern PATTERN_SIMPLE_NAME = Pattern.compile("[a-z][a-z0-9_]*", 2);
    private static final Pattern CREATE_PREFIX_PATTERN = Pattern.compile("(CREATE (:OR REPLACE)?).+", 10);
    private static final int MAX_SQL_DESCRIPTION_LENGTH = 500;
    private static final String DBEAVER_DDL_COMMENT = "-- DDL generated by ";
    private static final String DBEAVER_DDL_WARNING = "-- WARNING: It may differ from actual native database DDL";
    private static final String DBEAVER_SCRIPT_DELIMITER = "$$";

    public static String stripTransformations(String query) {
        return query;
    }

    public static boolean isCommentLine(SQLDialect dialect, String line) {
        String[] stringArray = dialect.getSingleLineComments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String slc = stringArray[n2];
            if (line.startsWith(slc)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String stripComments(@NotNull SQLDialect dialect, @NotNull String query) {
        Pair<String, String> multiLineComments = dialect.getMultiLineComments();
        return SQLUtils.stripComments(query, multiLineComments == null ? null : (String)multiLineComments.getFirst(), multiLineComments == null ? null : (String)multiLineComments.getSecond(), dialect.getSingleLineComments());
    }

    public static String stripComments(@NotNull String query, @Nullable String mlCommentStart, @Nullable String mlCommentEnd, String[] slComments) {
        int startPos = 0;
        while (startPos < query.length()) {
            if (!Character.isWhitespace(query.charAt(startPos))) break;
            ++startPos;
        }
        int endPos = query.length() - 1;
        while (endPos > startPos) {
            if (!Character.isWhitespace(query.charAt(endPos))) break;
            --endPos;
        }
        String leading = "";
        String trailing = "";
        if (startPos > 0) {
            leading = query.substring(0, startPos);
        }
        if (endPos < query.length() - 1) {
            trailing = query.substring(endPos + 1);
        }
        query = query.trim();
        query = SQLUtils.removeMlComments(query, mlCommentStart, mlCommentEnd);
        query = SQLUtils.removeSlComments(query, slComments);
        if (mlCommentStart != null && query.startsWith(mlCommentStart)) {
            query = SQLUtils.stripComments(query, mlCommentStart, mlCommentEnd, slComments);
        }
        return leading + query + trailing;
    }

    private static String removeMlComments(@NotNull String query, @Nullable String mlCommentStart, @Nullable String mlCommentEnd) {
        if (mlCommentStart != null && mlCommentEnd != null) {
            int startPos = ((String)query).indexOf(mlCommentStart);
            while (startPos != -1) {
                int endPos = ((String)query).indexOf(mlCommentEnd, startPos + mlCommentStart.length());
                if (endPos == -1) {
                    query = ((String)query).substring(0, startPos);
                    break;
                }
                query = ((String)query).substring(0, startPos) + ((String)query).substring(endPos + mlCommentEnd.length());
                startPos = ((String)query).indexOf(mlCommentStart);
            }
        }
        return query;
    }

    private static String removeSlComments(@NotNull String query, String[] slComments) {
        String[] stringArray = slComments;
        int n = slComments.length;
        int n2 = 0;
        while (n2 < n) {
            String slComment = stringArray[n2];
            while (query.startsWith(slComment)) {
                int crPos = query.indexOf(10);
                if (crPos == -1) {
                    query = "";
                    break;
                }
                query = query.substring(crPos).trim();
            }
            ++n2;
        }
        return query;
    }

    public static List<String> splitFilter(String filter) {
        if (CommonUtils.isEmpty((String)filter)) {
            return Collections.emptyList();
        }
        return CommonUtils.splitString((String)filter, (char)',');
    }

    public static boolean matchesAnyLike(String string, Collection<String> likes) {
        for (String like : likes) {
            if (!SQLUtils.matchesLike(string, like)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLikePattern(String like) {
        return like.indexOf(37) != -1 || like.indexOf(42) != -1 || like.indexOf(95) != -1 || like.indexOf(63) != -1;
    }

    @NotNull
    public static String makeLikePattern(@NotNull String like) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < like.length()) {
            char c = like.charAt(i);
            if (c == '*') {
                result.append(".*");
            } else if (c == '?' || c == '_') {
                result.append(".");
            } else if (c == '%') {
                result.append(".*");
            } else if (Character.isLetterOrDigit(c)) {
                result.append(c);
            } else if (c == '(' || c == ')' || c == '[' || c == ']') {
                result.append('\\').append(c);
            } else if (c == '\\') {
                if (i < like.length() - 1) {
                    char nc = like.charAt(i + 1);
                    if (nc == '_' || nc == '*' || nc == '?' || nc == '.' || nc == '%') {
                        result.append("\\").append(nc);
                        ++i;
                    } else {
                        result.append("\\");
                    }
                }
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    @NotNull
    public static String makeRegexFromLike(@NotNull String clause) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        int length = clause.length();
        while (index < length) {
            char ch = clause.charAt(index);
            if (ch == '%') {
                if (index > 0 && index < length - 1) {
                    sb.append(".*");
                }
            } else {
                if (index == 0) {
                    sb.append('^');
                }
                sb.append(ch == '_' ? (char)'.' : (char)ch);
                if (index == length - 1) {
                    sb.append('$');
                }
            }
            ++index;
        }
        return sb.toString();
    }

    public static String makeSQLLike(String like) {
        return like.replace("*", "%").replace("?", "_");
    }

    public static String makeGlobFromSqlLikePattern(@NotNull String sqlLikePattern) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < sqlLikePattern.length()) {
            char charAtI = sqlLikePattern.charAt(i);
            switch (charAtI) {
                case '_': {
                    result.append('?');
                    break;
                }
                case '%': {
                    result.append('*');
                    break;
                }
                case '?': {
                    result.append("\\?");
                    break;
                }
                default: {
                    result.append(charAtI);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static boolean matchesLike(String string, String like) {
        Pattern pattern = Pattern.compile(SQLUtils.makeLikePattern(like), 10);
        return pattern.matcher(string).matches();
    }

    public static void appendValue(StringBuilder buffer, DBSTypedObject type, Object value) {
        if (type.getDataKind() == DBPDataKind.NUMERIC || type.getDataKind() == DBPDataKind.BOOLEAN) {
            buffer.append(value);
        } else {
            buffer.append('\'').append(value).append('\'');
        }
    }

    public static boolean isStringQuoted(DBSObject object, String string) {
        return object.getDataSource().getSQLDialect().isQuotedString(string);
    }

    public static String quoteString(DBSObject object, String string) {
        return SQLUtils.quoteString(object.getDataSource(), string);
    }

    public static String quoteString(DBPDataSource dataSource, String string) {
        return dataSource.getSQLDialect().getQuotedString(string);
    }

    public static String escapeString(DBPDataSource dataSource, String string) {
        return dataSource.getSQLDialect().escapeString(string);
    }

    public static String unQuoteString(DBPDataSource dataSource, String string) {
        if (string.length() > 1 && string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            return dataSource.getSQLDialect().unEscapeString(string.substring(1, string.length() - 1));
        }
        return string;
    }

    public static String getFirstKeyword(SQLDialect dialect, String query) {
        query = SQLUtils.stripComments(dialect, query);
        int startPos = 0;
        int endPos = -1;
        int i = 0;
        while (i < query.length()) {
            if (Character.isLetterOrDigit(query.charAt(i))) {
                startPos = i;
                break;
            }
            ++i;
        }
        i = startPos;
        while (i < query.length()) {
            if (Character.isWhitespace(query.charAt(i))) {
                endPos = i;
                break;
            }
            ++i;
        }
        if (endPos == -1) {
            return query;
        }
        return query.substring(startPos, endPos);
    }

    @Nullable
    public static String getQueryOutputParameter(DBCSession session, String query) {
        Matcher matcher = PATTERN_OUT_PARAM.matcher(query);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String makeUnifiedLineFeeds(DBPDataSource dataSource, String query) {
        SQLDialect dialect = SQLUtils.getDialectFromDataSource(dataSource);
        if (!dialect.isCRLFBroken()) {
            return query;
        }
        if (query.indexOf(13) == -1) {
            return query;
        }
        StringBuilder result = new StringBuilder(query.length());
        int i = 0;
        while (i < query.length()) {
            char c = query.charAt(i);
            if (c != '\r') {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static void appendLikeCondition(@NotNull StringBuilder sql, @NotNull String value, boolean not, @Nullable SQLDialect dialect) {
        if ((value = SQLUtils.makeSQLLike(value)).contains("%") || value.contains("_")) {
            if (not) {
                sql.append(" NOT");
            }
            sql.append(" LIKE ?");
            if (dialect instanceof SQLDialectRelational && ((SQLDialectRelational)dialect).getLikeEscapeClause("\\") != null) {
                sql.append(((SQLDialectRelational)dialect).getLikeEscapeClause("\\"));
            }
        } else {
            sql.append(not ? "<>?" : "=?");
        }
    }

    public static boolean appendFirstClause(StringBuilder sql, boolean firstClause) {
        if (firstClause) {
            sql.append(" WHERE ");
        } else {
            sql.append(" AND ");
        }
        return false;
    }

    public static String trimQueryStatement(SQLSyntaxManager syntaxManager, String sql, boolean trimDelimiter) {
        if (sql.isEmpty() || !trimDelimiter) {
            return sql;
        }
        String trailingSpaces = "";
        int trailingSpacesCount = 0;
        int i = sql.length() - 1;
        while (i >= 0) {
            if (!Character.isWhitespace(sql.charAt(i))) break;
            ++trailingSpacesCount;
            --i;
        }
        if (trailingSpacesCount > 0) {
            trailingSpaces = sql.substring(sql.length() - trailingSpacesCount);
            sql = sql.substring(0, sql.length() - trailingSpacesCount);
        }
        String[] stringArray = syntaxManager.getStatementDelimiters();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String statementDelimiter = stringArray[n2];
            if (sql.endsWith(statementDelimiter) || sql.length() <= statementDelimiter.length()) {
                char lastChar;
                if (Character.isAlphabetic(statementDelimiter.charAt(0)) && Character.isUnicodeIdentifierPart(lastChar = sql.charAt(sql.length() - statementDelimiter.length() - 1))) break;
                boolean isBlockQuery = false;
                String trimmed = sql.substring(0, sql.length() - statementDelimiter.length());
                String test = trimmed.toUpperCase().trim();
                String[][] blockBoundStrings = syntaxManager.getDialect().getBlockBoundStrings();
                if (blockBoundStrings != null) {
                    String[][] stringArray2 = blockBoundStrings;
                    int n3 = blockBoundStrings.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String[] blocks = stringArray2[n4];
                        int endIndex = test.lastIndexOf(blocks[1]);
                        if (endIndex > 0) {
                            if (test.endsWith(blocks[1])) {
                                isBlockQuery = true;
                                break;
                            }
                            String afterEnd = test.substring(endIndex + blocks[1].length()).trim();
                            if (afterEnd.chars().noneMatch(Character::isWhitespace)) {
                                isBlockQuery = true;
                                break;
                            }
                        }
                        ++n4;
                    }
                }
                if (isBlockQuery) break;
                sql = trimmed;
                break;
            }
            ++n2;
        }
        return sql + trailingSpaces;
    }

    public static boolean isBlockStartKeyword(SQLDialect dialect, String keyword) {
        String[][] blockBoundStrings = dialect.getBlockBoundStrings();
        if (blockBoundStrings != null) {
            String[][] stringArray = blockBoundStrings;
            int n = blockBoundStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String[] block = stringArray[n2];
                if (block.length > 0 && keyword.equalsIgnoreCase(block[0])) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isBlockEndKeyword(SQLDialect dialect, String keyword) {
        String[][] blockBoundStrings = dialect.getBlockBoundStrings();
        if (blockBoundStrings != null) {
            String[][] stringArray = blockBoundStrings;
            int n = blockBoundStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String[] block = stringArray[n2];
                if (block.length > 1 && keyword.equalsIgnoreCase(block[1])) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @NotNull
    public static SQLDialect getDialectFromObject(DBPObject object) {
        if (object instanceof DBSObject) {
            DBPDataSource dataSource = ((DBSObject)object).getDataSource();
            return SQLUtils.getDialectFromDataSource(dataSource);
        }
        return BasicSQLDialect.INSTANCE;
    }

    @NotNull
    public static SQLDialect getDialectFromDataSource(@Nullable DBPDataSource dataSource) {
        return dataSource == null ? BasicSQLDialect.INSTANCE : dataSource.getSQLDialect();
    }

    public static void appendConditionString(@NotNull DBDDataFilter filter, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, @NotNull StringBuilder query, boolean inlineCriteria) throws DBException {
        SQLUtils.appendConditionString(filter, dataSource, conditionTable, query, inlineCriteria, false);
    }

    public static void appendConditionString(@NotNull DBDDataFilter filter, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, @NotNull StringBuilder query, boolean inlineCriteria, boolean subQuery) throws DBException {
        dataSource.getSQLDialect().getQueryGenerator().appendConditionString(filter, dataSource, conditionTable, query, inlineCriteria, subQuery);
    }

    public static void appendConditionString(@NotNull DBDDataFilter filter, @NotNull List<DBDAttributeConstraint> constraints, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, @NotNull StringBuilder query, boolean inlineCriteria, boolean subQuery) throws DBException {
        dataSource.getSQLDialect().getQueryGenerator().appendConditionString(filter, constraints, dataSource, conditionTable, query, inlineCriteria, subQuery);
    }

    public static void appendOrderString(@NotNull DBDDataFilter filter, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, boolean subQuery, @NotNull StringBuilder query) {
        dataSource.getSQLDialect().getQueryGenerator().appendOrderString(filter, dataSource, conditionTable, subQuery, query);
    }

    @Nullable
    public static String getConstraintCondition(@NotNull DBPDataSource dataSource, @NotNull DBDAttributeConstraint constraint, @Nullable String conditionTable, boolean inlineCriteria) {
        return dataSource.getSQLDialect().getQueryGenerator().getConstraintCondition(dataSource, constraint, conditionTable, inlineCriteria);
    }

    private static String getStringValue(@NotNull DBPDataSource dataSource, @NotNull DBDAttributeConstraint constraint, boolean inlineCriteria, Object value) {
        String strValue = constraint.getAttribute() == null ? (value instanceof CharSequence ? dataSource.getSQLDialect().getQuotedString(value.toString()) : CommonUtils.toString((Object)value)) : (inlineCriteria ? SQLUtils.convertValueToSQL(dataSource, constraint.getAttribute(), value) : dataSource.getSQLDialect().getTypeCastClause(constraint.getAttribute(), "?", true));
        return strValue;
    }

    public static int getConstraintOrderIndex(@NotNull DBDDataFilter dataFilter, @NotNull DBDAttributeConstraint constraint) {
        int index = dataFilter.getConstraints().indexOf(constraint);
        return index == -1 ? index : index + 1;
    }

    public static String convertValueToSQL(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject attribute, @Nullable Object value) {
        DBDValueHandler valueHandler = DBUtils.findValueHandler(dataSource, attribute);
        return SQLUtils.convertValueToSQL(dataSource, attribute, valueHandler, value, DBDDisplayFormat.NATIVE, false);
    }

    public static String convertValueToSQL(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject attribute, @NotNull DBDValueHandler valueHandler, @Nullable Object value, DBDDisplayFormat displayFormat, boolean isInCondition) {
        if (DBUtils.isNullValue(value)) {
            return "NULL";
        }
        return dataSource.getSQLDialect().getTypeCastClause(attribute, SQLUtils.convertValueToSQLFormat(dataSource, attribute, valueHandler, value, displayFormat), isInCondition);
    }

    private static String convertValueToSQLFormat(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject attribute, @NotNull DBDValueHandler valueHandler, @Nullable Object value, DBDDisplayFormat displayFormat) {
        if (DBUtils.isNullValue(value)) {
            return "NULL";
        }
        String strValue = value instanceof DBDContent ? SQLUtils.convertStreamToSQL(attribute, (DBDContent)value, valueHandler, dataSource) : valueHandler.getValueDisplayString(attribute, value, displayFormat);
        SQLDialect sqlDialect = dataSource.getSQLDialect();
        DBPDataKind dataKind = attribute.getDataKind();
        switch (dataKind) {
            case CONTENT: {
                String contentType;
                if (value instanceof DBDContent && (contentType = ((DBDContent)value).getContentType()) != null && !contentType.startsWith("text")) {
                    return strValue;
                }
            }
            case STRING: 
            case ROWID: {
                if (sqlDialect != null) {
                    return sqlDialect.getQuotedString(strValue);
                }
                return strValue;
            }
        }
        if (sqlDialect != null) {
            return sqlDialect.escapeScriptValue(attribute, value, strValue);
        }
        return strValue;
    }

    public static String convertStreamToSQL(DBSTypedObject attribute, DBDContent content, DBDValueHandler valueHandler, DBPDataSource dataSource) {
        byte[] binValue;
        block4: {
            try {
                VoidProgressMonitor monitor = new VoidProgressMonitor();
                if (!content.isNull() && ContentUtils.isTextContent(content)) {
                    return ContentUtils.getContentStringValue(monitor, content);
                }
                binValue = ContentUtils.getContentBinaryValue(monitor, content);
                if (binValue != null) break block4;
                return "NULL";
            }
            catch (Throwable e) {
                log.warn(e);
                return "NULL";
            }
        }
        return dataSource.getSQLDialect().getNativeBinaryFormatter().toString(binValue, 0, binValue.length);
    }

    public static String getColumnTypeModifiers(@Nullable DBPDataSource dataSource, DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        if (column == null) {
            return null;
        }
        if (dataSource == null) {
            return null;
        }
        return dataSource.getSQLDialect().getColumnTypeModifiers(dataSource, column, typeName, dataKind);
    }

    public static String getScriptDescripion(@NotNull String sql) {
        Matcher matcher = CREATE_PREFIX_PATTERN.matcher((CharSequence)(sql = SQLUtils.stripComments(BasicSQLDialect.INSTANCE, (String)sql)));
        if (matcher.find() && matcher.start(0) == 0) {
            sql = ((String)sql).substring(matcher.end(1));
        }
        if (((String)(sql = ((String)sql).replaceAll(" +", " "))).length() > 500) {
            sql = ((String)sql).substring(0, 500) + " ...";
        }
        return sql;
    }

    public static String generateEntityAlias(DBSEntity entity, DBRFinder<Boolean, String> aliasFinder) {
        String name = entity.getName();
        if (CommonUtils.isEmpty((String)name)) {
            return name;
        }
        StringBuilder buf = new StringBuilder();
        boolean prevNonLetter = true;
        char prevChar = '\u0000';
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!Character.isLetter(c)) {
                prevNonLetter = true;
            } else {
                if (prevNonLetter || prevChar != '\u0000' && Character.isLowerCase(prevChar) && Character.isUpperCase(c)) {
                    buf.append(c);
                }
                prevNonLetter = false;
            }
            prevChar = c;
            ++i;
        }
        String alias = !CommonUtils.isEmpty((CharSequence)buf) ? buf.toString().toLowerCase(Locale.ENGLISH) : "t";
        Object result = alias;
        int i2 = 2;
        while (i2 < 500) {
            if (!aliasFinder.findObject((String)result).booleanValue()) {
                return result;
            }
            result = alias + i2;
            ++i2;
        }
        return alias;
    }

    @NotNull
    public static String generateCommentLine(@Nullable DBPDataSource dataSource, @NotNull String comment) {
        Object[] slComments;
        String separator = GeneralUtils.getDefaultLineSeparator();
        Object slComment = "--";
        if (dataSource != null && !ArrayUtils.isEmpty((Object[])(slComments = dataSource.getSQLDialect().getSingleLineComments()))) {
            slComment = slComments[0];
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = comment.split("\n|\r|\r\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            sb.append((String)slComment).append(" ").append(line).append(separator);
            ++n2;
        }
        return sb.toString();
    }

    public static String generateParamList(int paramCount) {
        if (paramCount == 0) {
            return "";
        }
        if (paramCount == 1) {
            return "?";
        }
        StringBuilder sql = new StringBuilder("?");
        int i = 0;
        while (i < paramCount - 1) {
            sql.append(",?");
            ++i;
        }
        return sql.toString();
    }

    public static String fixLineFeeds(String sql) {
        if (sql.indexOf(13) == -1) {
            return sql;
        }
        boolean hasFixes = false;
        char[] initial = sql.toCharArray();
        StringBuilder fixed = new StringBuilder(initial.length);
        int i = 0;
        while (i < initial.length) {
            fixed.append(initial[i]);
            if (initial[i] == '\r' && (i <= 0 || initial[i - 1] != '\n') && i != initial.length - 1 && initial[i + 1] != '\n') {
                fixed.append('\n');
                hasFixes = true;
            }
            ++i;
        }
        return hasFixes ? fixed.toString() : sql;
    }

    public static boolean compareAliases(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return SQLUtils.removeExtraSpaces(str1).equals(SQLUtils.removeExtraSpaces(str2));
    }

    public static String removeExtraSpaces(@NotNull String str) {
        if (str.indexOf(32) == -1) {
            return str;
        }
        StringBuilder result = new StringBuilder(str.length());
        int length = str.length();
        int i = 0;
        while (i < length) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) {
                boolean needsSpace = i > 0 && Character.isLetterOrDigit(str.charAt(i - 1));
                ++i;
                while (i < length) {
                    c = str.charAt(i);
                    if (!Character.isWhitespace(c)) {
                        if (needsSpace && Character.isLetterOrDigit(c)) {
                            result.append(' ');
                        }
                        result.append(c);
                        break;
                    }
                    ++i;
                }
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    @NotNull
    public static String generateScript(DBPDataSource dataSource, DBEPersistAction[] persistActions, boolean addComments) {
        SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource(dataSource);
        String lineSeparator = GeneralUtils.getDefaultLineSeparator();
        StringBuilder script = new StringBuilder(64);
        if (addComments) {
            script.append(DBEAVER_DDL_COMMENT).append(Platform.getProduct().getName()).append(lineSeparator).append(DBEAVER_DDL_WARNING).append(lineSeparator);
        }
        if (persistActions != null) {
            DBEPersistAction[] dBEPersistActionArray = persistActions;
            int n = persistActions.length;
            int n2 = 0;
            while (n2 < n) {
                DBEPersistAction action = dBEPersistActionArray[n2];
                String scriptLine = action.getScript();
                if (!CommonUtils.isEmpty((String)scriptLine)) {
                    String redefiner = sqlDialect.getScriptDelimiterRedefiner();
                    String delimiter = SQLUtils.getScriptLineDelimiter(sqlDialect);
                    if (action.isComplex() && redefiner != null && !redefiner.equals(delimiter)) {
                        script.append(lineSeparator).append(redefiner).append(" ").append(DBEAVER_SCRIPT_DELIMITER).append(lineSeparator);
                        delimiter = DBEAVER_SCRIPT_DELIMITER;
                        script.append(delimiter).append(lineSeparator);
                    } else if (action.getType() == DBEPersistAction.ActionType.COMMENT && script.length() > 2) {
                        int lfCount = 0;
                        int i = script.length() - 1;
                        while (i >= 0) {
                            if (!Character.isWhitespace(script.charAt(i))) break;
                            if (script.charAt(i) == '\n') {
                                ++lfCount;
                            }
                            --i;
                        }
                        if (lfCount < 2) {
                            script.append(lineSeparator);
                        }
                    }
                    script.append(scriptLine);
                    if (action.getType() != DBEPersistAction.ActionType.COMMENT) {
                        String testLine = scriptLine.trim();
                        if (testLine.lastIndexOf(delimiter) != testLine.length() - delimiter.length()) {
                            script.append(delimiter);
                        }
                    } else {
                        script.append(lineSeparator);
                    }
                    script.append(lineSeparator);
                    if (action.isComplex() && redefiner != null && !redefiner.equals(delimiter)) {
                        script.append(redefiner).append(" ").append(SQLUtils.getScriptLineDelimiter(sqlDialect)).append(lineSeparator);
                    }
                }
                ++n2;
            }
        }
        return script.toString();
    }

    @NotNull
    public static String generateComments(DBPDataSource dataSource, DBEPersistAction[] persistActions, boolean addComments) {
        StringBuilder script;
        block5: {
            SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource(dataSource);
            String lineSeparator = GeneralUtils.getDefaultLineSeparator();
            script = new StringBuilder(64);
            if (addComments) {
                script.append(DBEAVER_DDL_COMMENT).append(Platform.getProduct().getName()).append(lineSeparator).append(DBEAVER_DDL_WARNING).append(lineSeparator);
            }
            if (persistActions == null) break block5;
            Object[] slComments = sqlDialect.getSingleLineComments();
            Object slComment = ArrayUtils.isEmpty((Object[])slComments) ? "--" : slComments[0];
            DBEPersistAction[] dBEPersistActionArray = persistActions;
            int n = persistActions.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    block8: {
                        String scriptLine;
                        DBEPersistAction action;
                        block6: {
                            action = dBEPersistActionArray[n2];
                            if (action.getType() == DBEPersistAction.ActionType.COMMENT) break block6;
                            scriptLine = action.getTitle();
                            if (CommonUtils.isEmpty((String)scriptLine)) break block7;
                            script.append((String)slComment).append(" ").append(scriptLine);
                            break block8;
                        }
                        scriptLine = action.getScript();
                        if (CommonUtils.isEmpty((String)scriptLine)) break block7;
                        script.append(scriptLine);
                    }
                    script.append(lineSeparator);
                }
                ++n2;
            }
        }
        return script.toString();
    }

    public static String getScriptLineDelimiter(SQLDialect sqlDialect) {
        Object delimiter = SQLUtils.getDefaultScriptDelimiter(sqlDialect);
        if (!((String)delimiter).isEmpty() && Character.isLetterOrDigit(((String)delimiter).charAt(0))) {
            delimiter = " " + (String)delimiter;
        }
        return delimiter;
    }

    public static String[] splitFullIdentifier(String fullName, char nameSeparator, String[][] quoteStrings) {
        return SQLUtils.splitFullIdentifier(fullName, String.valueOf(nameSeparator), quoteStrings, false);
    }

    public static String[] splitFullIdentifier(String fullName, String nameSeparator, String[][] quoteStrings, boolean keepQuotes) {
        String name = fullName.trim();
        if (ArrayUtils.isEmpty((Object[])quoteStrings)) {
            return name.split(Pattern.quote(nameSeparator));
        }
        if (!name.contains(nameSeparator)) {
            name = keepQuotes ? name : DBUtils.getUnQuotedIdentifier(name, quoteStrings);
            return new String[]{name};
        }
        ArrayList<String> nameList = new ArrayList<String>();
        while (!name.isEmpty()) {
            boolean hadQuotedPart = false;
            String[][] stringArray = quoteStrings;
            int n = quoteStrings.length;
            int n2 = 0;
            while (n2 < n) {
                int endPos;
                String[] quotePair = stringArray[n2];
                String startQuote = quotePair[0];
                String endQuote = quotePair[1];
                if (!CommonUtils.isEmpty((String)startQuote) && !CommonUtils.isEmpty((String)endQuote) && name.startsWith(startQuote) && (endPos = name.indexOf(endQuote, startQuote.length())) != -1) {
                    String partName = keepQuotes ? name.substring(0, endPos + endQuote.length()) : name.substring(startQuote.length(), endPos);
                    while (partName.endsWith(nameSeparator)) {
                        partName = partName.substring(0, partName.length() - 1);
                    }
                    if (!partName.isEmpty()) {
                        nameList.add(partName);
                    }
                    name = name.substring(endPos + endQuote.length()).trim();
                    hadQuotedPart = true;
                    break;
                }
                ++n2;
            }
            if (!hadQuotedPart) {
                int endPos = name.indexOf(nameSeparator);
                if (endPos != -1) {
                    nameList.add(name.substring(0, endPos));
                    name = name.substring(endPos);
                } else {
                    nameList.add(name);
                    break;
                }
            }
            if (name.isEmpty() || !name.startsWith(nameSeparator)) continue;
            name = name.substring(nameSeparator.length()).trim();
        }
        return nameList.toArray(new String[0]);
    }

    public static String generateTableJoin(DBRProgressMonitor monitor, DBSEntity leftTable, String leftAlias, DBSEntity rightTable, String rightAlias) throws DBException {
        String sql = SQLUtils.generateTableJoinByAssociation(monitor, leftTable, leftAlias, rightTable, rightAlias);
        if (sql != null) {
            return sql;
        }
        sql = SQLUtils.generateTableJoinByAssociation(monitor, rightTable, rightAlias, leftTable, leftAlias);
        if (sql != null) {
            return sql;
        }
        sql = SQLUtils.generateTableJoinByColumns(monitor, leftTable, leftAlias, rightTable, rightAlias);
        if (sql != null) {
            return sql;
        }
        sql = SQLUtils.generateTableJoinByColumns(monitor, rightTable, rightAlias, leftTable, leftAlias);
        if (sql != null) {
            return sql;
        }
        return null;
    }

    private static String generateTableJoinByColumns(DBRProgressMonitor monitor, DBSEntity leftTable, String leftAlias, DBSEntity rightTable, String rightAlias) throws DBException {
        ArrayList<? extends DBSEntityAttribute> leftIdentifier = new ArrayList<DBSEntityAttribute>(DBUtils.getBestTableIdentifier(monitor, leftTable));
        if (!leftIdentifier.isEmpty()) {
            ArrayList<DBSEntityAttribute> rightAttributes = new ArrayList<DBSEntityAttribute>();
            for (DBSEntityAttribute dBSEntityAttribute : leftIdentifier) {
                DBSEntityAttribute rightAttr = rightTable.getAttribute(monitor, dBSEntityAttribute.getName());
                if (rightAttr == null) break;
                rightAttributes.add(rightAttr);
            }
            if (leftIdentifier.size() != rightAttributes.size()) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            int i = 0;
            while (i < leftIdentifier.size()) {
                stringBuilder.append(leftAlias).append(".").append(DBUtils.getQuotedIdentifier((DBSObject)leftIdentifier.get(i))).append(" = ").append(rightAlias).append(".").append(DBUtils.getQuotedIdentifier((DBSObject)rightAttributes.get(i)));
                ++i;
            }
            return stringBuilder.toString();
        }
        return null;
    }

    private static String generateTableJoinByAssociation(DBRProgressMonitor monitor, DBSEntity leftTable, String leftAlias, DBSEntity rightTable, String rightAlias) throws DBException {
        Collection<? extends DBSEntityAssociation> associations = leftTable.getAssociations(monitor);
        if (!CommonUtils.isEmpty(associations)) {
            for (DBSEntityAssociation dBSEntityAssociation : associations) {
                if (!(dBSEntityAssociation instanceof DBSTableForeignKey) || dBSEntityAssociation.getAssociatedEntity() != rightTable) continue;
                return SQLUtils.generateTablesJoin(monitor, (DBSTableForeignKey)dBSEntityAssociation, leftAlias, rightAlias);
            }
        }
        return null;
    }

    private static String generateTablesJoin(DBRProgressMonitor monitor, DBSTableForeignKey fk, String leftAlias, String rightAlias) throws DBException {
        boolean hasCriteria = false;
        StringBuilder joinSQL = new StringBuilder();
        for (DBSEntityAttributeRef dBSEntityAttributeRef : fk.getAttributeReferences(monitor)) {
            if (!(dBSEntityAttributeRef instanceof DBSTableForeignKeyColumn)) continue;
            if (hasCriteria) {
                joinSQL.append(" AND ");
            }
            DBSTableForeignKeyColumn fkc = (DBSTableForeignKeyColumn)dBSEntityAttributeRef;
            joinSQL.append(leftAlias).append(".").append(DBUtils.getQuotedIdentifier(fkc)).append(" = ").append(rightAlias).append(".").append(DBUtils.getQuotedIdentifier(fkc.getReferencedColumn()));
            hasCriteria = true;
        }
        return joinSQL.toString();
    }

    public static String getTableAlias(DBSEntity table) {
        return CommonUtils.escapeIdentifier((String)table.getName());
    }

    public static void appendQueryConditions(@NotNull DBPDataSource dataSource, @NotNull StringBuilder query, @Nullable String tableAlias, @Nullable DBDDataFilter dataFilter) throws DBException {
        dataSource.getSQLDialect().getQueryGenerator().appendQueryConditions(dataSource, query, tableAlias, dataFilter);
    }

    public static void appendQueryOrder(DBPDataSource dataSource, @NotNull StringBuilder query, @Nullable String tableAlias, @Nullable DBDDataFilter dataFilter) {
        dataSource.getSQLDialect().getQueryGenerator().appendQueryOrder(dataSource, query, tableAlias, dataFilter);
    }

    public static boolean isExecQuery(@NotNull SQLDialect dialect, String query) {
        String[] executeKeywords = dialect.getExecuteKeywords();
        if (executeKeywords != null && executeKeywords.length > 0) {
            String queryStart = SQLUtils.getFirstKeyword(dialect, query);
            return SQLUtils.isExecKeyword(dialect, queryStart);
        }
        return false;
    }

    public static boolean isExecKeyword(SQLDialect dialect, String word) {
        return ArrayUtils.containsIgnoreCase((String[])dialect.getExecuteKeywords(), (String)word);
    }

    public static String stripColumnTypeModifiers(String type) {
        int endPos;
        int startPos = type.indexOf("(");
        if (startPos != -1 && (endPos = type.lastIndexOf(")")) != -1) {
            return type.substring(0, startPos);
        }
        return type;
    }

    public static void fillQueryParameters(SQLQuery sqlStatement, List<SQLQueryParameter> parameters) {
        Object query = sqlStatement.getText();
        int i = parameters.size();
        while (i > 0) {
            SQLQueryParameter parameter = parameters.get(i - 1);
            String paramValue = parameter.getValue();
            if (paramValue == null || paramValue.isEmpty()) {
                paramValue = "NULL";
            }
            query = ((String)query).substring(0, parameter.getTokenOffset()) + paramValue + ((String)query).substring(parameter.getTokenOffset() + parameter.getTokenLength());
            --i;
        }
        sqlStatement.setText((String)query);
    }

    public static boolean needQueryDelimiter(SQLDialect sqlDialect, String query) {
        String[] scriptDelimiters;
        String[] stringArray = scriptDelimiters = sqlDialect.getScriptDelimiters();
        int n = scriptDelimiters.length;
        int n2 = 0;
        while (n2 < n) {
            String delimiter = stringArray[n2];
            if (!delimiter.isEmpty()) {
                if (Character.isLetterOrDigit(delimiter.charAt(0))) {
                    if (query.toUpperCase().endsWith(delimiter.toUpperCase()) && !Character.isLetterOrDigit(query.charAt(query.length() - delimiter.length() - 1))) {
                        return true;
                    }
                } else {
                    return !query.endsWith(delimiter);
                }
            }
            ++n2;
        }
        return false;
    }

    public static String removeQueryDelimiter(SQLDialect sqlDialect, String query) {
        String[] scriptDelimiters;
        String[] stringArray = scriptDelimiters = sqlDialect.getScriptDelimiters();
        int n = scriptDelimiters.length;
        int n2 = 0;
        while (n2 < n) {
            String delimiter = stringArray[n2];
            if (!delimiter.isEmpty() && query.contains(delimiter)) {
                String queryWithoutDelimiter = query.substring(0, query.lastIndexOf(delimiter));
                if (Character.isLetterOrDigit(delimiter.charAt(0)) ? query.toUpperCase().endsWith(delimiter.toUpperCase()) && !Character.isLetterOrDigit(query.charAt(query.length() - delimiter.length() - 1)) : query.endsWith(delimiter)) {
                    return queryWithoutDelimiter;
                }
            }
            ++n2;
        }
        return query;
    }

    public static String getDefaultScriptDelimiter(SQLDialect sqlDialect) {
        Object[] scriptDelimiters = sqlDialect.getScriptDelimiters();
        if (!ArrayUtils.isEmpty((Object[])scriptDelimiters)) {
            return scriptDelimiters[0];
        }
        return ";";
    }

    public static boolean isLatinLetter(int codePoint) {
        return Character.isLetter(codePoint) && Character.UnicodeBlock.of(codePoint) == Character.UnicodeBlock.BASIC_LATIN;
    }

    public static String identifierToCanonicalForm(@NotNull SQLDialect dialect, @NotNull String rawIdentifierString, boolean forceUnquotted, boolean prepared) {
        String unquottedIdentifier;
        if (prepared) {
            unquottedIdentifier = rawIdentifierString;
        } else {
            boolean isQuoted = dialect.isQuotedIdentifier(rawIdentifierString);
            DBPIdentifierCase identifierCase = isQuoted ? dialect.storesQuotedCase() : dialect.storesUnquotedCase();
            unquottedIdentifier = identifierCase.transform(dialect.getUnquotedIdentifier(rawIdentifierString, true));
        }
        String actualIdentifierString = forceUnquotted ? unquottedIdentifier : dialect.getQuotedIdentifier(unquottedIdentifier, true, false);
        return actualIdentifierString;
    }
}

