/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseObject;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class AltibaseDbLink
extends AltibaseObject<GenericStructContainer>
implements DBPScriptObject,
DBPRefreshableObject {
    private String ddl;
    private String userName;
    private int linkId;
    private int userMode;
    private String remoteUserId;
    private String targetName;
    private int linkType;
    private Timestamp created;
    private Timestamp lastDdlTime;

    protected AltibaseDbLink(GenericStructContainer parent, JDBCResultSet resultSet) {
        super(parent, JDBCUtils.safeGetString((ResultSet)resultSet, (String)"LINK_NAME"), JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"LINK_OID"), true);
        this.userName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"USER_NAME");
        this.linkId = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"LINK_ID");
        this.userMode = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"USER_MODE");
        this.remoteUserId = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REMOTE_USER_ID");
        this.linkType = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"LINK_TYPE");
        this.targetName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TARGET_NAME");
        this.created = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CREATED");
        this.lastDdlTime = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"LAST_DDL_TIME");
    }

    @Property(viewable=true, order=2)
    public int getLinkId() {
        return this.linkId;
    }

    @Property(viewable=true, order=3)
    public long getLinkOid() {
        return this.getObjectId();
    }

    @Property(viewable=true, order=4)
    @Nullable
    public String getUserName() {
        return this.userName;
    }

    @Property(viewable=true, order=5)
    @NotNull
    public String getRemoteUserId() {
        return this.remoteUserId;
    }

    @Property(viewable=true, order=6)
    @NotNull
    public String getTargetName() {
        return this.targetName;
    }

    @Property(viewable=true, order=7)
    @NotNull
    public String getUserMode() {
        return this.isPublic() ? "Public" : "Private";
    }

    @Property(viewable=true, order=8)
    @NotNull
    public String getLinkType() {
        return this.linkType == 0 ? "Heterogeneous" : "Homogeneous";
    }

    @Property(viewable=true, order=10)
    @NotNull
    public Timestamp getCreated() {
        return this.created;
    }

    @Property(viewable=true, order=11)
    @NotNull
    public Timestamp getLastDdlTime() {
        return this.lastDdlTime;
    }

    private boolean isPublic() {
        return this.userMode == 0;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)this.ddl)) {
            options.put("SCHEMA", this.isPublic() ? "PUBLIC" : ((GenericStructContainer)this.getParentObject()).getName());
            this.ddl = this.getDataSource().getMetaModel().getDbLinkDDL(monitor, this, options) + ";";
        }
        return this.ddl;
    }

    public DBSObject refreshObject(DBRProgressMonitor monitor) throws DBException {
        DBSObject dbsObject = null;
        if (this.isPublic()) {
            AltibaseDataSource dataSouce = this.getDataSource();
            dbsObject = dataSouce.getDbLinkCache().refreshObject(monitor, (DBSObject)dataSouce, this);
        } else {
            AltibaseSchema schema = (AltibaseSchema)((Object)this.getParentObject());
            dbsObject = schema.getDbLinkCache().refreshObject(monitor, (DBSObject)schema, this);
        }
        return dbsObject;
    }
}

