/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleExecutionContext;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTable;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraint;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKey;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class OracleStructureAssistant
implements DBSStructureAssistant<OracleExecutionContext> {
    private static final Log log = Log.getLog(OracleStructureAssistant.class);
    private final OracleDataSource dataSource;

    public OracleStructureAssistant(OracleDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @NotNull
    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{OracleObjectType.TABLE, OracleObjectType.PACKAGE, OracleObjectType.CONSTRAINT, OracleObjectType.FOREIGN_KEY, OracleObjectType.INDEX, OracleObjectType.PROCEDURE, OracleObjectType.SEQUENCE, OracleObjectType.TRIGGER};
    }

    @NotNull
    public DBSObjectType[] getSearchObjectTypes() {
        return new DBSObjectType[]{OracleObjectType.TABLE, OracleObjectType.VIEW, OracleObjectType.MATERIALIZED_VIEW, OracleObjectType.PACKAGE, OracleObjectType.INDEX, OracleObjectType.PROCEDURE, OracleObjectType.SEQUENCE, OracleObjectType.SCHEMA};
    }

    @NotNull
    public DBSObjectType[] getHyperlinkObjectTypes() {
        return new DBSObjectType[]{OracleObjectType.TABLE, OracleObjectType.PACKAGE, OracleObjectType.PROCEDURE};
    }

    @NotNull
    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{OracleObjectType.TABLE, OracleObjectType.PACKAGE, OracleObjectType.PROCEDURE, OracleObjectType.SYNONYM};
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(@NotNull DBRProgressMonitor monitor, @NotNull OracleExecutionContext executionContext, @NotNull DBSStructureAssistant.ObjectsSearchParams params) throws DBException {
        OracleSchema schema = params.getParentObject() instanceof OracleSchema ? (OracleSchema)params.getParentObject() : null;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.META, "Find objects by name");){
                ArrayList<DBSObjectReference> objects = new ArrayList<DBSObjectReference>();
                if (ArrayUtils.containsAny((Object[])params.getObjectTypes(), (Object[])new DBSObjectType[]{OracleObjectType.CONSTRAINT, OracleObjectType.FOREIGN_KEY})) {
                    this.findConstraintsByMask(session, schema, params, objects);
                    if (!this.containsOnlyConstraintOrFK(params.getObjectTypes())) {
                        this.searchAllObjects(session, schema, params, objects);
                    }
                } else {
                    this.searchAllObjects(session, schema, params, objects);
                }
                if (params.isSearchInComments()) {
                    this.searchInTableComments(session, schema, params, objects);
                }
                OracleSchema activeSchema = executionContext.getContextDefaults().getDefaultSchema();
                objects.sort((o1, o2) -> {
                    if (CommonUtils.equalObjects((Object)o1.getContainer(), (Object)o2.getContainer())) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    if (o1.getContainer() == null || o1.getContainer() == activeSchema) {
                        return -1;
                    }
                    if (o2.getContainer() == null || o2.getContainer() == activeSchema) {
                        return 1;
                    }
                    return o1.getContainer().getName().compareTo(o2.getContainer().getName());
                });
                return objects;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            throw new DBDatabaseException((Throwable)ex, (DBPDataSource)this.dataSource);
        }
    }

    private void findConstraintsByMask(JDBCSession session, final OracleSchema schema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        List<DBSObjectType> objectTypesList = Arrays.asList(params.getObjectTypes());
        final boolean hasFK = objectTypesList.contains((Object)OracleObjectType.FOREIGN_KEY);
        final boolean hasConstraints = objectTypesList.contains((Object)OracleObjectType.CONSTRAINT);
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT " + OracleUtils.getSysCatalogHint((OracleDataSource)session.getDataSource()) + " OWNER, TABLE_NAME, CONSTRAINT_NAME, CONSTRAINT_TYPE\nFROM " + OracleUtils.getAdminAllViewPrefix(monitor, (OracleDataSource)session.getDataSource(), "CONSTRAINTS") + "\nWHERE" + (params.isCaseSensitive() ? " CONSTRAINT_NAME " : " UPPER(CONSTRAINT_NAME) ") + "LIKE ?" + (!hasFK ? " AND CONSTRAINT_TYPE<>'R'" : "") + (schema != null ? " AND OWNER=?" : ""));){
            dbStat.setString(1, params.isCaseSensitive() ? params.getMask() : params.getMask().toUpperCase());
            if (schema != null) {
                dbStat.setString(2, schema.getName());
            }
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next() && objects.size() < params.getMaxResults()) {
                    final String schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
                    final String constrName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_NAME");
                    String constrType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_TYPE");
                    final DBSEntityConstraintType type = OracleTableConstraint.getConstraintType(constrType);
                    objects.add((DBSObjectReference)new AbstractObjectReference<OracleSchema>(constrName, this.dataSource.getSchema(session.getProgressMonitor(), schemaName), null, type == DBSEntityConstraintType.FOREIGN_KEY ? OracleTableForeignKey.class : OracleTableConstraint.class, (DBSObjectType)(type == DBSEntityConstraintType.FOREIGN_KEY ? OracleObjectType.FOREIGN_KEY : OracleObjectType.CONSTRAINT)){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            OracleSchema tableSchema;
                            OracleSchema oracleSchema = tableSchema = schema != null ? schema : OracleStructureAssistant.this.dataSource.getSchema(monitor, schemaName);
                            if (tableSchema == null) {
                                throw new DBException("Constraint schema '" + schemaName + "' not found");
                            }
                            OracleTable table = tableSchema.getTable(monitor, tableName);
                            if (table == null) {
                                throw new DBException("Constraint table '" + tableName + "' not found in catalog '" + tableSchema.getName() + "'");
                            }
                            Object constraint = null;
                            if (hasFK && type == DBSEntityConstraintType.FOREIGN_KEY) {
                                constraint = table.getForeignKey(monitor, constrName);
                            }
                            if (hasConstraints && type != DBSEntityConstraintType.FOREIGN_KEY) {
                                constraint = table.getConstraint(monitor, constrName);
                            }
                            if (constraint == null) {
                                throw new DBException("Constraint '" + constrName + "' not found in table '" + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            }
                            return constraint;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void searchAllObjects(JDBCSession session, OracleSchema schema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> objects) throws SQLException, DBException {
        ArrayList<DBSObjectType> oracleObjectTypes = new ArrayList<DBSObjectType>(params.getObjectTypes().length + 2);
        boolean searchViewsByDefinition = false;
        DBSObjectType[] dBSObjectTypeArray = params.getObjectTypes();
        int n = dBSObjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObjectType objectType = dBSObjectTypeArray[n2];
            if (objectType instanceof OracleObjectType) {
                oracleObjectTypes.add(objectType);
                if (objectType == OracleObjectType.PROCEDURE) {
                    oracleObjectTypes.add(OracleObjectType.FUNCTION);
                } else if (objectType == OracleObjectType.TABLE) {
                    oracleObjectTypes.add(OracleObjectType.VIEW);
                    searchViewsByDefinition = params.isSearchInDefinitions();
                } else if (objectType == OracleObjectType.PACKAGE) {
                    oracleObjectTypes.add(OracleObjectType.PACKAGE_BODY);
                }
            } else if (DBSProcedure.class.isAssignableFrom(objectType.getTypeClass())) {
                oracleObjectTypes.add(OracleObjectType.FUNCTION);
                oracleObjectTypes.add(OracleObjectType.PROCEDURE);
            }
            ++n2;
        }
        StringJoiner objectTypeClause = new StringJoiner(",");
        for (DBSObjectType objectType : oracleObjectTypes) {
            objectTypeClause.add("'" + objectType.getTypeName() + "'");
        }
        if (objectTypeClause.length() == 0) {
            return;
        }
        OracleDataSource dataSource = (OracleDataSource)session.getDataSource();
        String mask = params.getMask();
        StringBuilder query = new StringBuilder();
        String ownerClause = schema != null ? " AND OWNER = ?" : "";
        query.append("SELECT ").append(OracleUtils.getSysCatalogHint(dataSource)).append(" DISTINCT OWNER,OBJECT_NAME,OBJECT_TYPE FROM (").append("\nSELECT OWNER,OBJECT_NAME,OBJECT_TYPE FROM ").append(OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), dataSource, "OBJECTS")).append(" WHERE ").append("OBJECT_TYPE IN (").append(objectTypeClause).append(") AND ").append(!params.isCaseSensitive() ? "UPPER(OBJECT_NAME)" : "OBJECT_NAME").append(" LIKE ? ").append(ownerClause);
        if (this.searchInSynonyms()) {
            query.append("UNION ALL\nSELECT ").append(OracleUtils.getSysCatalogHint(dataSource)).append(" O.OWNER,O.OBJECT_NAME,O.OBJECT_TYPE\n").append("FROM ").append(OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), dataSource, "SYNONYMS")).append(" S,").append(OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), dataSource, "OBJECTS")).append(" O\n").append("WHERE O.OWNER=S.TABLE_OWNER AND O.OBJECT_NAME=S.TABLE_NAME AND O.OBJECT_TYPE<>'JAVA CLASS' AND ").append(!params.isCaseSensitive() ? "UPPER(S.SYNONYM_NAME)" : "S.SYNONYM_NAME").append("  LIKE ?");
        }
        if (Set.of(params.getObjectTypes()).contains((Object)OracleObjectType.SCHEMA)) {
            query.append(" UNION ALL\nSELECT USERNAME as OWNER, USERNAME as OBJECT_NAME, 'SCHEMA' as OBJECT_TYPE\n").append("FROM ").append(OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), dataSource, "USERS")).append(" WHERE ").append(!params.isCaseSensitive() ? "UPPER(USERNAME)" : "USERNAME").append(" LIKE ?");
        }
        if (searchViewsByDefinition) {
            query.append(" UNION ALL SELECT OWNER, VIEW_NAME, 'VIEW' AS OBJECT_TYPE FROM ");
            query.append(OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), dataSource, "VIEWS"));
            query.append(" v WHERE ");
            if (params.isCaseSensitive()) {
                query.append("v.\"TEXT_VC\"");
            } else {
                query.append("UPPER(v.\"TEXT_VC\")");
            }
            query.append(" LIKE ?");
            query.append(ownerClause);
        }
        if (params.isSearchInDefinitions()) {
            query.append(" UNION ALL SELECT DISTINCT owner, name, type FROM ");
            query.append(OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), dataSource, "SOURCE"));
            query.append(" WHERE ");
            if (params.isCaseSensitive()) {
                query.append("text ");
            } else {
                query.append("UPPER(text) ");
            }
            query.append("LIKE ?");
            query.append(ownerClause);
        }
        query.append(")\nORDER BY OBJECT_NAME");
        Throwable throwable = null;
        Object var13_17 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(query.toString());){
            if (!params.isCaseSensitive()) {
                mask = mask.toUpperCase();
            }
            dbStat.setString(1, mask);
            int idx = 2;
            if (!ownerClause.isEmpty()) {
                dbStat.setString(idx, schema.getName());
                ++idx;
            }
            if (this.searchInSynonyms()) {
                dbStat.setString(idx, mask);
                ++idx;
            }
            if (Set.of(params.getObjectTypes()).contains((Object)OracleObjectType.SCHEMA)) {
                dbStat.setString(idx++, mask);
            }
            if (searchViewsByDefinition) {
                dbStat.setString(idx, mask);
                ++idx;
                if (!ownerClause.isEmpty()) {
                    dbStat.setString(idx, schema.getName());
                    ++idx;
                }
            }
            if (params.isSearchInDefinitions()) {
                dbStat.setString(idx, mask);
                ++idx;
                if (!ownerClause.isEmpty()) {
                    dbStat.setString(idx, schema.getName());
                }
            }
            dbStat.setFetchSize(1000);
            Throwable throwable2 = null;
            Object var17_23 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!session.getProgressMonitor().isCanceled() && objects.size() < params.getMaxResults() && dbResult.next()) {
                    String schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
                    String objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_NAME");
                    String objectTypeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_TYPE");
                    OracleObjectType objectType = OracleObjectType.getByType(objectTypeName);
                    if (objectType == OracleObjectType.PACKAGE_BODY) {
                        objectType = OracleObjectType.PACKAGE;
                    }
                    if (objectType == null || !objectType.isBrowsable() || !oracleObjectTypes.contains((Object)objectType)) continue;
                    OracleSchema objectSchema = this.dataSource.getSchema(session.getProgressMonitor(), schemaName);
                    if (objectSchema == null) {
                        log.debug((Object)("Schema '" + schemaName + "' not found. Probably was filtered"));
                        continue;
                    }
                    this.addObjectReference(objects, objectName, objectSchema, objectType, objectTypeName, schemaName, session);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void addObjectReference(@NotNull Collection<DBSObjectReference> references, final String objectName, @NotNull OracleSchema objectSchema, final @NotNull OracleObjectType objectType, final String objectTypeName, final String schemaName, final @NotNull JDBCSession session) {
        references.add((DBSObjectReference)new AbstractObjectReference<OracleSchema>(objectName, objectSchema, null, objectType.getTypeClass(), (DBSObjectType)objectType){

            public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                OracleSchema tableSchema = (OracleSchema)this.getContainer();
                DBSObject object = objectType.findObject(session.getProgressMonitor(), tableSchema, objectName);
                if (object == null) {
                    throw new DBException(objectTypeName + " '" + objectName + "' not found in schema '" + tableSchema.getName() + "'");
                }
                return object;
            }

            @NotNull
            public String getFullyQualifiedName(DBPEvaluationContext context) {
                if (objectType == OracleObjectType.SYNONYM && "PUBLIC".equals(schemaName)) {
                    return DBUtils.getQuotedIdentifier((DBPDataSource)OracleStructureAssistant.this.dataSource, (String)objectName);
                }
                return super.getFullyQualifiedName(context);
            }
        });
    }

    private void searchInTableComments(@NotNull JDBCSession session, @Nullable OracleSchema schema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> objects) throws SQLException, DBException {
        if (objects.size() >= params.getMaxResults() || !ArrayUtils.contains((Object[])params.getObjectTypes(), (Object)((Object)OracleObjectType.TABLE))) {
            return;
        }
        StringBuilder sql = new StringBuilder("SELECT atc.OWNER, atc.TABLE_NAME, atc.TABLE_TYPE FROM ALL_TAB_COMMENTS atc WHERE ");
        String mask = params.getMask();
        if (params.isCaseSensitive()) {
            sql.append("atc.COMMENTS ");
        } else {
            sql.append("UPPER(atc.COMMENTS) ");
            mask = mask.toUpperCase();
        }
        sql.append("LIKE ? ");
        if (schema != null) {
            sql.append("AND atc.OWNER = ? ");
        }
        sql.append("ORDER BY atc.TABLE_NAME");
        Throwable throwable = null;
        Object var8_9 = null;
        try (JDBCPreparedStatement preparedStatement = session.prepareStatement(sql.toString());){
            preparedStatement.setString(1, mask);
            if (schema != null) {
                preparedStatement.setString(2, schema.getName());
            }
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (JDBCResultSet resultSet = preparedStatement.executeQuery();){
                while (!session.getProgressMonitor().isCanceled() && objects.size() < params.getMaxResults() && resultSet.next()) {
                    String owner = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"OWNER");
                    String tableName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TABLE_NAME");
                    String tableType = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TABLE_TYPE");
                    OracleObjectType oracleObjectType = OracleObjectType.getByType(tableType);
                    if (oracleObjectType == null || !oracleObjectType.isBrowsable() || tableName == null) continue;
                    OracleSchema objectSchema = this.dataSource.getSchema(session.getProgressMonitor(), owner);
                    if (objectSchema == null) {
                        log.debug((Object)("Schema '" + owner + "' not found. Probably was filtered"));
                        continue;
                    }
                    this.addObjectReference(objects, tableName, objectSchema, oracleObjectType, tableType, owner, session);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private boolean containsOnlyConstraintOrFK(DBSObjectType[] objectTypes) {
        DBSObjectType[] dBSObjectTypeArray = objectTypes;
        int n = objectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObjectType objectType = dBSObjectTypeArray[n2];
            if (objectType != OracleObjectType.CONSTRAINT && objectType != OracleObjectType.FOREIGN_KEY) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean searchInSynonyms() {
        String property = this.dataSource.getContainer().getConnectionConfiguration().getProviderProperty("oracle.meta-search-in-synonyms");
        return CommonUtils.getBoolean((String)property);
    }

    public boolean supportsSearchInCommentsFor(@NotNull DBSObjectType objectType) {
        return objectType == OracleObjectType.TABLE;
    }

    public boolean supportsSearchInDefinitionsFor(@NotNull DBSObjectType objectType) {
        return true;
    }
}

