/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.dml;

import java.util.Collections;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModelContent;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQueryDMLStatementModel;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsCorrelatedSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryDeleteModel
extends SQLQueryDMLStatementModel {
    @Nullable
    private final SQLQueryValueExpression whereClause;
    @Nullable
    private final SQLQueryRowsCorrelatedSourceModel aliasedTableModel;

    @NotNull
    public static SQLQueryModelContent recognize(@NotNull SQLQueryModelRecognizer recognizer, @NotNull STMTreeNode node) {
        STMTreeNode tableNameNode = node.findFirstChildOfName(STMKnownRuleNames.tableName);
        SQLQueryRowsTableDataModel tableModel = tableNameNode == null ? null : recognizer.collectTableReference(tableNameNode, false);
        STMTreeNode aliasNode = node.findFirstChildOfName(STMKnownRuleNames.correlationName);
        SQLQuerySymbolEntry alias = aliasNode == null ? null : recognizer.collectIdentifier(aliasNode, null);
        STMTreeNode whereClauseNode = node.findFirstChildOfName(STMKnownRuleNames.whereClause);
        SQLQueryValueExpression whereClauseExpr = whereClauseNode == null ? null : recognizer.collectValueExpression(whereClauseNode);
        return new SQLQueryDeleteModel(node, tableModel, alias, whereClauseExpr);
    }

    private SQLQueryDeleteModel(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryRowsTableDataModel tableModel, @Nullable SQLQuerySymbolEntry alias, @Nullable SQLQueryValueExpression whereClause) {
        super(syntaxNode, tableModel);
        this.whereClause = whereClause;
        if (alias != null && tableModel != null) {
            Interval.of((int)tableModel.getInterval().a, (int)alias.getInterval().b);
            this.aliasedTableModel = new SQLQueryRowsCorrelatedSourceModel(syntaxNode, tableModel, alias, Collections.emptyList());
        } else {
            this.aliasedTableModel = null;
        }
    }

    @Nullable
    public SQLQueryValueExpression getCondition() {
        return this.whereClause;
    }

    @Nullable
    public SQLQueryRowsCorrelatedSourceModel getAliasedTableModel() {
        return this.aliasedTableModel;
    }

    @Override
    public void propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.aliasedTableModel != null) {
            context = this.aliasedTableModel.propagateContext(context, statistics);
        }
        if (this.whereClause != null) {
            this.whereClause.propagateContext(context, statistics);
        }
    }

    @Override
    @Nullable
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitTableStatementDelete(this, arg);
    }
}

