/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSetOperationModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryRowsCrossJoinModel
extends SQLQueryRowsSetOperationModel
implements SQLQueryNodeModel.NodeSubtreeTraverseControl<SQLQueryRowsSourceModel, SQLQueryRowsDataContext> {
    private final boolean isLateral;

    public SQLQueryRowsCrossJoinModel(@NotNull Interval range, @NotNull STMTreeNode syntaxNode, @NotNull SQLQueryRowsSourceModel left, @NotNull SQLQueryRowsSourceModel right, boolean isLateral) {
        super(range, syntaxNode, left, right);
        this.isLateral = isLateral;
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryDataContext left = this.left.propagateContext(context, statistics);
        SQLQueryDataContext right = this.right.propagateContext(this.isLateral ? left : context, statistics);
        SQLQueryDataContext combined = left.combine(right);
        return combined;
    }

    @Override
    protected SQLQueryRowsSourceContext resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryRowsSourceContext left = this.left.resolveRowSources(context, statistics);
        SQLQueryRowsSourceContext right = this.right.resolveRowSources(this.isLateral ? left : context, statistics);
        SQLQueryRowsSourceContext combined = left.combine(right);
        return combined;
    }

    @Override
    @Nullable
    public SQLQueryRowsDataContext getContextForChild(@NotNull SQLQueryRowsSourceModel child, @Nullable SQLQueryRowsDataContext defaultContext) {
        return this.isLateral && child == this.right ? this.left.getRowsDataContext() : defaultContext;
    }

    @Override
    protected SQLQueryRowsDataContext resolveRowDataImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        return this.left.getRowsDataContext().combine(this.right.getRowsDataContext());
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsCrossJoin(this, arg);
    }
}

