/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.LinkedList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsProjectionModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQuerySelectionResultModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQuerySelectionResultSublistSpec;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQuerySelectionResultColumnSpec
extends SQLQuerySelectionResultSublistSpec {
    @Nullable
    private final SQLQueryValueExpression valueExpression;
    @Nullable
    private final SQLQuerySymbolEntry alias;

    public SQLQuerySelectionResultColumnSpec(@NotNull SQLQuerySelectionResultModel resultModel, @NotNull STMTreeNode syntaxNode, @Nullable SQLQueryValueExpression valueExpression) {
        this(resultModel, syntaxNode, valueExpression, null);
    }

    public SQLQuerySelectionResultColumnSpec(@NotNull SQLQuerySelectionResultModel resultModel, @NotNull STMTreeNode syntaxNode, @Nullable SQLQueryValueExpression valueExpression, @Nullable SQLQuerySymbolEntry alias) {
        super(resultModel, syntaxNode);
        this.valueExpression = valueExpression;
        this.alias = alias;
        if (valueExpression != null) {
            this.registerSubnode(valueExpression);
        }
    }

    @Nullable
    public SQLQueryValueExpression getValueExpression() {
        return this.valueExpression;
    }

    @Nullable
    public SQLQuerySymbolEntry getAlias() {
        return this.alias;
    }

    @Override
    protected void collectColumns(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRowsProjectionModel rowsSourceModel, @NotNull SQLQueryRecognitionContext statistics, @NotNull LinkedList<SQLQueryResultColumn> resultColumns) {
        if (this.valueExpression != null) {
            this.valueExpression.propagateContext(context, statistics);
        }
        this.collectColumnImpl(rowsSourceModel, resultColumns);
    }

    @Override
    protected void collectColumns(@NotNull SQLQueryRowsDataContext knownValues, @NotNull SQLQueryRowsProjectionModel rowsSourceModel, @NotNull SQLQueryRecognitionContext statistics, @NotNull LinkedList<SQLQueryResultColumn> resultColumns) {
        if (this.valueExpression != null) {
            this.valueExpression.resolveRowSources(knownValues.getRowsSources(), statistics);
            this.valueExpression.resolveValueRelations(knownValues, statistics);
        }
        this.collectColumnImpl(rowsSourceModel, resultColumns);
    }

    protected void collectColumnImpl(@NotNull SQLQueryRowsProjectionModel rowsSourceModel, @NotNull LinkedList<SQLQueryResultColumn> resultColumns) {
        SQLQueryResultColumn underlyingColumn;
        SQLQuerySymbol columnName;
        if (this.alias != null) {
            if (!this.alias.isNotClassified()) {
                return;
            }
            columnName = this.alias.getSymbol();
            columnName.setDefinition(this.alias);
            columnName.setSymbolClass(SQLQuerySymbolClass.COLUMN_DERIVED);
            underlyingColumn = null;
        } else {
            if (this.valueExpression != null) {
                columnName = this.valueExpression.getColumnNameIfTrivialExpression();
                underlyingColumn = this.valueExpression.getColumnIfTrivialExpression();
            } else {
                columnName = null;
                underlyingColumn = null;
            }
            if (columnName == null) {
                columnName = new SQLQuerySymbol("?");
            }
        }
        SQLQueryExprType type = this.valueExpression == null ? SQLQueryExprType.UNKNOWN : this.valueExpression.getValueType();
        resultColumns.add(underlyingColumn == null ? new SQLQueryResultColumn(resultColumns.size(), columnName, rowsSourceModel, null, null, type) : new SQLQueryResultColumn(resultColumns.size(), columnName, rowsSourceModel, underlyingColumn.realSource, underlyingColumn.realAttr, type));
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T node) {
        return visitor.visitSelectColumnSpec(this, node);
    }
}

