/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.IPersistentStorage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.IOUtils;

public class BinaryEditorInput
implements IEditorInput,
IStorageEditorInput {
    private String name;
    private byte[] value;
    private boolean readOnly;
    private IStorage storage;
    private String encoding;

    public BinaryEditorInput(String name, byte[] value, boolean readOnly, String encoding) {
        this.name = name;
        this.value = value;
        this.readOnly = readOnly;
        this.encoding = encoding;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_INFO);
    }

    public String getName() {
        return this.name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IStorage getStorage() {
        if (this.storage == null) {
            this.storage = new ByteStorage();
        }
        return this.storage;
    }

    public String getToolTipText() {
        return this.name;
    }

    public String toString() {
        return new String(this.value);
    }

    public byte[] getValue() {
        return this.value;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IStorage.class) {
            return adapter.cast(this.getStorage());
        }
        return null;
    }

    private class ByteStorage
    implements IPersistentStorage,
    IEncodedStorage {
        private ByteStorage() {
        }

        public InputStream getContents() throws CoreException {
            return new ByteArrayInputStream(BinaryEditorInput.this.value);
        }

        public IPath getFullPath() {
            return null;
        }

        public String getName() {
            return BinaryEditorInput.this.name;
        }

        public boolean isReadOnly() {
            return BinaryEditorInput.this.readOnly;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public void setContents(IProgressMonitor monitor, InputStream stream) throws CoreException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                IOUtils.copyStream((InputStream)stream, (OutputStream)baos);
            }
            catch (IOException e) {
                throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
            }
            BinaryEditorInput.this.value = baos.toByteArray();
        }

        public String getCharset() throws CoreException {
            return BinaryEditorInput.this.encoding;
        }
    }
}

