/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.AgentProxyException;
import com.jcraft.jsch.USocketFactory;
import java.io.IOException;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class UnixDomainSocketFactory
implements USocketFactory {
    @Override
    public SocketChannel connect(Path path) throws IOException {
        UnixDomainSocketAddress sockAddr = UnixDomainSocketAddress.of(path);
        SocketChannel sock = SocketChannel.open(StandardProtocolFamily.UNIX);
        sock.configureBlocking(true);
        sock.connect(sockAddr);
        return sock;
    }

    @Override
    public ServerSocketChannel bind(Path path) throws IOException {
        UnixDomainSocketAddress sockAddr = UnixDomainSocketAddress.of(path);
        ServerSocketChannel sock = ServerSocketChannel.open(StandardProtocolFamily.UNIX);
        sock.configureBlocking(true);
        sock.bind(sockAddr);
        return sock;
    }
}

