/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.spark.jdbc;

import com.databricks.client.dsi.core.impl.DSIDriverSingleton;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpUriRequest;
import com.databricks.client.support.LogUtilities;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResultFileDownloadMonitor
implements Runnable {
    static ResultFileDownloadMonitor s_resultFileDownloadMonitor;
    private HashMap<HttpUriRequest, AtomicBoolean> m_requestList = new HashMap();
    private AtomicBoolean m_isStopped = new AtomicBoolean(false);

    public synchronized void addDownloadTask(HttpUriRequest httpUriRequest) {
        LogUtilities.logFunctionEntrance(DSIDriverSingleton.getInstance().getDriverLog(), new Object[0]);
        this.m_requestList.put(httpUriRequest, new AtomicBoolean(false));
    }

    public synchronized void stopDownloadTask(HttpUriRequest httpUriRequest) {
        LogUtilities.logFunctionEntrance(DSIDriverSingleton.getInstance().getDriverLog(), new Object[0]);
        if (this.m_requestList.containsKey(httpUriRequest)) {
            this.m_requestList.get(httpUriRequest).set(true);
        }
    }

    public synchronized void removeDownloadTask(HttpUriRequest httpUriRequest) {
        LogUtilities.logFunctionEntrance(DSIDriverSingleton.getInstance().getDriverLog(), new Object[0]);
        if (this.m_requestList.containsKey(httpUriRequest)) {
            this.m_requestList.remove(httpUriRequest);
        }
    }

    static synchronized ResultFileDownloadMonitor getResultFileDownloadMonitor() {
        LogUtilities.logFunctionEntrance(DSIDriverSingleton.getInstance().getDriverLog(), new Object[0]);
        if (null == s_resultFileDownloadMonitor) {
            s_resultFileDownloadMonitor = new ResultFileDownloadMonitor();
        }
        return s_resultFileDownloadMonitor;
    }

    private ResultFileDownloadMonitor() {
        LogUtilities.logFunctionEntrance(DSIDriverSingleton.getInstance().getDriverLog(), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LogUtilities.logFunctionEntrance(DSIDriverSingleton.getInstance().getDriverLog(), new Object[0]);
        while (!this.m_isStopped.get()) {
            ResultFileDownloadMonitor resultFileDownloadMonitor = this;
            synchronized (resultFileDownloadMonitor) {
                for (Map.Entry<HttpUriRequest, AtomicBoolean> entry : this.m_requestList.entrySet()) {
                    if (!entry.getValue().get()) continue;
                    LogUtilities.logDebug("Aborting " + entry.getKey().toString(), DSIDriverSingleton.getInstance().getDriverLog());
                    entry.getKey().abort();
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                LogUtilities.logWarning(interruptedException, DSIDriverSingleton.getInstance().getDriverLog());
            }
        }
    }

    public void stop() {
        LogUtilities.logFunctionEntrance(DSIDriverSingleton.getInstance().getDriverLog(), new Object[0]);
        this.m_isStopped.set(true);
    }

    public int getRequestListSize() {
        LogUtilities.logFunctionEntrance(DSIDriverSingleton.getInstance().getDriverLog(), new Object[0]);
        return this.m_requestList.size();
    }
}

