/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.duckdb;

import java.sql.Connection;
import org.flywaydb.community.database.DuckDBDatabaseExtension;
import org.flywaydb.community.database.duckdb.DuckDBDatabase;
import org.flywaydb.community.database.duckdb.DuckDBParser;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.CommunityDatabaseType;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;

public class DuckDBDatabaseType
extends BaseDatabaseType
implements CommunityDatabaseType {
    public String getName() {
        return "DuckDB";
    }

    public int getNullType() {
        return 0;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:duckdb:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        return "org.duckdb.DuckDBDriver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("DuckDB");
    }

    public DuckDBDatabase createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new DuckDBDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new DuckDBParser(configuration, parsingContext);
    }

    public String getPluginVersion(Configuration config) {
        return DuckDBDatabaseExtension.readVersion();
    }
}

