/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.rmic;

import gnu.classpath.tools.rmic.AbstractMethodGenerator;
import gnu.classpath.tools.rmic.SourceRmicCompiler;
import gnu.classpath.tools.rmic.WrapUnWrapper;
import gnu.java.rmi.server.RMIHashes;
import java.lang.reflect.Method;
import java.util.Properties;

public class RmiMethodGenerator
implements AbstractMethodGenerator {
    Method method;
    SourceRmicCompiler rmic;

    public RmiMethodGenerator(Method aMethod, SourceRmicCompiler aRmic) {
        this.method = aMethod;
        this.rmic = aRmic;
        if (this.method.getParameterTypes().length == 0) {
            this.rmic.addZeroSizeObjecArray = true;
        }
    }

    public String getArgumentList() {
        StringBuilder b = new StringBuilder();
        Class<?>[] args = this.method.getParameterTypes();
        int i = 0;
        while (i < args.length) {
            b.append(this.rmic.name(args[i]));
            b.append(" p" + i);
            if (i < args.length - 1) {
                b.append(", ");
            }
            ++i;
        }
        return b.toString();
    }

    public String getArgumentNames() {
        StringBuilder b = new StringBuilder();
        Class<?>[] args = this.method.getParameterTypes();
        int i = 0;
        while (i < args.length) {
            b.append(" p" + i);
            if (i < args.length - 1) {
                b.append(", ");
            }
            ++i;
        }
        return b.toString();
    }

    public String getThrows() {
        StringBuilder b = new StringBuilder();
        Class<?>[] args = this.method.getExceptionTypes();
        int i = 0;
        while (i < args.length) {
            b.append(this.rmic.name(args[i]));
            if (i < args.length - 1) {
                b.append(", ");
            }
            ++i;
        }
        return b.toString();
    }

    public String generateStubMethod() {
        String templateName;
        Properties vars = new Properties(this.rmic.vars);
        vars.put("#return_type", this.rmic.name(this.method.getReturnType()));
        vars.put("#method_name", this.method.getName());
        vars.put("#method_hash", this.getMethodHashCode());
        vars.put("#argument_list", this.getArgumentList());
        vars.put("#object_arg_list", this.getArgListAsObjectArray());
        vars.put("#declaring_class", this.rmic.name(this.method.getDeclaringClass()));
        vars.put("#class_arg_list", this.getArgListAsClassArray());
        String thr = this.getThrows();
        if (thr.length() > 0) {
            vars.put("#throws", "\n    throws " + thr);
        } else {
            vars.put("#throws", "");
        }
        if (this.method.getReturnType().equals(Void.TYPE)) {
            templateName = "Stub_12MethodVoid.jav";
        } else {
            templateName = "Stub_12Method.jav";
            vars.put("#return_statement", this.getReturnStatement());
        }
        String template = this.rmic.getResource(templateName);
        String generated = this.rmic.replaceAll(template, vars);
        return generated;
    }

    public String getStaticMethodDeclarations() {
        StringBuilder b = new StringBuilder();
        Class<?>[] args = this.method.getParameterTypes();
        int i = 0;
        while (i < args.length) {
            b.append("            ");
            b.append(this.rmic.name(args[i]));
            b.append(" ");
            b.append("p" + i);
            b.append(" = ");
            if (i < args.length - 1) {
                b.append("\n");
            }
            ++i;
        }
        return b.toString();
    }

    public String getArgListAsObjectArray() {
        Class<?>[] args = this.method.getParameterTypes();
        if (args.length == 0) {
            return "NO_ARGS";
        }
        StringBuilder b = new StringBuilder("new Object[] {");
        int i = 0;
        while (i < args.length) {
            if (!args[i].isPrimitive()) {
                b.append("p" + i);
            } else {
                b.append("new " + this.rmic.name(WrapUnWrapper.getWrappingClass(args[i])));
                b.append("(p" + i + ")");
            }
            if (i < args.length - 1) {
                b.append(", ");
            }
            ++i;
        }
        b.append("}");
        return b.toString();
    }

    public String getReturnStatement() {
        Class<?> r = this.method.getReturnType();
        if (r.equals(Void.TYPE)) {
            return "";
        }
        if (r.isPrimitive()) {
            String wcd = this.rmic.name(WrapUnWrapper.getWrappingClass(r));
            return "return ((" + wcd + ") result)." + WrapUnWrapper.getUnwrappingMethod(r) + ";";
        }
        return "return (" + this.rmic.name(r) + ") result;";
    }

    public String getArgListAsClassArray() {
        StringBuilder b = new StringBuilder();
        Class<?>[] args = this.method.getParameterTypes();
        int i = 0;
        while (i < args.length) {
            b.append(this.rmic.name(args[i]));
            b.append(".class");
            if (i < args.length - 1) {
                b.append(", ");
            }
            ++i;
        }
        return b.toString();
    }

    public String generateTieMethod() {
        throw new InternalError();
    }

    public String getMethodHashCode() {
        return String.valueOf(RMIHashes.getMethodHash((Method)this.method)) + "L";
    }

    public String convertStubName(String name) {
        return name;
    }
}

