/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.sig;

import gnu.java.security.jce.sig.KeyPairGeneratorAdapter;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.interfaces.DSAKeyPairGenerator;
import java.security.interfaces.DSAParams;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.util.HashMap;

public class DSSKeyPairGeneratorSpi
extends KeyPairGeneratorAdapter
implements DSAKeyPairGenerator {
    public DSSKeyPairGeneratorSpi() {
        super("dss");
    }

    public void initialize(int keysize, SecureRandom random) {
        this.initialize(keysize, false, random);
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (params != null) {
            if (!(params instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Parameters argument is not a non-null instance, or sub-instance, of java.security.spec.DSAParameterSpec");
            }
            attributes.put("gnu.crypto.dss.params", params);
        }
        if (random != null) {
            attributes.put("gnu.crypto.dss.prng", random);
        }
        attributes.put("gnu.crypto.dss.encoding", 4);
        try {
            this.adaptee.setup(attributes);
        }
        catch (IllegalArgumentException x) {
            throw new InvalidAlgorithmParameterException(x.getMessage(), x);
        }
    }

    public void initialize(DSAParams params, SecureRandom random) throws InvalidParameterException {
        if (params == null || !(params instanceof DSAParameterSpec)) {
            throw new InvalidParameterException("Parameters argument is either null or is not an instance, or sub-instance, of java.security.spec.DSAParameterSpec");
        }
        DSAParameterSpec spec = (DSAParameterSpec)params;
        try {
            this.initialize(spec, random);
        }
        catch (InvalidAlgorithmParameterException x) {
            InvalidParameterException y = new InvalidParameterException(x.getMessage());
            y.initCause(x);
            throw y;
        }
    }

    public void initialize(int modlen, boolean genParams, SecureRandom random) throws InvalidParameterException {
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        attributes.put("gnu.crypto.dss.L", Integer.valueOf(modlen));
        if (random != null) {
            attributes.put("gnu.crypto.dss.prng", random);
        }
        attributes.put("gnu.crypto.dss.use.defaults", Boolean.valueOf(!genParams));
        attributes.put("gnu.crypto.dss.strict.defaults", Boolean.TRUE);
        attributes.put("gnu.crypto.dss.encoding", Integer.valueOf(4));
        try {
            this.adaptee.setup(attributes);
        }
        catch (IllegalArgumentException x) {
            InvalidParameterException y = new InvalidParameterException(x.getMessage());
            y.initCause(x);
            throw y;
        }
    }
}

