/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.VMStackWalker;
import gnu.gcj.RawData;
import gnu.gcj.RawDataManaged;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Thread
implements Runnable {
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    ThreadGroup group;
    private Runnable runnable;
    String name;
    private boolean daemon;
    private int priority;
    boolean interrupt_flag;
    private static final byte THREAD_DEAD = 0;
    private static final byte THREAD_ALIVE = 1;
    private static final byte THREAD_SIGNALED = 2;
    private boolean startable_flag;
    private ClassLoader contextClassLoader;
    private final long threadId;
    private static long nextThreadId;
    private static long totalThreadsCreated;
    private static UncaughtExceptionHandler defaultHandler;
    ThreadLocalMap locals;
    UncaughtExceptionHandler exceptionHandler;
    private Object parkBlocker;
    static final byte THREAD_PARK_RUNNING = 0;
    static final byte THREAD_PARK_PERMIT = 1;
    static final byte THREAD_PARK_PARKED = 2;
    static final byte THREAD_PARK_DEAD = 3;
    Object accessControlState = null;
    RawData interp_frame;
    RawData frame;
    volatile int state;
    RawDataManaged data;

    public Thread() {
        this(null, null, Thread.gen_name());
    }

    public Thread(Runnable target) {
        this(null, target, Thread.gen_name());
    }

    public Thread(String name) {
        this(null, null, name);
    }

    public Thread(ThreadGroup group, Runnable target) {
        this(group, target, Thread.gen_name());
    }

    public Thread(ThreadGroup group, String name) {
        this(group, null, name);
    }

    public Thread(Runnable target, String name) {
        this(null, target, name);
    }

    public Thread(ThreadGroup group, Runnable target, String name) {
        this(Thread.currentThread(), group, target, name, false);
    }

    public Thread(ThreadGroup group, Runnable target, String name, long size) {
        this(Thread.currentThread(), group, target, name, false);
    }

    Thread(String name, boolean noInheritableThreadLocal) {
        this(null, null, null, name, noInheritableThreadLocal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread(Thread current, ThreadGroup g, Runnable r, String n, boolean noInheritableThreadLocal) {
        this.checkAccess();
        if (n == null) {
            throw new NullPointerException();
        }
        this.group = g == null ? (current == null ? ThreadGroup.root : current.getThreadGroup()) : g;
        this.data = null;
        this.interrupt_flag = false;
        this.startable_flag = true;
        Class<Thread> clazz = Thread.class;
        synchronized (Thread.class) {
            this.threadId = nextThreadId++;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            this.locals = new ThreadLocalMap();
            if (current != null) {
                this.group.checkAccess();
                this.daemon = current.isDaemon();
                int gmax = this.group.getMaxPriority();
                int pri = current.getPriority();
                this.priority = gmax < pri ? gmax : pri;
                this.contextClassLoader = current.contextClassLoader;
                if (!noInheritableThreadLocal) {
                    InheritableThreadLocal.newChildThread(this);
                }
            } else {
                this.daemon = false;
                this.priority = 5;
            }
            this.name = n;
            this.group.addThread(this);
            this.runnable = r;
            this.initialize_native();
            return;
        }
    }

    public static int activeCount() {
        return Thread.currentThread().group.activeCount();
    }

    public final void checkAccess() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkAccess(this);
        }
    }

    public native int countStackFrames();

    public static native Thread currentThread();

    public void destroy() {
        throw new NoSuchMethodError();
    }

    public static void dumpStack() {
        new Exception("Stack trace").printStackTrace();
    }

    public static int enumerate(Thread[] array) {
        return Thread.currentThread().group.enumerate(array);
    }

    public final String getName() {
        return this.name;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static native boolean holdsLock(Object var0);

    public native void interrupt();

    public static boolean interrupted() {
        return Thread.currentThread().isInterrupted(true);
    }

    public boolean isInterrupted() {
        return this.interrupt_flag;
    }

    public final native boolean isAlive();

    public final boolean isDaemon() {
        return this.daemon;
    }

    public final void join() throws InterruptedException {
        this.join(0L, 0);
    }

    public final void join(long ms) throws InterruptedException {
        this.join(ms, 0);
    }

    public final native void join(long var1, int var3) throws InterruptedException;

    public final native void resume();

    private final native void finish_();

    private boolean isInterrupted(boolean clear_flag) {
        boolean r = this.interrupt_flag;
        if (clear_flag && r) {
            this.interrupt_flag = false;
        }
        return r;
    }

    @Override
    public void run() {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public final void setDaemon(boolean daemon) {
        if (!this.startable_flag) {
            throw new IllegalThreadStateException();
        }
        this.checkAccess();
        this.daemon = daemon;
    }

    public synchronized ClassLoader getContextClassLoader() {
        ClassLoader cl;
        if (this.contextClassLoader == null) {
            this.contextClassLoader = ClassLoader.getSystemClassLoader();
        }
        SecurityManager sm = System.getSecurityManager();
        if (this.contextClassLoader != null && sm != null && (cl = VMStackWalker.getCallingClassLoader()) != null && !cl.isAncestorOf(this.contextClassLoader)) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
        }
        return this.contextClassLoader;
    }

    public synchronized void setContextClassLoader(ClassLoader classloader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        this.contextClassLoader = classloader;
    }

    public final void setName(String name) {
        this.checkAccess();
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
    }

    public static native void yield();

    public static void sleep(long ms) throws InterruptedException {
        Thread.sleep(ms, 0);
    }

    public static native void sleep(long var0, int var2) throws InterruptedException;

    public native void start();

    public final void stop() {
        this.stop(null);
    }

    public final native void stop(Throwable var1);

    public final native void suspend();

    public final native void setPriority(int var1);

    public String toString() {
        return "Thread[" + this.name + "," + this.priority + "," + (this.group == null ? "" : this.group.getName()) + "]";
    }

    private final native void initialize_native();

    private static final native String gen_name();

    static ThreadLocalMap getThreadLocals() {
        Thread thread = Thread.currentThread();
        ThreadLocalMap locals = thread.locals;
        return locals;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler h) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkAccess(this);
        }
        this.exceptionHandler = h;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.exceptionHandler != null ? this.exceptionHandler : this.group;
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler h) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setDefaultUncaughtExceptionHandler"));
        }
        defaultHandler = h;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultHandler;
    }

    public long getId() {
        return this.threadId;
    }

    public native State getState();

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        ThreadGroup group = Thread.currentThread().group;
        while (group.getParent() != null) {
            group = group.getParent();
        }
        int arraySize = group.activeCount();
        Thread[] threadList = new Thread[arraySize];
        int filled = group.enumerate(threadList);
        while (filled == arraySize) {
            threadList = new Thread[arraySize *= 2];
            filled = group.enumerate(threadList);
        }
        HashMap<Thread, StackTraceElement[]> traces = new HashMap<Thread, StackTraceElement[]>();
        int a = 0;
        while (a < filled) {
            traces.put(threadList[a], threadList[a].getStackTrace());
            ++a;
        }
        return traces;
    }

    public StackTraceElement[] getStackTrace() {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getStackTrace"));
        }
        try {
            try {
                Object bean = Class.forName("java.lang.management.ManagementFactory").getDeclaredMethod("getThreadMXBean", new Class[0]).invoke(null, new Object[0]);
                Object info = bean.getClass().getDeclaredMethod("getThreadInfo", Long.TYPE, Integer.TYPE).invoke(bean, new Long(this.getId()), new Integer(Integer.MAX_VALUE));
                Object trace = info.getClass().getDeclaredMethod("getStackTrace", new Class[0]).invoke(info, new Object[0]);
                return (StackTraceElement[])trace;
            }
            catch (InvocationTargetException e) {
                throw (Exception)e.getTargetException();
            }
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        BLOCKED,
        NEW,
        RUNNABLE,
        TERMINATED,
        TIMED_WAITING,
        WAITING;

    }

    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }
}

