/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Container;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class JEditorPane
extends JTextComponent {
    private static final long serialVersionUID = 3140472492599046285L;
    private EditorKit editorKit;
    boolean focus_root;
    static HashMap editorKits;
    static HashMap registerMap;
    HashMap editorMap;
    private PageLoader loader;

    static {
        registerMap = new HashMap();
        editorKits = new HashMap();
        JEditorPane.registerEditorKitForContentType("application/rtf", "javax.swing.text.rtf.RTFEditorKit");
        JEditorPane.registerEditorKitForContentType("text/plain", "javax.swing.JEditorPane$PlainEditorKit");
        JEditorPane.registerEditorKitForContentType("text/html", "javax.swing.text.html.HTMLEditorKit");
        JEditorPane.registerEditorKitForContentType("text/rtf", "javax.swing.text.rtf.RTFEditorKit");
    }

    public JEditorPane() {
        this.init();
        this.setEditorKit(this.createDefaultEditorKit());
    }

    public JEditorPane(String url) throws IOException {
        this(new URL(url));
    }

    public JEditorPane(String type, String text) {
        this.init();
        this.setEditorKit(JEditorPane.createEditorKitForContentType(type));
        this.setText(text);
    }

    public JEditorPane(URL url) throws IOException {
        this.init();
        this.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        this.setPage(url);
    }

    void init() {
        this.editorMap = new HashMap();
    }

    protected EditorKit createDefaultEditorKit() {
        return new PlainEditorKit();
    }

    public static EditorKit createEditorKitForContentType(String type) {
        EditorKit e = (EditorKit)editorKits.get(type);
        if (e == null) {
            EditorKitMapping m = (EditorKitMapping)registerMap.get(type);
            if (m != null) {
                String className = m.className;
                ClassLoader loader = m.classLoader;
                try {
                    e = (EditorKit)loader.loadClass(className).newInstance();
                }
                catch (Exception exception) {}
            }
            if (e != null) {
                editorKits.put(type, e);
            }
        }
        return e;
    }

    public void fireHyperlinkUpdate(HyperlinkEvent event) {
        HyperlinkListener[] listeners = this.getHyperlinkListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].hyperlinkUpdate(event);
            ++index;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = this.getEditorKit() instanceof HTMLEditorKit ? new AccessibleJEditorPaneHTML() : new AccessibleJEditorPane();
        }
        return this.accessibleContext;
    }

    public final String getContentType() {
        return this.getEditorKit().getContentType();
    }

    public EditorKit getEditorKit() {
        if (this.editorKit == null) {
            this.setEditorKit(this.createDefaultEditorKit());
        }
        return this.editorKit;
    }

    public static String getEditorKitClassNameForContentType(String type) {
        EditorKitMapping m = (EditorKitMapping)registerMap.get(type);
        String kitName = m != null ? m.className : null;
        return kitName;
    }

    public EditorKit getEditorKitForContentType(String type) {
        EditorKit e = (EditorKit)this.editorMap.get(type);
        if (e == null && (e = JEditorPane.createEditorKitForContentType(type)) != null) {
            this.setEditorKitForContentType(type, e);
        }
        if (e == null) {
            e = this.createDefaultEditorKit();
        }
        return e;
    }

    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            JViewport vp = (JViewport)this.getParent();
            TextUI ui = this.getUI();
            Dimension min = null;
            if (!this.getScrollableTracksViewportWidth()) {
                min = ui.getMinimumSize(this);
                int vpWidth = vp.getWidth();
                if (vpWidth != 0 && vpWidth < min.width) {
                    pref.width = min.width;
                }
            }
            if (!this.getScrollableTracksViewportHeight()) {
                int vpHeight;
                if (min == null) {
                    min = ui.getMinimumSize(this);
                }
                if ((vpHeight = vp.getHeight()) != 0 && vpHeight < min.height) {
                    pref.height = min.height;
                }
            }
        }
        return pref;
    }

    public boolean getScrollableTracksViewportHeight() {
        Container parent = this.getParent();
        int height = parent.getHeight();
        TextUI ui = this.getUI();
        return parent instanceof JViewport && height >= ui.getMinimumSize((JComponent)this).height && height <= ui.getMaximumSize((JComponent)this).height;
    }

    public boolean getScrollableTracksViewportWidth() {
        Container parent = this.getParent();
        return parent != null && parent instanceof JViewport && parent.getWidth() > this.getUI().getMinimumSize((JComponent)this).width;
    }

    public URL getPage() {
        return this.loader != null ? this.loader.page : null;
    }

    protected InputStream getStream(URL page) throws IOException {
        URLConnection conn = page.openConnection();
        String type = conn.getContentType();
        if (type != null) {
            this.setContentType(type);
        }
        InputStream stream = conn.getInputStream();
        return new BufferedInputStream(stream);
    }

    public String getText() {
        return super.getText();
    }

    public String getUIClassID() {
        return "EditorPaneUI";
    }

    public boolean isFocusCycleRoot() {
        return this.focus_root;
    }

    protected String paramString() {
        return "JEditorPane";
    }

    public void read(InputStream in, Object desc) throws IOException {
        EditorKit kit = this.getEditorKit();
        if (kit instanceof HTMLEditorKit && desc instanceof HTMLDocument) {
            HTMLDocument doc = (HTMLDocument)desc;
            this.setDocument(doc);
            try {
                InputStreamReader reader = new InputStreamReader(in);
                kit.read(reader, (Document)doc, 0);
            }
            catch (BadLocationException badLocationException) {
                assert (false) : "BadLocationException must not be thrown here.";
            }
        } else {
            InputStreamReader inRead = new InputStreamReader(in);
            super.read(inRead, desc);
        }
    }

    public static void registerEditorKitForContentType(String type, String classname) {
        JEditorPane.registerEditorKitForContentType(type, classname, Thread.currentThread().getContextClassLoader());
    }

    public static void registerEditorKitForContentType(String type, String classname, ClassLoader loader) {
        registerMap.put(type, new EditorKitMapping(classname, loader));
    }

    public void replaceSelection(String content) {
        super.replaceSelection(content);
    }

    public void scrollToReference(String reference) {
    }

    public final void setContentType(String type) {
        int paramIndex = type.indexOf(59);
        if (paramIndex > -1) {
            type = type.substring(0, paramIndex).trim();
        }
        if (this.editorKit != null && this.editorKit.getContentType().equals(type)) {
            return;
        }
        EditorKit kit = this.getEditorKitForContentType(type);
        if (kit != null) {
            this.setEditorKit(kit);
        }
    }

    public void setEditorKit(EditorKit newValue) {
        if (this.editorKit == newValue) {
            return;
        }
        if (this.editorKit != null) {
            this.editorKit.deinstall(this);
        }
        EditorKit oldValue = this.editorKit;
        this.editorKit = newValue;
        if (this.editorKit != null) {
            this.editorKit.install(this);
            this.setDocument(this.editorKit.createDefaultDocument());
        }
        this.firePropertyChange("editorKit", oldValue, newValue);
        this.invalidate();
        this.repaint();
        this.accessibleContext = null;
    }

    public void setEditorKitForContentType(String type, EditorKit k) {
        this.editorMap.put(type, k);
    }

    public void setPage(String url) throws IOException {
        this.setPage(new URL(url));
    }

    public void setPage(URL page) throws IOException {
        if (page == null) {
            throw new IOException("invalid url");
        }
        URL old = this.getPage();
        if (old == null || !old.sameFile(page)) {
            InputStream in = this.getStream(page);
            if (this.editorKit != null) {
                Document doc = this.editorKit.createDefaultDocument();
                doc.putProperty("stream", page);
                if (this.loader != null) {
                    this.loader.cancel();
                }
                this.loader = new PageLoader(doc, in, old, page);
                int prio = -1;
                if (doc instanceof AbstractDocument) {
                    AbstractDocument aDoc = (AbstractDocument)doc;
                    prio = aDoc.getAsynchronousLoadPriority();
                }
                if (prio >= 0) {
                    this.setDocument(doc);
                    Thread loadThread = new Thread(this.loader, "JEditorPane.PageLoader");
                    loadThread.setDaemon(true);
                    loadThread.setPriority(prio);
                    loadThread.start();
                } else {
                    this.loader.run();
                    this.setDocument(doc);
                }
            }
        }
    }

    public void setText(String t) {
        try {
            Document doc = this.getDocument();
            doc.remove(0, doc.getLength());
            if (t == null || t.equals("")) {
                return;
            }
            this.getEditorKit().read(new StringReader(t), doc, 0);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {}
    }

    public void addHyperlinkListener(HyperlinkListener listener) {
        this.listenerList.add(HyperlinkListener.class, listener);
    }

    public void removeHyperlinkListener(HyperlinkListener listener) {
        this.listenerList.remove(HyperlinkListener.class, listener);
    }

    public HyperlinkListener[] getHyperlinkListeners() {
        return (HyperlinkListener[])this.getListeners(HyperlinkListener.class);
    }

    protected class AccessibleJEditorPane
    extends JTextComponent.AccessibleJTextComponent {
        protected AccessibleJEditorPane() {
            super(JEditorPane.this);
        }

        public String getAccessibleDescription() {
            String descr = super.getAccessibleDescription();
            if (descr == null) {
                return JEditorPane.this.getContentType();
            }
            return descr;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet state = super.getAccessibleStateSet();
            return state;
        }
    }

    protected class AccessibleJEditorPaneHTML
    extends AccessibleJEditorPane {
        protected AccessibleJEditorPaneHTML() {
        }

        public AccessibleText getAccessibleText() {
            return new JEditorPaneAccessibleHypertextSupport();
        }
    }

    private static class EditorKitMapping {
        String className;
        ClassLoader classLoader;

        EditorKitMapping(String cn, ClassLoader cl) {
            this.className = cn;
            this.classLoader = cl;
        }
    }

    protected class JEditorPaneAccessibleHypertextSupport
    extends AccessibleJEditorPane
    implements AccessibleHypertext {
        public int getLinkCount() {
            HTMLDocument doc = (HTMLDocument)JEditorPane.this.getDocument();
            HTMLDocument.Iterator linkIter = doc.getIterator(HTML.Tag.A);
            int count = 0;
            while (linkIter.isValid()) {
                ++count;
                linkIter.next();
            }
            return count;
        }

        public AccessibleHyperlink getLink(int i) {
            HTMLDocument doc = (HTMLDocument)JEditorPane.this.getDocument();
            HTMLDocument.Iterator linkIter = doc.getIterator(HTML.Tag.A);
            int count = 0;
            while (linkIter.isValid()) {
                if (++count == i) break;
                linkIter.next();
            }
            if (linkIter.isValid()) {
                int offset = linkIter.getStartOffset();
                Element el = doc.getCharacterElement(offset);
                HTMLLink link = new HTMLLink(el);
                return link;
            }
            return null;
        }

        public int getLinkIndex(int c) {
            HTMLDocument doc = (HTMLDocument)JEditorPane.this.getDocument();
            HTMLDocument.Iterator linkIter = doc.getIterator(HTML.Tag.A);
            int count = 0;
            while (linkIter.isValid()) {
                if (linkIter.getStartOffset() <= c && linkIter.getEndOffset() > c) break;
                ++count;
                linkIter.next();
            }
            if (linkIter.isValid()) {
                return count;
            }
            return -1;
        }

        public String getLinkText(int i) {
            HTMLDocument doc = (HTMLDocument)JEditorPane.this.getDocument();
            HTMLDocument.Iterator linkIter = doc.getIterator(HTML.Tag.A);
            int count = 0;
            while (linkIter.isValid()) {
                if (++count == i) break;
                linkIter.next();
            }
            if (linkIter.isValid()) {
                int offset = linkIter.getStartOffset();
                Element el = doc.getCharacterElement(offset);
                try {
                    String text = doc.getText(el.getStartOffset(), el.getEndOffset() - el.getStartOffset());
                    return text;
                }
                catch (BadLocationException ex) {
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"BadLocationException must not be thrown here."))).initCause(ex));
                }
            }
            return null;
        }

        public class HTMLLink
        extends AccessibleHyperlink {
            Element element;

            public HTMLLink(Element el) {
                this.element = el;
            }

            public boolean isValid() {
                HTMLDocument doc = (HTMLDocument)JEditorPane.this.getDocument();
                return doc.getCharacterElement(this.element.getStartOffset()) == this.element;
            }

            public int getAccessibleActionCount() {
                return 1;
            }

            public boolean doAccessibleAction(int i) {
                String href = (String)this.element.getAttributes().getAttribute("href");
                HTMLDocument doc = (HTMLDocument)JEditorPane.this.getDocument();
                try {
                    URL url = new URL(doc.getBase(), href);
                    JEditorPane.this.setPage(url);
                    String desc = doc.getText(this.element.getStartOffset(), this.element.getEndOffset() - this.element.getStartOffset());
                    HyperlinkEvent ev = new HyperlinkEvent(JEditorPane.this, HyperlinkEvent.EventType.ACTIVATED, url, desc, this.element);
                    JEditorPane.this.fireHyperlinkUpdate(ev);
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public String getAccessibleActionDescription(int i) {
                HTMLDocument doc = (HTMLDocument)JEditorPane.this.getDocument();
                try {
                    return doc.getText(this.element.getStartOffset(), this.element.getEndOffset() - this.element.getStartOffset());
                }
                catch (BadLocationException ex) {
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"BadLocationException must not be thrown here."))).initCause(ex));
                }
            }

            public Object getAccessibleActionObject(int i) {
                String href = (String)this.element.getAttributes().getAttribute("href");
                HTMLDocument doc = (HTMLDocument)JEditorPane.this.getDocument();
                try {
                    URL url = new URL(doc.getBase(), href);
                    return url;
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }

            public Object getAccessibleActionAnchor(int i) {
                return this.getAccessibleActionDescription(i);
            }

            public int getStartIndex() {
                return this.element.getStartOffset();
            }

            public int getEndIndex() {
                return this.element.getEndOffset();
            }
        }
    }

    private class PageLoader
    implements Runnable {
        private Document doc;
        private PageStream in;
        private URL old;
        URL page;

        PageLoader(Document doc, InputStream in, URL old, URL page) {
            this.doc = doc;
            this.in = new PageStream(in);
            this.old = old;
            this.page = page;
        }

        public void run() {
            block11: {
                try {
                    try {
                        JEditorPane.this.read(this.in, (Object)this.doc);
                    }
                    catch (IOException iOException) {
                        UIManager.getLookAndFeel().provideErrorFeedback(JEditorPane.this);
                        if (SwingUtilities.isEventDispatchThread()) {
                            JEditorPane.this.firePropertyChange("page", this.old, this.page);
                        } else {
                            SwingUtilities.invokeLater(new Runnable(this){
                                final /* synthetic */ PageLoader this$1;
                                {
                                    this.this$1 = pageLoader;
                                }

                                public void run() {
                                    JEditorPane.access$0(PageLoader.access$1(this.this$1), "page", PageLoader.access$0(this.this$1), this.this$1.page);
                                }
                            });
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        JEditorPane.this.firePropertyChange("page", this.old, this.page);
                    } else {
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    throw throwable;
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    JEditorPane.this.firePropertyChange("page", this.old, this.page);
                } else {
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
        }

        void cancel() {
            this.in.cancel();
        }

        static /* synthetic */ URL access$0(PageLoader pageLoader) {
            return pageLoader.old;
        }

        static /* synthetic */ JEditorPane access$1(PageLoader pageLoader) {
            return pageLoader.JEditorPane.this;
        }
    }

    private class PageStream
    extends FilterInputStream {
        private boolean cancelled;

        protected PageStream(InputStream in) {
            super(in);
            this.cancelled = false;
        }

        private void checkCancelled() throws IOException {
            if (this.cancelled) {
                throw new IOException("Stream has been cancelled");
            }
        }

        void cancel() {
            this.cancelled = true;
        }

        public int read() throws IOException {
            this.checkCancelled();
            return super.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.checkCancelled();
            return super.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            this.checkCancelled();
            return super.skip(n);
        }

        public int available() throws IOException {
            this.checkCancelled();
            return super.available();
        }

        public void reset() throws IOException {
            this.checkCancelled();
            super.reset();
        }
    }

    private static class PlainEditorKit
    extends DefaultEditorKit {
        private PlainEditorKit() {
        }

        public ViewFactory getViewFactory() {
            return new ViewFactory(this){
                final /* synthetic */ PlainEditorKit this$1;
                {
                    this.this$1 = plainEditorKit;
                }

                public View create(Element el) {
                    return new WrappedPlainView(el);
                }
            };
        }
    }
}

