/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

import gnu.java.awt.color.ColorSpaceConverter;

public class GrayScaleConverter
implements ColorSpaceConverter {
    double[] coeff = new double[]{0.2125f, 0.7154f, 0.0721f};
    private static float[] D50 = new float[]{0.96422f, 1.0f, 0.82521f};

    public float[] toCIEXYZ(float[] in) {
        float g = in[0];
        if (g < 0.0f) {
            g += 1.0f;
        }
        float[] out = new float[]{g * D50[0], g * D50[1], g * D50[2]};
        return out;
    }

    public float[] toRGB(float[] in) {
        float[] out = new float[3];
        out[0] = in[0] <= 0.00304f ? in[0] * 12.92f : 1.055f * (float)Math.exp(0.4166666666666667 * Math.log(in[0])) - 0.055f;
        out[1] = out[2] = out[0];
        return out;
    }

    public float[] fromCIEXYZ(float[] in) {
        float[] temp = new float[]{3.1338f * in[0] - 1.6171f * in[1] - 0.4907f * in[2], -0.9785f * in[0] + 1.916f * in[1] + 0.0334f * in[2], 0.072f * in[0] - 0.229f * in[1] + 1.4056f * in[2]};
        float[] out = new float[1];
        int i = 0;
        while (i < 3) {
            out[0] = (float)((double)temp[i] * this.coeff[i]);
            ++i;
        }
        return out;
    }

    public float[] fromRGB(float[] in) {
        float[] out = new float[]{0.0f};
        int i = 0;
        while (i < 3) {
            float n = in[i];
            if (n < 0.0f) {
                n = 0.0f;
            }
            if (n > 1.0f) {
                n = 1.0f;
            }
            out[0] = n <= 0.03928f ? out[0] + (float)(this.coeff[i] * (double)n / 12.92) : out[0] + (float)(this.coeff[i] * Math.exp(2.4 * Math.log(((double)n + 0.055) / 1.055)));
            ++i;
        }
        return out;
    }
}

