/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkMainThread;
import java.awt.AWTEvent;
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.peer.ChoicePeer;

public class GtkChoicePeer
extends GtkComponentPeer
implements ChoicePeer {
    private int selected;

    public GtkChoicePeer(Choice c) {
        super(c);
        int count = c.getItemCount();
        if (count > 0) {
            int i = 0;
            while (i < count) {
                this.add(c.getItem(i), i);
                ++i;
            }
            this.selected = c.getSelectedIndex();
            if (this.selected >= 0) {
                this.select(this.selected);
            }
        } else {
            this.selected = -1;
        }
    }

    native void create();

    native int nativeGetSelected();

    native void connectSignals();

    native void selectNative(int var1);

    native void selectNativeUnlocked(int var1);

    public native void add(String var1, int var2);

    native void nativeRemove(int var1);

    native void nativeRemoveAll();

    public void select(int position) {
        if (Thread.currentThread() == GtkMainThread.mainThread) {
            this.selectNativeUnlocked(position);
        } else {
            this.selectNative(position);
        }
    }

    public void remove(int index) {
        if (index == 0 && this.selected == 0) {
            this.selected = -1;
        }
        this.nativeRemove(index);
    }

    public void removeAll() {
        this.selected = -1;
        this.nativeRemoveAll();
    }

    public void addItem(String item, int position) {
        this.add(item, position);
    }

    protected void postChoiceItemEvent(int index) {
        if (this.selected != index) {
            this.selected = index;
            this.postItemEvent(((Choice)this.awtComponent).getItem(this.selected), 1);
        }
    }

    public void handleEvent(AWTEvent event) {
        super.handleEvent(event);
        if (event instanceof ItemEvent && ((ItemEvent)event).getItemSelectable() == this.awtComponent && ((ItemEvent)event).getStateChange() == 1) {
            ((Choice)this.awtComponent).select(this.selected);
        }
    }
}

