/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.jpeg;

import gnu.javax.imageio.jpeg.DCT;
import gnu.javax.imageio.jpeg.HuffmanTable;
import gnu.javax.imageio.jpeg.JPEGException;
import gnu.javax.imageio.jpeg.JPEGImageInputStream;
import gnu.javax.imageio.jpeg.ZigZag;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;

public class JPEGComponent {
    public byte factorH;
    public byte factorV;
    public byte component_id;
    public byte quant_id;
    public int width = 0;
    public int height = 0;
    public int maxV = 0;
    public int maxH = 0;
    public HuffmanTable ACTable;
    public HuffmanTable DCTable;
    public int[] quantizationTable;
    public double previousDC = 0.0;
    ArrayList data = new ArrayList();

    public JPEGComponent(byte id, byte factorHorizontal, byte factorVertical, byte quantizationID) {
        this.component_id = id;
        this.factorH = factorHorizontal;
        this.factorV = factorVertical;
        this.quant_id = quantizationID;
    }

    public void padMCU(int index, int length) {
        double[] src = (double[])this.data.get(index - 1);
        int i = 0;
        while (i < length) {
            this.data.add(index, src);
            ++i;
        }
    }

    public void resetInterval() {
        this.previousDC = 0.0;
    }

    public void quantitizeData() {
        int i = 0;
        while (i < this.data.size()) {
            double[] mydata = (double[])this.data.get(i);
            int j = 0;
            while (j < mydata.length) {
                int n = j;
                mydata[n] = mydata[n] * (double)this.quantizationTable[j];
                ++j;
            }
            ++i;
        }
    }

    public void setDCTable(JPEGHuffmanTable table) {
        this.DCTable = new HuffmanTable(table);
    }

    public void setACTable(JPEGHuffmanTable table) {
        this.ACTable = new HuffmanTable(table);
    }

    public void idctData(DCT myDCT) {
        int i = 0;
        while (i < this.data.size()) {
            this.data.add(i, myDCT.fast_idct(ZigZag.decode8x8_map((double[])this.data.remove(i))));
            ++i;
        }
    }

    public void scaleByFactors() {
        int u;
        int j;
        double[][] dest;
        double[][] src;
        int i;
        int factorUpVertical = this.maxV / this.factorV;
        int factorUpHorizontal = this.maxH / this.factorH;
        if (factorUpVertical > 1) {
            i = 0;
            while (i < this.data.size()) {
                src = (double[][])this.data.remove(i);
                dest = new double[src.length * factorUpVertical][src[0].length];
                j = 0;
                while (j < src.length) {
                    u = 0;
                    while (u < factorUpVertical) {
                        dest[j * factorUpVertical + u] = src[j];
                        ++u;
                    }
                    ++j;
                }
                this.data.add(i, dest);
                ++i;
            }
        }
        if (factorUpHorizontal > 1) {
            i = 0;
            while (i < this.data.size()) {
                src = (double[][])this.data.remove(i);
                dest = new double[src.length][src[0].length * factorUpHorizontal];
                j = 0;
                while (j < src.length) {
                    u = 0;
                    while (u < src[0].length) {
                        int v = 0;
                        while (v < factorUpHorizontal) {
                            dest[j][u * factorUpHorizontal + v] = src[j][u];
                            ++v;
                        }
                        ++u;
                    }
                    ++j;
                }
                this.data.add(i, dest);
                ++i;
            }
        }
    }

    public void writeBlock(WritableRaster raster, double[][] data, int compIndex, int x, int y) {
        int yIndex = 0;
        while (yIndex < data.length) {
            int xIndex = 0;
            while (xIndex < data[yIndex].length) {
                if (x + xIndex < raster.getWidth() && y + yIndex < raster.getHeight()) {
                    raster.setSample(x + xIndex, y + yIndex, compIndex, data[yIndex][xIndex]);
                }
                ++xIndex;
            }
            ++yIndex;
        }
    }

    public void writeData(WritableRaster raster, int componentIndex) {
        int x = 0;
        int y = 0;
        int lastblockheight = 0;
        int incrementblock = 0;
        while (this.data.size() > 0) {
            int blockwidth = 0;
            int blockheight = 0;
            if (x >= raster.getWidth()) {
                x = 0;
                y += incrementblock;
            }
            int factorVIndex = 0;
            while (factorVIndex < this.factorV) {
                blockwidth = 0;
                int factorHIndex = 0;
                while (factorHIndex < this.factorH) {
                    double[][] blockdata = (double[][])this.data.remove(0);
                    this.writeBlock(raster, blockdata, componentIndex, x, y);
                    blockwidth += blockdata[0].length;
                    x += blockdata[0].length;
                    blockheight = blockdata.length;
                    ++factorHIndex;
                }
                y += blockheight;
                x -= blockwidth;
                lastblockheight += blockheight;
                ++factorVIndex;
            }
            y -= lastblockheight;
            incrementblock = lastblockheight;
            lastblockheight = 0;
            x += blockwidth;
        }
    }

    public void setQuantizationTable(int[] quanttable) {
        this.quantizationTable = quanttable;
    }

    public void readComponentMCU(JPEGImageInputStream stream) throws JPEGException, IOException {
        int i = 0;
        while (i < this.factorH * this.factorV) {
            double dc = this.decode_dc_coefficient(stream);
            double[] datablock = this.decode_ac_coefficients(stream);
            datablock[0] = dc;
            this.data.add(datablock);
            ++i;
        }
    }

    public double decode_dc_coefficient(JPEGImageInputStream JPEGStream) throws JPEGException, IOException {
        int t = this.DCTable.decode(JPEGStream);
        double diff = JPEGStream.readBits(t);
        diff = HuffmanTable.extend((int)diff, t);
        this.previousDC = diff = this.previousDC + diff;
        return diff;
    }

    public double[] decode_ac_coefficients(JPEGImageInputStream JPEGStream) throws JPEGException, IOException {
        double[] zz = new double[64];
        int k = 1;
        while (k < 64) {
            int s = this.ACTable.decode(JPEGStream);
            int r = s >> 4;
            if ((s &= 0xF) != 0) {
                k += r;
                r = (int)JPEGStream.readBits(s);
                s = HuffmanTable.extend(r, s);
                zz[k] = s;
            } else {
                if (r != 15) {
                    return zz;
                }
                k += 15;
            }
            ++k;
        }
        return zz;
    }
}

