/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ClientHello;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import java.nio.ByteBuffer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientHelloBuilder
extends ClientHello
implements Builder {
    public ClientHelloBuilder() {
        super(ByteBuffer.allocate(256));
    }

    @Override
    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().position(0).limit(this.length());
    }

    public void setVersion(ProtocolVersion version) {
        this.ensureCapacity(2);
        this.buffer.putShort(0, (short)version.rawValue());
    }

    public void setSessionId(byte[] buffer) {
        this.setSessionId(buffer, 0, buffer.length);
    }

    public void setSessionId(byte[] buffer, int offset, int length) {
        this.ensureCapacity(35 + length);
        int len = Math.min(32, length);
        this.buffer.put(34, (byte)len);
        this.buffer.position(35);
        this.buffer.put(buffer, offset, len);
    }

    public void setCipherSuites(List<CipherSuite> suites) {
        int off = this.getCipherSuitesOffset();
        this.ensureCapacity(off + 2 * suites.size() + 2);
        this.buffer.putShort(off, (short)(suites.size() * 2));
        int i = 2;
        for (CipherSuite suite : suites) {
            ((ByteBuffer)this.buffer.duplicate().position(off + i)).put(suite.id());
            i += 2;
        }
    }

    public void setCompressionMethods(List<CompressionMethod> methods) {
        int off = this.getCompressionMethodsOffset();
        this.ensureCapacity(off + methods.size() + 1);
        this.buffer.put(off, (byte)methods.size());
        for (CompressionMethod method : methods) {
            this.buffer.put(++off, (byte)method.getValue());
        }
    }

    public void setExtensionsLength(int length) {
        if (length < 0 || length > 16384) {
            throw new IllegalArgumentException("length must be nonnegative and not exceed 16384");
        }
        int needed = this.getExtensionsOffset() + 2 + length;
        if (this.buffer.capacity() < needed) {
            this.ensureCapacity(needed);
        }
        this.buffer.putShort(this.getExtensionsOffset(), (short)length);
    }

    public void setExtensions(ByteBuffer extensions) {
        int elen = extensions.getShort(0) & 0xFFFF;
        this.setExtensionsLength(elen);
        ((ByteBuffer)this.buffer.duplicate().position(this.getExtensionsOffset())).put(extensions);
    }

    public void setDisableExtensions(boolean disableExtensions) {
        this.disableExtensions = disableExtensions;
    }

    public void ensureCapacity(int length) {
        if (this.buffer.capacity() >= length) {
            return;
        }
        ByteBuffer newBuf = ByteBuffer.allocate(length);
        newBuf.put((ByteBuffer)this.buffer.position(0));
        newBuf.position(0);
        this.buffer = newBuf;
    }
}

