/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.security.action.GetPropertyAction;
import gnu.java.security.x509.X509CertPath;
import gnu.javax.net.ssl.NullManagerParameters;
import gnu.javax.net.ssl.StaticTrustAnchors;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;

public class X509TrustManagerFactory
extends TrustManagerFactorySpi {
    private static final String sep = AccessController.doPrivileged(new GetPropertyAction("file.separator"));
    private static final String JSSE_CERTS = String.valueOf(AccessController.doPrivileged(new GetPropertyAction("java.home"))) + sep + "lib" + sep + "security" + sep + "jssecerts";
    private static final String CA_CERTS = String.valueOf(AccessController.doPrivileged(new GetPropertyAction("java.home"))) + sep + "lib" + sep + "security" + sep + "cacerts";
    private Manager current;

    protected TrustManager[] engineGetTrustManagers() {
        if (this.current == null) {
            throw new IllegalStateException("not initialized");
        }
        return new TrustManager[]{this.current};
    }

    protected void engineInit(ManagerFactoryParameters params) throws InvalidAlgorithmParameterException {
        if (params instanceof StaticTrustAnchors) {
            this.current = new Manager(((StaticTrustAnchors)params).getCertificates());
        } else if (params instanceof NullManagerParameters) {
            this.current = new Manager(new X509Certificate[0]);
        } else {
            throw new InvalidAlgorithmParameterException();
        }
    }

    protected void engineInit(KeyStore store) throws KeyStoreException {
        if (store == null) {
            GetPropertyAction gpa = new GetPropertyAction("javax.net.ssl.trustStoreType");
            String s = AccessController.doPrivileged(gpa);
            if (s == null) {
                s = KeyStore.getDefaultType();
            }
            store = KeyStore.getInstance(s);
            try {
                String p;
                s = AccessController.doPrivileged(gpa.setParameters("javax.net.ssl.trustStore"));
                FileInputStream in = null;
                if (s == null) {
                    try {
                        in = new FileInputStream(JSSE_CERTS);
                    }
                    catch (IOException iOException) {
                        in = new FileInputStream(CA_CERTS);
                    }
                } else {
                    in = new FileInputStream(s);
                }
                store.load(in, (p = AccessController.doPrivileged(gpa.setParameters("javax.net.ssl.trustStorePassword"))) != null ? p.toCharArray() : null);
            }
            catch (IOException ioe) {
                throw new KeyStoreException(ioe);
            }
            catch (CertificateException ce) {
                throw new KeyStoreException(ce);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new KeyStoreException(nsae);
            }
        }
        LinkedList<X509Certificate> l = new LinkedList<X509Certificate>();
        Enumeration<String> aliases = store.aliases();
        while (aliases.hasMoreElements()) {
            Certificate c;
            String alias = aliases.nextElement();
            if (!store.isCertificateEntry(alias) || !((c = store.getCertificate(alias)) instanceof X509Certificate)) continue;
            l.add((X509Certificate)c);
        }
        X509TrustManagerFactory x509TrustManagerFactory = this;
        x509TrustManagerFactory.getClass();
        this.current = x509TrustManagerFactory.new Manager(l.toArray((S[])new X509Certificate[l.size()]));
    }

    private class Manager
    implements X509TrustManager {
        private final Set<TrustAnchor> anchors = new HashSet<TrustAnchor>();

        Manager(X509Certificate[] trusted) {
            if (trusted != null) {
                X509Certificate[] x509CertificateArray = trusted;
                int n = trusted.length;
                int n2 = 0;
                while (n2 < n) {
                    X509Certificate cert = x509CertificateArray[n2];
                    this.anchors.add(new TrustAnchor(cert, null));
                    ++n2;
                }
            }
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.checkTrusted(chain, authType);
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.checkTrusted(chain, authType);
        }

        public X509Certificate[] getAcceptedIssuers() {
            return this.anchors.toArray(new X509Certificate[this.anchors.size()]);
        }

        private void checkTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            CertPathValidator validator = null;
            try {
                validator = CertPathValidator.getInstance("PKIX");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new CertificateException(nsae);
            }
            X509CertPath path = new X509CertPath(Arrays.asList(chain));
            PKIXParameters params = null;
            try {
                params = new PKIXParameters(this.anchors);
                params.setRevocationEnabled(false);
            }
            catch (InvalidAlgorithmParameterException iape) {
                throw new CertificateException(iape);
            }
            try {
                validator.validate(path, params);
            }
            catch (CertPathValidatorException cpve) {
                throw new CertificateException(cpve);
            }
            catch (InvalidAlgorithmParameterException iape) {
                throw new CertificateException(iape);
            }
        }
    }
}

