/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class DateType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    DateType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "date"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        int len = value.length();
        int state = 0;
        int start = 0;
        int i = 0;
        while (i < len) {
            block13: {
                char c = value.charAt(i);
                if (c == '-' && i == 0) {
                    ++start;
                } else if (c < '0' || c > '9') {
                    switch (state) {
                        case 0: {
                            if (c != '-') break;
                            String year = value.substring(start, i);
                            if ("0000".equals(year) || year.length() < 4) {
                                throw new DatatypeException(i, "invalid date value");
                            }
                            state = 1;
                            start = i + 1;
                            break block13;
                        }
                        case 1: {
                            if (c != '-') break;
                            if (i - start != 2) {
                                throw new DatatypeException(i, "invalid date value");
                            }
                            state = 2;
                            start = i + 1;
                            break block13;
                        }
                    }
                    throw new DatatypeException(i, "invalid date value");
                }
            }
            ++i;
        }
        switch (state) {
            case 2: {
                if (len - start == 2) break;
                throw new DatatypeException("invalid date value");
            }
            default: {
                throw new DatatypeException("invalid date value");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object createValue(String value, ValidationContext context) {
        int len = value.length();
        int state = 0;
        int start = 0;
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        try {
            int i;
            String timezone;
            block14: {
                TimeZone tz;
                int i2 = 0;
                while (true) {
                    if (i2 >= len) {
                        if (len - start <= 0) return cal.getTime();
                        if (state != 7) return cal.getTime();
                        timezone = value.substring(len - start);
                        i = timezone.indexOf(58);
                        if (i == -1) {
                            if ("Z".equals(timezone)) {
                                timezone = "UTC";
                            }
                            if ((tz = TimeZone.getTimeZone(timezone)) != null) break;
                            return null;
                        }
                        break block14;
                    }
                    char c = value.charAt(i2);
                    if (c == '-' && i2 == 0) {
                        ++start;
                    } else if (c < '0' || c > '9') {
                        switch (state) {
                            case 0: {
                                if (c != '-') break;
                                cal.set(1, Integer.parseInt(value.substring(0, i2)));
                                state = 1;
                                start = i2 + 1;
                                break;
                            }
                            case 1: {
                                if (c != '-') break;
                                cal.set(2, Integer.parseInt(value.substring(start, i2)));
                                state = 2;
                                start = i2 + 1;
                                break;
                            }
                            case 2: {
                                if (c != 'T') break;
                                cal.set(5, Integer.parseInt(value.substring(start, i2)));
                                state = 7;
                                start = i2 + 1;
                                break;
                            }
                        }
                    }
                    ++i2;
                }
                cal.set(15, tz.getRawOffset());
                return cal.getTime();
            }
            String tzh = timezone.substring(0, i);
            String tzm = timezone.substring(i + 1);
            int offset = Integer.parseInt(tzh) * 360000;
            offset = offset < 0 ? (offset -= Integer.parseInt(tzm) * 60000) : (offset += Integer.parseInt(tzm) * 60000);
            cal.set(15, offset);
            return cal.getTime();
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

